/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Runtime {
    NODEJS("nodejs"),
    NODEJS4_3("nodejs4.3"),
    NODEJS6_10("nodejs6.10"),
    NODEJS8_10("nodejs8.10"),
    NODEJS10_X("nodejs10.x"),
    NODEJS12_X("nodejs12.x"),
    NODEJS14_X("nodejs14.x"),
    NODEJS16_X("nodejs16.x"),
    JAVA8("java8"),
    JAVA8_AL2("java8.al2"),
    JAVA11("java11"),
    PYTHON2_7("python2.7"),
    PYTHON3_6("python3.6"),
    PYTHON3_7("python3.7"),
    PYTHON3_8("python3.8"),
    PYTHON3_9("python3.9"),
    DOTNETCORE1_0("dotnetcore1.0"),
    DOTNETCORE2_0("dotnetcore2.0"),
    DOTNETCORE2_1("dotnetcore2.1"),
    DOTNETCORE3_1("dotnetcore3.1"),
    DOTNET6("dotnet6"),
    DOTNET8("dotnet8"),
    NODEJS4_3_EDGE("nodejs4.3-edge"),
    GO1_X("go1.x"),
    RUBY2_5("ruby2.5"),
    RUBY2_7("ruby2.7"),
    PROVIDED("provided"),
    PROVIDED_AL2("provided.al2"),
    NODEJS18_X("nodejs18.x"),
    PYTHON3_10("python3.10"),
    JAVA17("java17"),
    RUBY3_2("ruby3.2"),
    PYTHON3_11("python3.11"),
    NODEJS20_X("nodejs20.x"),
    PROVIDED_AL2023("provided.al2023"),
    PYTHON3_12("python3.12"),
    JAVA21("java21"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Runtime> VALUE_MAP;
    private final String value;

    private Runtime(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Runtime fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Runtime> knownValues() {
        EnumSet<Runtime> knownValues = EnumSet.allOf(Runtime.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Runtime.class, Runtime::toString);
    }
}

