/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.RuntimeVersionError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuntimeVersionConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuntimeVersionConfig> {
    private static final SdkField<String> RUNTIME_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeVersionArn").getter(RuntimeVersionConfig.getter(RuntimeVersionConfig::runtimeVersionArn)).setter(RuntimeVersionConfig.setter(Builder::runtimeVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersionArn").build()}).build();
    private static final SdkField<RuntimeVersionError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(RuntimeVersionConfig.getter(RuntimeVersionConfig::error)).setter(RuntimeVersionConfig.setter(Builder::error)).constructor(RuntimeVersionError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_VERSION_ARN_FIELD, ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String runtimeVersionArn;
    private final RuntimeVersionError error;

    private RuntimeVersionConfig(BuilderImpl builder) {
        this.runtimeVersionArn = builder.runtimeVersionArn;
        this.error = builder.error;
    }

    public final String runtimeVersionArn() {
        return this.runtimeVersionArn;
    }

    public final RuntimeVersionError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeVersionConfig)) {
            return false;
        }
        RuntimeVersionConfig other = (RuntimeVersionConfig)obj;
        return Objects.equals(this.runtimeVersionArn(), other.runtimeVersionArn()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"RuntimeVersionConfig").add("RuntimeVersionArn", (Object)this.runtimeVersionArn()).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuntimeVersionArn": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersionArn()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuntimeVersionConfig, T> g) {
        return obj -> g.apply((RuntimeVersionConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String runtimeVersionArn;
        private RuntimeVersionError error;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeVersionConfig model) {
            this.runtimeVersionArn(model.runtimeVersionArn);
            this.error(model.error);
        }

        public final String getRuntimeVersionArn() {
            return this.runtimeVersionArn;
        }

        public final void setRuntimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
        }

        @Override
        public final Builder runtimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
            return this;
        }

        public final RuntimeVersionError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(RuntimeVersionError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(RuntimeVersionError error) {
            this.error = error;
            return this;
        }

        public RuntimeVersionConfig build() {
            return new RuntimeVersionConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuntimeVersionConfig> {
        public Builder runtimeVersionArn(String var1);

        public Builder error(RuntimeVersionError var1);

        default public Builder error(Consumer<RuntimeVersionError.Builder> error) {
            return this.error((RuntimeVersionError)((RuntimeVersionError.Builder)RuntimeVersionError.builder().applyMutation(error)).build());
        }
    }
}

