/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFunctionRecursionConfigRequest extends LambdaRequest implements
        ToCopyableBuilder<PutFunctionRecursionConfigRequest.Builder, PutFunctionRecursionConfigRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(PutFunctionRecursionConfigRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> RECURSIVE_LOOP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecursiveLoop").getter(getter(PutFunctionRecursionConfigRequest::recursiveLoopAsString))
            .setter(setter(Builder::recursiveLoop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecursiveLoop").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            RECURSIVE_LOOP_FIELD));

    private final String functionName;

    private final String recursiveLoop;

    private PutFunctionRecursionConfigRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.recursiveLoop = builder.recursiveLoop;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> – <code>my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name or ARN of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> – <code>my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * If you set your function's recursive loop detection configuration to <code>Allow</code>, Lambda doesn't take any
     * action when it detects your function being invoked as part of a recursive loop. We recommend that you only use
     * this setting if your design intentionally uses a Lambda function to write data back to the same Amazon Web
     * Services resource that invokes it.
     * </p>
     * <p>
     * If you set your function's recursive loop detection configuration to <code>Terminate</code>, Lambda stops your
     * function being invoked and notifies you when it detects your function being invoked as part of a recursive loop.
     * </p>
     * <p>
     * By default, Lambda sets your function's configuration to <code>Terminate</code>.
     * </p>
     * <important>
     * <p>
     * If your design intentionally uses a Lambda function to write data back to the same Amazon Web Services resource
     * that invokes the function, then use caution and implement suitable guard rails to prevent unexpected charges
     * being billed to your Amazon Web Services account. To learn more about best practices for using recursive
     * invocation patterns, see <a
     * href="https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway"
     * >Recursive patterns that cause run-away Lambda functions</a> in Serverless Land.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recursiveLoop}
     * will return {@link RecursiveLoop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recursiveLoopAsString}.
     * </p>
     * 
     * @return If you set your function's recursive loop detection configuration to <code>Allow</code>, Lambda doesn't
     *         take any action when it detects your function being invoked as part of a recursive loop. We recommend
     *         that you only use this setting if your design intentionally uses a Lambda function to write data back to
     *         the same Amazon Web Services resource that invokes it.</p>
     *         <p>
     *         If you set your function's recursive loop detection configuration to <code>Terminate</code>, Lambda stops
     *         your function being invoked and notifies you when it detects your function being invoked as part of a
     *         recursive loop.
     *         </p>
     *         <p>
     *         By default, Lambda sets your function's configuration to <code>Terminate</code>.
     *         </p>
     *         <important>
     *         <p>
     *         If your design intentionally uses a Lambda function to write data back to the same Amazon Web Services
     *         resource that invokes the function, then use caution and implement suitable guard rails to prevent
     *         unexpected charges being billed to your Amazon Web Services account. To learn more about best practices
     *         for using recursive invocation patterns, see <a href=
     *         "https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway"
     *         >Recursive patterns that cause run-away Lambda functions</a> in Serverless Land.
     *         </p>
     * @see RecursiveLoop
     */
    public final RecursiveLoop recursiveLoop() {
        return RecursiveLoop.fromValue(recursiveLoop);
    }

    /**
     * <p>
     * If you set your function's recursive loop detection configuration to <code>Allow</code>, Lambda doesn't take any
     * action when it detects your function being invoked as part of a recursive loop. We recommend that you only use
     * this setting if your design intentionally uses a Lambda function to write data back to the same Amazon Web
     * Services resource that invokes it.
     * </p>
     * <p>
     * If you set your function's recursive loop detection configuration to <code>Terminate</code>, Lambda stops your
     * function being invoked and notifies you when it detects your function being invoked as part of a recursive loop.
     * </p>
     * <p>
     * By default, Lambda sets your function's configuration to <code>Terminate</code>.
     * </p>
     * <important>
     * <p>
     * If your design intentionally uses a Lambda function to write data back to the same Amazon Web Services resource
     * that invokes the function, then use caution and implement suitable guard rails to prevent unexpected charges
     * being billed to your Amazon Web Services account. To learn more about best practices for using recursive
     * invocation patterns, see <a
     * href="https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway"
     * >Recursive patterns that cause run-away Lambda functions</a> in Serverless Land.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recursiveLoop}
     * will return {@link RecursiveLoop#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #recursiveLoopAsString}.
     * </p>
     * 
     * @return If you set your function's recursive loop detection configuration to <code>Allow</code>, Lambda doesn't
     *         take any action when it detects your function being invoked as part of a recursive loop. We recommend
     *         that you only use this setting if your design intentionally uses a Lambda function to write data back to
     *         the same Amazon Web Services resource that invokes it.</p>
     *         <p>
     *         If you set your function's recursive loop detection configuration to <code>Terminate</code>, Lambda stops
     *         your function being invoked and notifies you when it detects your function being invoked as part of a
     *         recursive loop.
     *         </p>
     *         <p>
     *         By default, Lambda sets your function's configuration to <code>Terminate</code>.
     *         </p>
     *         <important>
     *         <p>
     *         If your design intentionally uses a Lambda function to write data back to the same Amazon Web Services
     *         resource that invokes the function, then use caution and implement suitable guard rails to prevent
     *         unexpected charges being billed to your Amazon Web Services account. To learn more about best practices
     *         for using recursive invocation patterns, see <a href=
     *         "https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway"
     *         >Recursive patterns that cause run-away Lambda functions</a> in Serverless Land.
     *         </p>
     * @see RecursiveLoop
     */
    public final String recursiveLoopAsString() {
        return recursiveLoop;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(recursiveLoopAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionRecursionConfigRequest)) {
            return false;
        }
        PutFunctionRecursionConfigRequest other = (PutFunctionRecursionConfigRequest) obj;
        return Objects.equals(functionName(), other.functionName())
                && Objects.equals(recursiveLoopAsString(), other.recursiveLoopAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFunctionRecursionConfigRequest").add("FunctionName", functionName())
                .add("RecursiveLoop", recursiveLoopAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "RecursiveLoop":
            return Optional.ofNullable(clazz.cast(recursiveLoopAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionRecursionConfigRequest, T> g) {
        return obj -> g.apply((PutFunctionRecursionConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutFunctionRecursionConfigRequest> {
        /**
         * <p>
         * The name or ARN of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> – <code>my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> – <code>my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * If you set your function's recursive loop detection configuration to <code>Allow</code>, Lambda doesn't take
         * any action when it detects your function being invoked as part of a recursive loop. We recommend that you
         * only use this setting if your design intentionally uses a Lambda function to write data back to the same
         * Amazon Web Services resource that invokes it.
         * </p>
         * <p>
         * If you set your function's recursive loop detection configuration to <code>Terminate</code>, Lambda stops
         * your function being invoked and notifies you when it detects your function being invoked as part of a
         * recursive loop.
         * </p>
         * <p>
         * By default, Lambda sets your function's configuration to <code>Terminate</code>.
         * </p>
         * <important>
         * <p>
         * If your design intentionally uses a Lambda function to write data back to the same Amazon Web Services
         * resource that invokes the function, then use caution and implement suitable guard rails to prevent unexpected
         * charges being billed to your Amazon Web Services account. To learn more about best practices for using
         * recursive invocation patterns, see <a
         * href="https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway"
         * >Recursive patterns that cause run-away Lambda functions</a> in Serverless Land.
         * </p>
         * </important>
         * 
         * @param recursiveLoop
         *        If you set your function's recursive loop detection configuration to <code>Allow</code>, Lambda
         *        doesn't take any action when it detects your function being invoked as part of a recursive loop. We
         *        recommend that you only use this setting if your design intentionally uses a Lambda function to write
         *        data back to the same Amazon Web Services resource that invokes it.</p>
         *        <p>
         *        If you set your function's recursive loop detection configuration to <code>Terminate</code>, Lambda
         *        stops your function being invoked and notifies you when it detects your function being invoked as part
         *        of a recursive loop.
         *        </p>
         *        <p>
         *        By default, Lambda sets your function's configuration to <code>Terminate</code>.
         *        </p>
         *        <important>
         *        <p>
         *        If your design intentionally uses a Lambda function to write data back to the same Amazon Web Services
         *        resource that invokes the function, then use caution and implement suitable guard rails to prevent
         *        unexpected charges being billed to your Amazon Web Services account. To learn more about best
         *        practices for using recursive invocation patterns, see <a href=
         *        "https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway"
         *        >Recursive patterns that cause run-away Lambda functions</a> in Serverless Land.
         *        </p>
         * @see RecursiveLoop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecursiveLoop
         */
        Builder recursiveLoop(String recursiveLoop);

        /**
         * <p>
         * If you set your function's recursive loop detection configuration to <code>Allow</code>, Lambda doesn't take
         * any action when it detects your function being invoked as part of a recursive loop. We recommend that you
         * only use this setting if your design intentionally uses a Lambda function to write data back to the same
         * Amazon Web Services resource that invokes it.
         * </p>
         * <p>
         * If you set your function's recursive loop detection configuration to <code>Terminate</code>, Lambda stops
         * your function being invoked and notifies you when it detects your function being invoked as part of a
         * recursive loop.
         * </p>
         * <p>
         * By default, Lambda sets your function's configuration to <code>Terminate</code>.
         * </p>
         * <important>
         * <p>
         * If your design intentionally uses a Lambda function to write data back to the same Amazon Web Services
         * resource that invokes the function, then use caution and implement suitable guard rails to prevent unexpected
         * charges being billed to your Amazon Web Services account. To learn more about best practices for using
         * recursive invocation patterns, see <a
         * href="https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway"
         * >Recursive patterns that cause run-away Lambda functions</a> in Serverless Land.
         * </p>
         * </important>
         * 
         * @param recursiveLoop
         *        If you set your function's recursive loop detection configuration to <code>Allow</code>, Lambda
         *        doesn't take any action when it detects your function being invoked as part of a recursive loop. We
         *        recommend that you only use this setting if your design intentionally uses a Lambda function to write
         *        data back to the same Amazon Web Services resource that invokes it.</p>
         *        <p>
         *        If you set your function's recursive loop detection configuration to <code>Terminate</code>, Lambda
         *        stops your function being invoked and notifies you when it detects your function being invoked as part
         *        of a recursive loop.
         *        </p>
         *        <p>
         *        By default, Lambda sets your function's configuration to <code>Terminate</code>.
         *        </p>
         *        <important>
         *        <p>
         *        If your design intentionally uses a Lambda function to write data back to the same Amazon Web Services
         *        resource that invokes the function, then use caution and implement suitable guard rails to prevent
         *        unexpected charges being billed to your Amazon Web Services account. To learn more about best
         *        practices for using recursive invocation patterns, see <a href=
         *        "https://serverlessland.com/content/service/lambda/guides/aws-lambda-operator-guide/recursive-runaway"
         *        >Recursive patterns that cause run-away Lambda functions</a> in Serverless Land.
         *        </p>
         * @see RecursiveLoop
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecursiveLoop
         */
        Builder recursiveLoop(RecursiveLoop recursiveLoop);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String recursiveLoop;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionRecursionConfigRequest model) {
            super(model);
            functionName(model.functionName);
            recursiveLoop(model.recursiveLoop);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getRecursiveLoop() {
            return recursiveLoop;
        }

        public final void setRecursiveLoop(String recursiveLoop) {
            this.recursiveLoop = recursiveLoop;
        }

        @Override
        public final Builder recursiveLoop(String recursiveLoop) {
            this.recursiveLoop = recursiveLoop;
            return this;
        }

        @Override
        public final Builder recursiveLoop(RecursiveLoop recursiveLoop) {
            this.recursiveLoop(recursiveLoop == null ? null : recursiveLoop.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFunctionRecursionConfigRequest build() {
            return new PutFunctionRecursionConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
