/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a function's deployment package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionCodeLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionCodeLocation.Builder, FunctionCodeLocation> {
    private static final SdkField<String> REPOSITORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryType").getter(getter(FunctionCodeLocation::repositoryType))
            .setter(setter(Builder::repositoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryType").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(FunctionCodeLocation::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageUri").getter(getter(FunctionCodeLocation::imageUri)).setter(setter(Builder::imageUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()).build();

    private static final SdkField<String> RESOLVED_IMAGE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolvedImageUri").getter(getter(FunctionCodeLocation::resolvedImageUri))
            .setter(setter(Builder::resolvedImageUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedImageUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_TYPE_FIELD,
            LOCATION_FIELD, IMAGE_URI_FIELD, RESOLVED_IMAGE_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryType;

    private final String location;

    private final String imageUri;

    private final String resolvedImageUri;

    private FunctionCodeLocation(BuilderImpl builder) {
        this.repositoryType = builder.repositoryType;
        this.location = builder.location;
        this.imageUri = builder.imageUri;
        this.resolvedImageUri = builder.resolvedImageUri;
    }

    /**
     * <p>
     * The service that's hosting the file.
     * </p>
     * 
     * @return The service that's hosting the file.
     */
    public final String repositoryType() {
        return repositoryType;
    }

    /**
     * <p>
     * A presigned URL that you can use to download the deployment package.
     * </p>
     * 
     * @return A presigned URL that you can use to download the deployment package.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * URI of a container image in the Amazon ECR registry.
     * </p>
     * 
     * @return URI of a container image in the Amazon ECR registry.
     */
    public final String imageUri() {
        return imageUri;
    }

    /**
     * <p>
     * The resolved URI for the image.
     * </p>
     * 
     * @return The resolved URI for the image.
     */
    public final String resolvedImageUri() {
        return resolvedImageUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryType());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(resolvedImageUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCodeLocation)) {
            return false;
        }
        FunctionCodeLocation other = (FunctionCodeLocation) obj;
        return Objects.equals(repositoryType(), other.repositoryType()) && Objects.equals(location(), other.location())
                && Objects.equals(imageUri(), other.imageUri()) && Objects.equals(resolvedImageUri(), other.resolvedImageUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FunctionCodeLocation").add("RepositoryType", repositoryType()).add("Location", location())
                .add("ImageUri", imageUri()).add("ResolvedImageUri", resolvedImageUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryType":
            return Optional.ofNullable(clazz.cast(repositoryType()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "ImageUri":
            return Optional.ofNullable(clazz.cast(imageUri()));
        case "ResolvedImageUri":
            return Optional.ofNullable(clazz.cast(resolvedImageUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionCodeLocation, T> g) {
        return obj -> g.apply((FunctionCodeLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionCodeLocation> {
        /**
         * <p>
         * The service that's hosting the file.
         * </p>
         * 
         * @param repositoryType
         *        The service that's hosting the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryType(String repositoryType);

        /**
         * <p>
         * A presigned URL that you can use to download the deployment package.
         * </p>
         * 
         * @param location
         *        A presigned URL that you can use to download the deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * URI of a container image in the Amazon ECR registry.
         * </p>
         * 
         * @param imageUri
         *        URI of a container image in the Amazon ECR registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUri(String imageUri);

        /**
         * <p>
         * The resolved URI for the image.
         * </p>
         * 
         * @param resolvedImageUri
         *        The resolved URI for the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedImageUri(String resolvedImageUri);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryType;

        private String location;

        private String imageUri;

        private String resolvedImageUri;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCodeLocation model) {
            repositoryType(model.repositoryType);
            location(model.location);
            imageUri(model.imageUri);
            resolvedImageUri(model.resolvedImageUri);
        }

        public final String getRepositoryType() {
            return repositoryType;
        }

        public final void setRepositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
        }

        @Override
        public final Builder repositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getImageUri() {
            return imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final String getResolvedImageUri() {
            return resolvedImageUri;
        }

        public final void setResolvedImageUri(String resolvedImageUri) {
            this.resolvedImageUri = resolvedImageUri;
        }

        @Override
        public final Builder resolvedImageUri(String resolvedImageUri) {
            this.resolvedImageUri = resolvedImageUri;
            return this;
        }

        @Override
        public FunctionCodeLocation build() {
            return new FunctionCodeLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
