/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.PublicAccessBlockConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutPublicAccessBlockConfigRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, PutPublicAccessBlockConfigRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(PutPublicAccessBlockConfigRequest.getter(PutPublicAccessBlockConfigRequest::resourceArn)).setter(PutPublicAccessBlockConfigRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceArn").build()}).build();
    private static final SdkField<PublicAccessBlockConfig> PUBLIC_ACCESS_BLOCK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccessBlockConfig").getter(PutPublicAccessBlockConfigRequest.getter(PutPublicAccessBlockConfigRequest::publicAccessBlockConfig)).setter(PutPublicAccessBlockConfigRequest.setter(Builder::publicAccessBlockConfig)).constructor(PublicAccessBlockConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, PUBLIC_ACCESS_BLOCK_CONFIG_FIELD));
    private final String resourceArn;
    private final PublicAccessBlockConfig publicAccessBlockConfig;

    private PutPublicAccessBlockConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.publicAccessBlockConfig = builder.publicAccessBlockConfig;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final PublicAccessBlockConfig publicAccessBlockConfig() {
        return this.publicAccessBlockConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccessBlockConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPublicAccessBlockConfigRequest)) {
            return false;
        }
        PutPublicAccessBlockConfigRequest other = (PutPublicAccessBlockConfigRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.publicAccessBlockConfig(), other.publicAccessBlockConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PutPublicAccessBlockConfigRequest").add("ResourceArn", (Object)this.resourceArn()).add("PublicAccessBlockConfig", (Object)this.publicAccessBlockConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "PublicAccessBlockConfig": {
                return Optional.ofNullable(clazz.cast(this.publicAccessBlockConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPublicAccessBlockConfigRequest, T> g) {
        return obj -> g.apply((PutPublicAccessBlockConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private PublicAccessBlockConfig publicAccessBlockConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPublicAccessBlockConfigRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.publicAccessBlockConfig(model.publicAccessBlockConfig);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final PublicAccessBlockConfig.Builder getPublicAccessBlockConfig() {
            return this.publicAccessBlockConfig != null ? this.publicAccessBlockConfig.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfig(PublicAccessBlockConfig.BuilderImpl publicAccessBlockConfig) {
            this.publicAccessBlockConfig = publicAccessBlockConfig != null ? publicAccessBlockConfig.build() : null;
        }

        @Override
        public final Builder publicAccessBlockConfig(PublicAccessBlockConfig publicAccessBlockConfig) {
            this.publicAccessBlockConfig = publicAccessBlockConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPublicAccessBlockConfigRequest build() {
            return new PutPublicAccessBlockConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutPublicAccessBlockConfigRequest> {
        public Builder resourceArn(String var1);

        public Builder publicAccessBlockConfig(PublicAccessBlockConfig var1);

        default public Builder publicAccessBlockConfig(Consumer<PublicAccessBlockConfig.Builder> publicAccessBlockConfig) {
            return this.publicAccessBlockConfig((PublicAccessBlockConfig)((PublicAccessBlockConfig.Builder)PublicAccessBlockConfig.builder().applyMutation(publicAccessBlockConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

