/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPublicAccessBlockConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<PutPublicAccessBlockConfigResponse.Builder, PutPublicAccessBlockConfigResponse> {
    private static final SdkField<PublicAccessBlockConfig> PUBLIC_ACCESS_BLOCK_CONFIG_FIELD = SdkField
            .<PublicAccessBlockConfig> builder(MarshallingType.SDK_POJO).memberName("PublicAccessBlockConfig")
            .getter(getter(PutPublicAccessBlockConfigResponse::publicAccessBlockConfig))
            .setter(setter(Builder::publicAccessBlockConfig)).constructor(PublicAccessBlockConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicAccessBlockConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PUBLIC_ACCESS_BLOCK_CONFIG_FIELD));

    private final PublicAccessBlockConfig publicAccessBlockConfig;

    private PutPublicAccessBlockConfigResponse(BuilderImpl builder) {
        super(builder);
        this.publicAccessBlockConfig = builder.publicAccessBlockConfig;
    }

    /**
     * <p>
     * The public-access settings Lambda applied to your function.
     * </p>
     * 
     * @return The public-access settings Lambda applied to your function.
     */
    public final PublicAccessBlockConfig publicAccessBlockConfig() {
        return publicAccessBlockConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publicAccessBlockConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPublicAccessBlockConfigResponse)) {
            return false;
        }
        PutPublicAccessBlockConfigResponse other = (PutPublicAccessBlockConfigResponse) obj;
        return Objects.equals(publicAccessBlockConfig(), other.publicAccessBlockConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutPublicAccessBlockConfigResponse").add("PublicAccessBlockConfig", publicAccessBlockConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicAccessBlockConfig":
            return Optional.ofNullable(clazz.cast(publicAccessBlockConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPublicAccessBlockConfigResponse, T> g) {
        return obj -> g.apply((PutPublicAccessBlockConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutPublicAccessBlockConfigResponse> {
        /**
         * <p>
         * The public-access settings Lambda applied to your function.
         * </p>
         * 
         * @param publicAccessBlockConfig
         *        The public-access settings Lambda applied to your function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicAccessBlockConfig(PublicAccessBlockConfig publicAccessBlockConfig);

        /**
         * <p>
         * The public-access settings Lambda applied to your function.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicAccessBlockConfig.Builder} avoiding
         * the need to create one manually via {@link PublicAccessBlockConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicAccessBlockConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #publicAccessBlockConfig(PublicAccessBlockConfig)}.
         * 
         * @param publicAccessBlockConfig
         *        a consumer that will call methods on {@link PublicAccessBlockConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicAccessBlockConfig(PublicAccessBlockConfig)
         */
        default Builder publicAccessBlockConfig(Consumer<PublicAccessBlockConfig.Builder> publicAccessBlockConfig) {
            return publicAccessBlockConfig(PublicAccessBlockConfig.builder().applyMutation(publicAccessBlockConfig).build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private PublicAccessBlockConfig publicAccessBlockConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPublicAccessBlockConfigResponse model) {
            super(model);
            publicAccessBlockConfig(model.publicAccessBlockConfig);
        }

        public final PublicAccessBlockConfig.Builder getPublicAccessBlockConfig() {
            return publicAccessBlockConfig != null ? publicAccessBlockConfig.toBuilder() : null;
        }

        public final void setPublicAccessBlockConfig(PublicAccessBlockConfig.BuilderImpl publicAccessBlockConfig) {
            this.publicAccessBlockConfig = publicAccessBlockConfig != null ? publicAccessBlockConfig.build() : null;
        }

        @Override
        public final Builder publicAccessBlockConfig(PublicAccessBlockConfig publicAccessBlockConfig) {
            this.publicAccessBlockConfig = publicAccessBlockConfig;
            return this;
        }

        @Override
        public PutPublicAccessBlockConfigResponse build() {
            return new PutPublicAccessBlockConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
