/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeWithResponseStreamRequest extends LambdaRequest implements
        ToCopyableBuilder<InvokeWithResponseStreamRequest.Builder, InvokeWithResponseStreamRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(InvokeWithResponseStreamRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationType").getter(getter(InvokeWithResponseStreamRequest::invocationTypeAsString))
            .setter(setter(Builder::invocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Invocation-Type").build())
            .build();

    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogType").getter(getter(InvokeWithResponseStreamRequest::logTypeAsString))
            .setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Log-Type").build()).build();

    private static final SdkField<String> CLIENT_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientContext").getter(getter(InvokeWithResponseStreamRequest::clientContext))
            .setter(setter(Builder::clientContext))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Context").build())
            .build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(InvokeWithResponseStreamRequest::qualifier))
            .setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Payload")
            .getter(getter(InvokeWithResponseStreamRequest::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            INVOCATION_TYPE_FIELD, LOG_TYPE_FIELD, CLIENT_CONTEXT_FIELD, QUALIFIER_FIELD, PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FunctionName", FUNCTION_NAME_FIELD);
                    put("X-Amz-Invocation-Type", INVOCATION_TYPE_FIELD);
                    put("X-Amz-Log-Type", LOG_TYPE_FIELD);
                    put("X-Amz-Client-Context", CLIENT_CONTEXT_FIELD);
                    put("Qualifier", QUALIFIER_FIELD);
                    put("Payload", PAYLOAD_FIELD);
                }
            });

    private final String functionName;

    private final String invocationType;

    private final String logType;

    private final String clientContext;

    private final String qualifier;

    private final SdkBytes payload;

    private InvokeWithResponseStreamRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.invocationType = builder.invocationType;
        this.logType = builder.logType;
        this.clientContext = builder.clientContext;
        this.qualifier = builder.qualifier;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> – <code>my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name or ARN of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> – <code>my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open until the
     * function returns a response or times out. The API operation response includes the function response and
     * additional data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to invoke the
     * function.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link ResponseStreamingInvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Use one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open
     *         until the function returns a response or times out. The API operation response includes the function
     *         response and additional data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to
     *         invoke the function.
     *         </p>
     *         </li>
     * @see ResponseStreamingInvocationType
     */
    public final ResponseStreamingInvocationType invocationType() {
        return ResponseStreamingInvocationType.fromValue(invocationType);
    }

    /**
     * <p>
     * Use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open until the
     * function returns a response or times out. The API operation response includes the function response and
     * additional data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to invoke the
     * function.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link ResponseStreamingInvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Use one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open
     *         until the function returns a response or times out. The API operation response includes the function
     *         response and additional data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to
     *         invoke the function.
     *         </p>
     *         </li>
     * @see ResponseStreamingInvocationType
     */
    public final String invocationTypeAsString() {
        return invocationType;
    }

    /**
     * <p>
     * Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions
     * only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked
     *         functions only.
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions
     * only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked
     *         functions only.
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * Up to 3,583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.
     * </p>
     * 
     * @return Up to 3,583 bytes of base64-encoded data about the invoking client to pass to the function in the context
     *         object.
     */
    public final String clientContext() {
        return clientContext;
    }

    /**
     * <p>
     * The alias name.
     * </p>
     * 
     * @return The alias name.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * The JSON that you want to provide to your Lambda function as input.
     * </p>
     * <p>
     * You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a
     * file path. For example, <code>--payload file://payload.json</code>.
     * </p>
     * 
     * @return The JSON that you want to provide to your Lambda function as input.</p>
     *         <p>
     *         You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also
     *         specify a file path. For example, <code>--payload file://payload.json</code>.
     */
    public final SdkBytes payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(invocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeWithResponseStreamRequest)) {
            return false;
        }
        InvokeWithResponseStreamRequest other = (InvokeWithResponseStreamRequest) obj;
        return Objects.equals(functionName(), other.functionName())
                && Objects.equals(invocationTypeAsString(), other.invocationTypeAsString())
                && Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(clientContext(), other.clientContext()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeWithResponseStreamRequest").add("FunctionName", functionName())
                .add("InvocationType", invocationTypeAsString()).add("LogType", logTypeAsString())
                .add("ClientContext", clientContext()).add("Qualifier", qualifier())
                .add("Payload", payload() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "InvocationType":
            return Optional.ofNullable(clazz.cast(invocationTypeAsString()));
        case "LogType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "ClientContext":
            return Optional.ofNullable(clazz.cast(clientContext()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvokeWithResponseStreamRequest, T> g) {
        return obj -> g.apply((InvokeWithResponseStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeWithResponseStreamRequest> {
        /**
         * <p>
         * The name or ARN of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> – <code>my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> – <code>my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> – <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> – <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Use one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open until
         * the function returns a response or times out. The API operation response includes the function response and
         * additional data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to invoke
         * the function.
         * </p>
         * </li>
         * </ul>
         * 
         * @param invocationType
         *        Use one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open
         *        until the function returns a response or times out. The API operation response includes the function
         *        response and additional data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to
         *        invoke the function.
         *        </p>
         *        </li>
         * @see ResponseStreamingInvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseStreamingInvocationType
         */
        Builder invocationType(String invocationType);

        /**
         * <p>
         * Use one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open until
         * the function returns a response or times out. The API operation response includes the function response and
         * additional data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to invoke
         * the function.
         * </p>
         * </li>
         * </ul>
         * 
         * @param invocationType
         *        Use one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RequestResponse</code> (default) – Invoke the function synchronously. Keep the connection open
         *        until the function returns a response or times out. The API operation response includes the function
         *        response and additional data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DryRun</code> – Validate parameter values and verify that the IAM user or role has permission to
         *        invoke the function.
         *        </p>
         *        </li>
         * @see ResponseStreamingInvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseStreamingInvocationType
         */
        Builder invocationType(ResponseStreamingInvocationType invocationType);

        /**
         * <p>
         * Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked
         * functions only.
         * </p>
         * 
         * @param logType
         *        Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously
         *        invoked functions only.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked
         * functions only.
         * </p>
         * 
         * @param logType
         *        Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously
         *        invoked functions only.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * Up to 3,583 bytes of base64-encoded data about the invoking client to pass to the function in the context
         * object.
         * </p>
         * 
         * @param clientContext
         *        Up to 3,583 bytes of base64-encoded data about the invoking client to pass to the function in the
         *        context object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientContext(String clientContext);

        /**
         * <p>
         * The alias name.
         * </p>
         * 
         * @param qualifier
         *        The alias name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * The JSON that you want to provide to your Lambda function as input.
         * </p>
         * <p>
         * You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also
         * specify a file path. For example, <code>--payload file://payload.json</code>.
         * </p>
         * 
         * @param payload
         *        The JSON that you want to provide to your Lambda function as input.</p>
         *        <p>
         *        You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can
         *        also specify a file path. For example, <code>--payload file://payload.json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String invocationType;

        private String logType;

        private String clientContext;

        private String qualifier;

        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeWithResponseStreamRequest model) {
            super(model);
            functionName(model.functionName);
            invocationType(model.invocationType);
            logType(model.logType);
            clientContext(model.clientContext);
            qualifier(model.qualifier);
            payload(model.payload);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getInvocationType() {
            return invocationType;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(ResponseStreamingInvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getClientContext() {
            return clientContext;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeWithResponseStreamRequest build() {
            return new InvokeWithResponseStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
