/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFunctionCodeSigningConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<PutFunctionCodeSigningConfigResponse.Builder, PutFunctionCodeSigningConfigResponse> {
    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeSigningConfigArn").getter(getter(PutFunctionCodeSigningConfigResponse::codeSigningConfigArn))
            .setter(setter(Builder::codeSigningConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigArn").build())
            .build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(PutFunctionCodeSigningConfigResponse::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SIGNING_CONFIG_ARN_FIELD,
            FUNCTION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CodeSigningConfigArn", CODE_SIGNING_CONFIG_ARN_FIELD);
                    put("FunctionName", FUNCTION_NAME_FIELD);
                }
            });

    private final String codeSigningConfigArn;

    private final String functionName;

    private PutFunctionCodeSigningConfigResponse(BuilderImpl builder) {
        super(builder);
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
        this.functionName = builder.functionName;
    }

    /**
     * <p>
     * The The Amazon Resource Name (ARN) of the code signing configuration.
     * </p>
     * 
     * @return The The Amazon Resource Name (ARN) of the code signing configuration.
     */
    public final String codeSigningConfigArn() {
        return codeSigningConfigArn;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name or ARN of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeSigningConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionCodeSigningConfigResponse)) {
            return false;
        }
        PutFunctionCodeSigningConfigResponse other = (PutFunctionCodeSigningConfigResponse) obj;
        return Objects.equals(codeSigningConfigArn(), other.codeSigningConfigArn())
                && Objects.equals(functionName(), other.functionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFunctionCodeSigningConfigResponse").add("CodeSigningConfigArn", codeSigningConfigArn())
                .add("FunctionName", functionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeSigningConfigArn":
            return Optional.ofNullable(clazz.cast(codeSigningConfigArn()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionCodeSigningConfigResponse, T> g) {
        return obj -> g.apply((PutFunctionCodeSigningConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutFunctionCodeSigningConfigResponse> {
        /**
         * <p>
         * The The Amazon Resource Name (ARN) of the code signing configuration.
         * </p>
         * 
         * @param codeSigningConfigArn
         *        The The Amazon Resource Name (ARN) of the code signing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningConfigArn(String codeSigningConfigArn);

        /**
         * <p>
         * The name or ARN of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String codeSigningConfigArn;

        private String functionName;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionCodeSigningConfigResponse model) {
            super(model);
            codeSigningConfigArn(model.codeSigningConfigArn);
            functionName(model.functionName);
        }

        public final String getCodeSigningConfigArn() {
            return codeSigningConfigArn;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        @Override
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        @Override
        public PutFunctionCodeSigningConfigResponse build() {
            return new PutFunctionCodeSigningConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
