/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.AddPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddPermissionResponse;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyResponse;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.RemovePermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemovePermissionResponse;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateAliasRequest;
import software.amazon.awssdk.services.lambda.model.UpdateAliasResponse;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher;

/**
 * Service client for accessing AWS Lambda asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS Lambda</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * This is the <i>AWS Lambda API Reference</i>. The AWS Lambda Developer Guide provides additional information. For the
 * service overview, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">What is AWS Lambda</a>, and
 * for information about how the service works, see <a
 * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html">AWS Lambda: How it Works</a> in the
 * <b>AWS Lambda Developer Guide</b>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface LambdaAsyncClient extends SdkClient {
    String SERVICE_NAME = "lambda";

    /**
     * Create a {@link LambdaAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LambdaAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LambdaAsyncClient}.
     */
    static LambdaAsyncClientBuilder builder() {
        return new DefaultLambdaAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of a function layer. Use this action to grant layer
     * usage permission to other accounts. You can grant permission to a single account, all AWS accounts, or all
     * accounts in an organization.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     * @return A Java Future containing the result of the AddLayerVersionPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>PolicyLengthExceededException Lambda function access policy is limited to 20 KB.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddLayerVersionPermissionResponse> addLayerVersionPermission(
            AddLayerVersionPermissionRequest addLayerVersionPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of a function layer. Use this action to grant layer
     * usage permission to other accounts. You can grant permission to a single account, all AWS accounts, or all
     * accounts in an organization.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddLayerVersionPermissionRequest.Builder} avoiding
     * the need to create one manually via {@link AddLayerVersionPermissionRequest#builder()}
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     *        A {@link Consumer} that will call methods on {@link AddLayerVersionPermissionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AddLayerVersionPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>PolicyLengthExceededException Lambda function access policy is limited to 20 KB.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AddLayerVersionPermissionResponse> addLayerVersionPermission(
            Consumer<AddLayerVersionPermissionRequest.Builder> addLayerVersionPermissionRequest) {
        return addLayerVersionPermission(AddLayerVersionPermissionRequest.builder()
                .applyMutation(addLayerVersionPermissionRequest).build());
    }

    /**
     * <p>
     * Adds a permission to the resource policy associated with the specified AWS Lambda function. You use resource
     * policies to grant permissions to event sources that use the <i>push</i> model. In a <i>push</i> model, event
     * sources (such as Amazon S3 and custom applications) invoke your Lambda function. Each permission you add to the
     * resource policy allows an event source permission to invoke the Lambda function.
     * </p>
     * <p>
     * Permissions apply to the Amazon Resource Name (ARN) used to invoke the function, which can be unqualified (the
     * unpublished version of the function), or include a version or alias. If a client uses a version or alias to
     * invoke a function, use the <code>Qualifier</code> parameter to apply permissions to that ARN. For more
     * information about versioning, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:AddPermission</code> action.
     * </p>
     *
     * @param addPermissionRequest
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>PolicyLengthExceededException Lambda function access policy is limited to 20 KB.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a permission to the resource policy associated with the specified AWS Lambda function. You use resource
     * policies to grant permissions to event sources that use the <i>push</i> model. In a <i>push</i> model, event
     * sources (such as Amazon S3 and custom applications) invoke your Lambda function. Each permission you add to the
     * resource policy allows an event source permission to invoke the Lambda function.
     * </p>
     * <p>
     * Permissions apply to the Amazon Resource Name (ARN) used to invoke the function, which can be unqualified (the
     * unpublished version of the function), or include a version or alias. If a client uses a version or alias to
     * invoke a function, use the <code>Qualifier</code> parameter to apply permissions to that ARN. For more
     * information about versioning, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:AddPermission</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link AddPermissionRequest#builder()}
     * </p>
     *
     * @param addPermissionRequest
     *        A {@link Consumer} that will call methods on {@link AddPermissionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>PolicyLengthExceededException Lambda function access policy is limited to 20 KB.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.AddPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPermissionResponse> addPermission(Consumer<AddPermissionRequest.Builder> addPermissionRequest) {
        return addPermission(AddPermissionRequest.builder().applyMutation(addPermissionRequest).build());
    }

    /**
     * <p>
     * Creates an alias that points to the specified Lambda function version. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.
     * </p>
     * <p>
     * Alias names are unique for a given function. This requires permission for the lambda:CreateAlias action.
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias that points to the specified Lambda function version. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.
     * </p>
     * <p>
     * Alias names are unique for a given function. This requires permission for the lambda:CreateAlias action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest) {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates a mapping between an event source and an AWS Lambda function. Lambda reads items from the event source
     * and triggers the function.
     * </p>
     * <p>
     * For details about each event source type, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html">Using AWS Lambda with Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html">Using AWS Lambda with Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html">Using AWS Lambda with Amazon DynamoDB</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventSourceMappingRequest
     * @return A Java Future containing the result of the CreateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSourceMappingResponse> createEventSourceMapping(
            CreateEventSourceMappingRequest createEventSourceMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a mapping between an event source and an AWS Lambda function. Lambda reads items from the event source
     * and triggers the function.
     * </p>
     * <p>
     * For details about each event source type, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html">Using AWS Lambda with Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html">Using AWS Lambda with Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html">Using AWS Lambda with Amazon DynamoDB</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param createEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventSourceMappingResponse> createEventSourceMapping(
            Consumer<CreateEventSourceMappingRequest.Builder> createEventSourceMappingRequest) {
        return createEventSourceMapping(CreateEventSourceMappingRequest.builder().applyMutation(createEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new Lambda function. The function configuration is created from the request parameters, and the code
     * for the function is provided by a .zip file. The function name is case-sensitive.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:CreateFunction</code> action.
     * </p>
     *
     * @param createFunctionRequest
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFunctionResponse> createFunction(CreateFunctionRequest createFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Lambda function. The function configuration is created from the request parameters, and the code
     * for the function is provided by a .zip file. The function name is case-sensitive.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:CreateFunction</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFunctionRequest#builder()}
     * </p>
     *
     * @param createFunctionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFunctionResponse> createFunction(Consumer<CreateFunctionRequest.Builder> createFunctionRequest) {
        return createFunction(CreateFunctionRequest.builder().applyMutation(createFunctionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Lambda function alias. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.
     * </p>
     * <p>
     * This requires permission for the lambda:DeleteAlias action.
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Lambda function alias. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.
     * </p>
     * <p>
     * This requires permission for the lambda:DeleteAlias action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAliasRequest#builder()}
     * </p>
     *
     * @param deleteAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAliasResponse> deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest) {
        return deleteAlias(DeleteAliasRequest.builder().applyMutation(deleteAliasRequest).build());
    }

    /**
     * <p>
     * Deletes an event source mapping.
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     * @return A Java Future containing the result of the DeleteEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         attempted to update an EventSoure Mapping in CREATING, or tried to delete a EventSoure mapping currently
     *         in the UPDATING state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSourceMappingResponse> deleteEventSourceMapping(
            DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an event source mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         attempted to update an EventSoure Mapping in CREATING, or tried to delete a EventSoure mapping currently
     *         in the UPDATING state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventSourceMappingResponse> deleteEventSourceMapping(
            Consumer<DeleteEventSourceMappingRequest.Builder> deleteEventSourceMappingRequest) {
        return deleteEventSourceMapping(DeleteEventSourceMappingRequest.builder().applyMutation(deleteEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted. Event source mappings are not deleted.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:DeleteFunction</code> action.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted. Event source mappings are not deleted.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:DeleteFunction</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFunctionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFunctionResponse> deleteFunction(Consumer<DeleteFunctionRequest.Builder> deleteFunctionRequest) {
        return deleteFunction(DeleteFunctionRequest.builder().applyMutation(deleteFunctionRequest).build());
    }

    /**
     * <p>
     * Removes concurrent execution limits from this function. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     * @return A Java Future containing the result of the DeleteFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionConcurrencyResponse> deleteFunctionConcurrency(
            DeleteFunctionConcurrencyRequest deleteFunctionConcurrencyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes concurrent execution limits from this function. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionConcurrencyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFunctionConcurrencyResponse> deleteFunctionConcurrency(
            Consumer<DeleteFunctionConcurrencyRequest.Builder> deleteFunctionConcurrencyRequest) {
        return deleteFunctionConcurrency(DeleteFunctionConcurrencyRequest.builder()
                .applyMutation(deleteFunctionConcurrencyRequest).build());
    }

    /**
     * <p>
     * Deletes a version of a function layer. Deleted versions can no longer be viewed or added to functions. However, a
     * copy of the version remains in Lambda until no functions refer to it.
     * </p>
     *
     * @param deleteLayerVersionRequest
     * @return A Java Future containing the result of the DeleteLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLayerVersionResponse> deleteLayerVersion(DeleteLayerVersionRequest deleteLayerVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a version of a function layer. Deleted versions can no longer be viewed or added to functions. However, a
     * copy of the version remains in Lambda until no functions refer to it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLayerVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLayerVersionRequest#builder()}
     * </p>
     *
     * @param deleteLayerVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLayerVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.DeleteLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLayerVersionResponse> deleteLayerVersion(
            Consumer<DeleteLayerVersionRequest.Builder> deleteLayerVersionRequest) {
        return deleteLayerVersion(DeleteLayerVersionRequest.builder().applyMutation(deleteLayerVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in a region.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in a region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(
            Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest) {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in a region.
     * </p>
     *
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings() {
        return getAccountSettings(GetAccountSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Returns the specified alias information such as the alias ARN, description, and function version it is pointing
     * to. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.
     * </p>
     * <p>
     * This requires permission for the <code>lambda:GetAlias</code> action.
     * </p>
     *
     * @param getAliasRequest
     * @return A Java Future containing the result of the GetAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAliasResponse> getAlias(GetAliasRequest getAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the specified alias information such as the alias ARN, description, and function version it is pointing
     * to. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.
     * </p>
     * <p>
     * This requires permission for the <code>lambda:GetAlias</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAliasRequest.Builder} avoiding the need to
     * create one manually via {@link GetAliasRequest#builder()}
     * </p>
     *
     * @param getAliasRequest
     *        A {@link Consumer} that will call methods on {@link GetAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAliasResponse> getAlias(Consumer<GetAliasRequest.Builder> getAliasRequest) {
        return getAlias(GetAliasRequest.builder().applyMutation(getAliasRequest).build());
    }

    /**
     * <p>
     * Returns details about an event source mapping.
     * </p>
     *
     * @param getEventSourceMappingRequest
     * @return A Java Future containing the result of the GetEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventSourceMappingResponse> getEventSourceMapping(
            GetEventSourceMappingRequest getEventSourceMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an event source mapping.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventSourceMappingRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param getEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on {@link GetEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventSourceMappingResponse> getEventSourceMapping(
            Consumer<GetEventSourceMappingRequest.Builder> getEventSourceMappingRequest) {
        return getEventSourceMapping(GetEventSourceMappingRequest.builder().applyMutation(getEventSourceMappingRequest).build());
    }

    /**
     * <p>
     * Returns the configuration information of the Lambda function and a presigned URL link to the .zip file you
     * uploaded with <a>CreateFunction</a> so you can download the .zip file. Note that the URL is valid for up to 10
     * minutes. The configuration information is the same information you provided as parameters when uploading the
     * function.
     * </p>
     * <p>
     * Use the <code>Qualifier</code> parameter to retrieve a published version of the function. Otherwise, returns the
     * unpublished version (<code>&#36LATEST</code>). For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:GetFunction</code> action.
     * </p>
     *
     * @param getFunctionRequest
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFunctionResponse> getFunction(GetFunctionRequest getFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration information of the Lambda function and a presigned URL link to the .zip file you
     * uploaded with <a>CreateFunction</a> so you can download the .zip file. Note that the URL is valid for up to 10
     * minutes. The configuration information is the same information you provided as parameters when uploading the
     * function.
     * </p>
     * <p>
     * Use the <code>Qualifier</code> parameter to retrieve a published version of the function. Otherwise, returns the
     * unpublished version (<code>&#36LATEST</code>). For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:GetFunction</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link GetFunctionRequest#builder()}
     * </p>
     *
     * @param getFunctionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetFunctionResponse> getFunction(Consumer<GetFunctionRequest.Builder> getFunctionRequest) {
        return getFunction(GetFunctionRequest.builder().applyMutation(getFunctionRequest).build());
    }

    /**
     * <p>
     * Returns the configuration information of the Lambda function. This the same information you provided as
     * parameters when uploading the function by using <a>CreateFunction</a>.
     * </p>
     * <p>
     * If you are using the versioning feature, you can retrieve this information for a specific function version by
     * using the optional <code>Qualifier</code> parameter and specifying the function version or alias that points to
     * it. If you don't provide it, the API returns information about the &#36LATEST version of the function. For more
     * information about versioning, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:GetFunctionConfiguration</code> operation.
     * </p>
     *
     * @param getFunctionConfigurationRequest
     * @return A Java Future containing the result of the GetFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionConfigurationResponse> getFunctionConfiguration(
            GetFunctionConfigurationRequest getFunctionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration information of the Lambda function. This the same information you provided as
     * parameters when uploading the function by using <a>CreateFunction</a>.
     * </p>
     * <p>
     * If you are using the versioning feature, you can retrieve this information for a specific function version by
     * using the optional <code>Qualifier</code> parameter and specifying the function version or alias that points to
     * it. If you don't provide it, the API returns information about the &#36LATEST version of the function. For more
     * information about versioning, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:GetFunctionConfiguration</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetFunctionConfigurationRequest#builder()}
     * </p>
     *
     * @param getFunctionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetFunctionConfigurationResponse> getFunctionConfiguration(
            Consumer<GetFunctionConfigurationRequest.Builder> getFunctionConfigurationRequest) {
        return getFunctionConfiguration(GetFunctionConfigurationRequest.builder().applyMutation(getFunctionConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a version of a function layer, with a link to download the layer archive that's valid
     * for 10 minutes.
     * </p>
     *
     * @param getLayerVersionRequest
     * @return A Java Future containing the result of the GetLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLayerVersionResponse> getLayerVersion(GetLayerVersionRequest getLayerVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a version of a function layer, with a link to download the layer archive that's valid
     * for 10 minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetLayerVersionRequest#builder()}
     * </p>
     *
     * @param getLayerVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetLayerVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLayerVersionResponse> getLayerVersion(
            Consumer<GetLayerVersionRequest.Builder> getLayerVersionRequest) {
        return getLayerVersion(GetLayerVersionRequest.builder().applyMutation(getLayerVersionRequest).build());
    }

    /**
     * <p>
     * Returns the permission policy for a layer version. For more information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     * @return A Java Future containing the result of the GetLayerVersionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLayerVersionPolicyResponse> getLayerVersionPolicy(
            GetLayerVersionPolicyRequest getLayerVersionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the permission policy for a layer version. For more information, see <a>AddLayerVersionPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetLayerVersionPolicyRequest#builder()}
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetLayerVersionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLayerVersionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetLayerVersionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLayerVersionPolicyResponse> getLayerVersionPolicy(
            Consumer<GetLayerVersionPolicyRequest.Builder> getLayerVersionPolicyRequest) {
        return getLayerVersionPolicy(GetLayerVersionPolicyRequest.builder().applyMutation(getLayerVersionPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the resource policy associated with the specified Lambda function.
     * </p>
     * <p>
     * This action requires permission for the <code>lambda:GetPolicy action.</code>
     * </p>
     *
     * @param getPolicyRequest
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(GetPolicyRequest getPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource policy associated with the specified Lambda function.
     * </p>
     * <p>
     * This action requires permission for the <code>lambda:GetPolicy action.</code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPolicyResponse> getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Invokes a Lambda function. For an example, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/with-dynamodb-create-function.html#with-dbb-invoke-manually"
     * >Create the Lambda Function and Test It Manually</a>.
     * </p>
     * <p>
     * Specify just a function name to invoke the latest version of the function. To invoke a published version, use the
     * <code>Qualifier</code> parameter to specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version or alias</a>.
     * </p>
     * <p>
     * If you use the <code>RequestResponse</code> (synchronous) invocation option, the function will be invoked only
     * once. If you use the <code>Event</code> (asynchronous) invocation option, the function will be invoked at least
     * once in response to an event and the function must be idempotent to handle this.
     * </p>
     * <p>
     * For functions with a long timeout, your client may be disconnected during synchronous invocation while it waits
     * for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long
     * connections with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:InvokeFunction</code> action.
     * </p>
     * <p>
     * The <code>TooManyRequestsException</code> noted below will return the following:
     * <code>ConcurrentInvocationLimitExceeded</code> will be returned if you have no functions with reserved
     * concurrency and have exceeded your account concurrent limit or if a function without reserved concurrency exceeds
     * the account's unreserved concurrency limit. <code>ReservedFunctionConcurrentInvocationLimitExceeded</code> will
     * be returned when a function with reserved concurrency exceeds its configured concurrency limit.
     * </p>
     *
     * @param invokeRequest
     * @return A Java Future containing the result of the Invoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidRequestContentException The request body could not be parsed as JSON.</li>
     *         <li>RequestTooLargeException The request payload exceeded the <code>Invoke</code> request body JSON input
     *         limit. For more information, see <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>.</li>
     *         <li>UnsupportedMediaTypeException The content type of the <code>Invoke</code> request body is not JSON.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>Ec2UnexpectedException AWS Lambda received an unexpected EC2 client exception while setting up for
     *         the Lambda function.</li>
     *         <li>SubnetIpAddressLimitReachedException AWS Lambda was not able to set up VPC access for the Lambda
     *         function because one or more configured subnets has no available IP addresses.</li>
     *         <li>EniLimitReachedException AWS Lambda was not able to create an Elastic Network Interface (ENI) in the
     *         VPC, specified as part of Lambda function configuration, because the limit for network interfaces has
     *         been reached.</li>
     *         <li>Ec2ThrottledException AWS Lambda was throttled by Amazon EC2 during Lambda function initialization
     *         using the execution role provided for the Lambda function.</li>
     *         <li>Ec2AccessDeniedException Need additional permissions to configure VPC settings.</li>
     *         <li>InvalidSubnetIdException The Subnet ID provided in the Lambda function VPC configuration is invalid.</li>
     *         <li>InvalidSecurityGroupIdException The Security Group ID provided in the Lambda function VPC
     *         configuration is invalid.</li>
     *         <li>InvalidZipFileException AWS Lambda could not unzip the deployment package.</li>
     *         <li>KmsDisabledException Lambda was unable to decrypt the environment variables because the KMS key used
     *         is disabled. Check the Lambda function's KMS key settings.</li>
     *         <li>KmsInvalidStateException Lambda was unable to decrypt the environment variables because the KMS key
     *         used is in an invalid state for Decrypt. Check the function's KMS key settings.</li>
     *         <li>KmsAccessDeniedException Lambda was unable to decrypt the environment variables because KMS access
     *         was denied. Check the Lambda function's KMS permissions.</li>
     *         <li>KmsNotFoundException Lambda was unable to decrypt the environment variables because the KMS key was
     *         not found. Check the function's KMS key settings.</li>
     *         <li>InvalidRuntimeException The runtime or runtime version specified is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.Invoke
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InvokeResponse> invoke(InvokeRequest invokeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes a Lambda function. For an example, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/with-dynamodb-create-function.html#with-dbb-invoke-manually"
     * >Create the Lambda Function and Test It Manually</a>.
     * </p>
     * <p>
     * Specify just a function name to invoke the latest version of the function. To invoke a published version, use the
     * <code>Qualifier</code> parameter to specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version or alias</a>.
     * </p>
     * <p>
     * If you use the <code>RequestResponse</code> (synchronous) invocation option, the function will be invoked only
     * once. If you use the <code>Event</code> (asynchronous) invocation option, the function will be invoked at least
     * once in response to an event and the function must be idempotent to handle this.
     * </p>
     * <p>
     * For functions with a long timeout, your client may be disconnected during synchronous invocation while it waits
     * for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long
     * connections with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:InvokeFunction</code> action.
     * </p>
     * <p>
     * The <code>TooManyRequestsException</code> noted below will return the following:
     * <code>ConcurrentInvocationLimitExceeded</code> will be returned if you have no functions with reserved
     * concurrency and have exceeded your account concurrent limit or if a function without reserved concurrency exceeds
     * the account's unreserved concurrency limit. <code>ReservedFunctionConcurrentInvocationLimitExceeded</code> will
     * be returned when a function with reserved concurrency exceeds its configured concurrency limit.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeRequest.Builder} avoiding the need to create
     * one manually via {@link InvokeRequest#builder()}
     * </p>
     *
     * @param invokeRequest
     *        A {@link Consumer} that will call methods on {@link InvocationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the Invoke operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidRequestContentException The request body could not be parsed as JSON.</li>
     *         <li>RequestTooLargeException The request payload exceeded the <code>Invoke</code> request body JSON input
     *         limit. For more information, see <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>.</li>
     *         <li>UnsupportedMediaTypeException The content type of the <code>Invoke</code> request body is not JSON.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>Ec2UnexpectedException AWS Lambda received an unexpected EC2 client exception while setting up for
     *         the Lambda function.</li>
     *         <li>SubnetIpAddressLimitReachedException AWS Lambda was not able to set up VPC access for the Lambda
     *         function because one or more configured subnets has no available IP addresses.</li>
     *         <li>EniLimitReachedException AWS Lambda was not able to create an Elastic Network Interface (ENI) in the
     *         VPC, specified as part of Lambda function configuration, because the limit for network interfaces has
     *         been reached.</li>
     *         <li>Ec2ThrottledException AWS Lambda was throttled by Amazon EC2 during Lambda function initialization
     *         using the execution role provided for the Lambda function.</li>
     *         <li>Ec2AccessDeniedException Need additional permissions to configure VPC settings.</li>
     *         <li>InvalidSubnetIdException The Subnet ID provided in the Lambda function VPC configuration is invalid.</li>
     *         <li>InvalidSecurityGroupIdException The Security Group ID provided in the Lambda function VPC
     *         configuration is invalid.</li>
     *         <li>InvalidZipFileException AWS Lambda could not unzip the deployment package.</li>
     *         <li>KmsDisabledException Lambda was unable to decrypt the environment variables because the KMS key used
     *         is disabled. Check the Lambda function's KMS key settings.</li>
     *         <li>KmsInvalidStateException Lambda was unable to decrypt the environment variables because the KMS key
     *         used is in an invalid state for Decrypt. Check the function's KMS key settings.</li>
     *         <li>KmsAccessDeniedException Lambda was unable to decrypt the environment variables because KMS access
     *         was denied. Check the Lambda function's KMS permissions.</li>
     *         <li>KmsNotFoundException Lambda was unable to decrypt the environment variables because the KMS key was
     *         not found. Check the function's KMS key settings.</li>
     *         <li>InvalidRuntimeException The runtime or runtime version specified is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.Invoke
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InvokeResponse> invoke(Consumer<InvokeRequest.Builder> invokeRequest) {
        return invoke(InvokeRequest.builder().applyMutation(invokeRequest).build());
    }

    /**
     * <p>
     * Returns list of aliases created for a Lambda function. For each alias, the response includes information such as
     * the alias ARN, description, alias name, and the function version to which it points. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.
     * </p>
     * <p>
     * This requires permission for the lambda:ListAliases action.
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns list of aliases created for a Lambda function. For each alias, the response includes information such as
     * the alias ARN, description, alias name, and the function version to which it points. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS Lambda Aliases</a>.
     * </p>
     * <p>
     * This requires permission for the lambda:ListAliases action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListAliasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest) {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A Java Future containing the result of the ListEventSourceMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventSourceMappingsResponse> listEventSourceMappings(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourceMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventSourceMappingsRequest#builder()}
     * </p>
     *
     * @param listEventSourceMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSourceMappingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventSourceMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventSourceMappingsResponse> listEventSourceMappings(
            Consumer<ListEventSourceMappingsRequest.Builder> listEventSourceMappingsRequest) {
        return listEventSourceMappings(ListEventSourceMappingsRequest.builder().applyMutation(listEventSourceMappingsRequest)
                .build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     *
     * @return A Java Future containing the result of the ListEventSourceMappings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListEventSourceMappingsResponse> listEventSourceMappings() {
        return listEventSourceMappings(ListEventSourceMappingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsPublisher listEventSourceMappingsPaginator() {
        return listEventSourceMappingsPaginator(ListEventSourceMappingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsPublisher listEventSourceMappingsPaginator(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsPublisher publisher = client.listEventSourceMappingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourceMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventSourceMappingsRequest#builder()}
     * </p>
     *
     * @param listEventSourceMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSourceMappingsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsPublisher listEventSourceMappingsPaginator(
            Consumer<ListEventSourceMappingsRequest.Builder> listEventSourceMappingsRequest) {
        return listEventSourceMappingsPaginator(ListEventSourceMappingsRequest.builder()
                .applyMutation(listEventSourceMappingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of your Lambda functions. For each function, the response includes the function configuration
     * information. You must use <a>GetFunction</a> to retrieve the code for your function.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:ListFunctions</code> action.
     * </p>
     * <p>
     * If you are using the versioning feature, you can list all of your functions or only <code>&#36LATEST</code>
     * versions. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     *
     * @param listFunctionsRequest
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions(ListFunctionsRequest listFunctionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of your Lambda functions. For each function, the response includes the function configuration
     * information. You must use <a>GetFunction</a> to retrieve the code for your function.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:ListFunctions</code> action.
     * </p>
     * <p>
     * If you are using the versioning feature, you can list all of your functions or only <code>&#36LATEST</code>
     * versions. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest) {
        return listFunctions(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of your Lambda functions. For each function, the response includes the function configuration
     * information. You must use <a>GetFunction</a> to retrieve the code for your function.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:ListFunctions</code> action.
     * </p>
     * <p>
     * If you are using the versioning feature, you can list all of your functions or only <code>&#36LATEST</code>
     * versions. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     *
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFunctionsResponse> listFunctions() {
        return listFunctions(ListFunctionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of your Lambda functions. For each function, the response includes the function configuration
     * information. You must use <a>GetFunction</a> to retrieve the code for your function.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:ListFunctions</code> action.
     * </p>
     * <p>
     * If you are using the versioning feature, you can list all of your functions or only <code>&#36LATEST</code>
     * versions. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsPublisher listFunctionsPaginator() {
        return listFunctionsPaginator(ListFunctionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of your Lambda functions. For each function, the response includes the function configuration
     * information. You must use <a>GetFunction</a> to retrieve the code for your function.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:ListFunctions</code> action.
     * </p>
     * <p>
     * If you are using the versioning feature, you can list all of your functions or only <code>&#36LATEST</code>
     * versions. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @param listFunctionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsPublisher listFunctionsPaginator(ListFunctionsRequest listFunctionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of your Lambda functions. For each function, the response includes the function configuration
     * information. You must use <a>GetFunction</a> to retrieve the code for your function.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:ListFunctions</code> action.
     * </p>
     * <p>
     * If you are using the versioning feature, you can list all of your functions or only <code>&#36LATEST</code>
     * versions. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsPublisher publisher = client.listFunctionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.lambda.model.ListFunctionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsPublisher listFunctionsPaginator(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest) {
        return listFunctionsPaginator(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of a function layer. Versions that have been deleted aren't listed. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime.
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return A Java Future containing the result of the ListLayerVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayerVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayerVersionsResponse> listLayerVersions(ListLayerVersionsRequest listLayerVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of a function layer. Versions that have been deleted aren't listed. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayerVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLayerVersionsRequest#builder()}
     * </p>
     *
     * @param listLayerVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLayerVersionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLayerVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayerVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayerVersionsResponse> listLayerVersions(
            Consumer<ListLayerVersionsRequest.Builder> listLayerVersionsRequest) {
        return listLayerVersions(ListLayerVersionsRequest.builder().applyMutation(listLayerVersionsRequest).build());
    }

    /**
     * <p>
     * Lists function layers and shows information about the latest version of each. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     *
     * @param listLayersRequest
     * @return A Java Future containing the result of the ListLayers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayersResponse> listLayers(ListLayersRequest listLayersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists function layers and shows information about the latest version of each. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayersRequest.Builder} avoiding the need to
     * create one manually via {@link ListLayersRequest#builder()}
     * </p>
     *
     * @param listLayersRequest
     *        A {@link Consumer} that will call methods on {@link ListLayersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLayers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayersResponse> listLayers(Consumer<ListLayersRequest.Builder> listLayersRequest) {
        return listLayers(ListLayersRequest.builder().applyMutation(listLayersRequest).build());
    }

    /**
     * <p>
     * Lists function layers and shows information about the latest version of each. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     *
     * @return A Java Future containing the result of the ListLayers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayersResponse> listLayers() {
        return listLayers(ListLayersRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of tags assigned to a function when supplied the function ARN (Amazon Resource Name). For more
     * information on Tagging, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">Tagging Lambda
     * Functions</a> in the <b>AWS Lambda Developer Guide</b>.
     * </p>
     *
     * @param listTagsRequest
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(ListTagsRequest listTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags assigned to a function when supplied the function ARN (Amazon Resource Name). For more
     * information on Tagging, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">Tagging Lambda
     * Functions</a> in the <b>AWS Lambda Developer Guide</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsResponse> listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Lists all versions of a function. For information about versioning, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return A Java Future containing the result of the ListVersionsByFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListVersionsByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVersionsByFunctionResponse> listVersionsByFunction(
            ListVersionsByFunctionRequest listVersionsByFunctionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all versions of a function. For information about versioning, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsByFunctionRequest.Builder} avoiding the
     * need to create one manually via {@link ListVersionsByFunctionRequest#builder()}
     * </p>
     *
     * @param listVersionsByFunctionRequest
     *        A {@link Consumer} that will call methods on {@link ListVersionsByFunctionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVersionsByFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.ListVersionsByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVersionsByFunctionResponse> listVersionsByFunction(
            Consumer<ListVersionsByFunctionRequest.Builder> listVersionsByFunctionRequest) {
        return listVersionsByFunction(ListVersionsByFunctionRequest.builder().applyMutation(listVersionsByFunctionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a function layer from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same
     * version name, a new version is created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     *
     * @param publishLayerVersionRequest
     * @return A Java Future containing the result of the PublishLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishLayerVersionResponse> publishLayerVersion(
            PublishLayerVersionRequest publishLayerVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a function layer from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same
     * version name, a new version is created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishLayerVersionRequest.Builder} avoiding the
     * need to create one manually via {@link PublishLayerVersionRequest#builder()}
     * </p>
     *
     * @param publishLayerVersionRequest
     *        A {@link Consumer} that will call methods on {@link PublishLayerVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PublishLayerVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishLayerVersionResponse> publishLayerVersion(
            Consumer<PublishLayerVersionRequest.Builder> publishLayerVersionRequest) {
        return publishLayerVersion(PublishLayerVersionRequest.builder().applyMutation(publishLayerVersionRequest).build());
    }

    /**
     * <p>
     * Publishes a version of your function from the current snapshot of &#36LATEST. That is, AWS Lambda takes a
     * snapshot of the function code and configuration information from &#36LATEST and publishes a new version. The code
     * and configuration cannot be modified after publication. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     *
     * @param publishVersionRequest
     * @return A Java Future containing the result of the PublishVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishVersionResponse> publishVersion(PublishVersionRequest publishVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes a version of your function from the current snapshot of &#36LATEST. That is, AWS Lambda takes a
     * snapshot of the function code and configuration information from &#36LATEST and publishes a new version. The code
     * and configuration cannot be modified after publication. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishVersionRequest.Builder} avoiding the need to
     * create one manually via {@link PublishVersionRequest#builder()}
     * </p>
     *
     * @param publishVersionRequest
     *        A {@link Consumer} that will call methods on {@link PublishVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PublishVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PublishVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishVersionResponse> publishVersion(Consumer<PublishVersionRequest.Builder> publishVersionRequest) {
        return publishVersion(PublishVersionRequest.builder().applyMutation(publishVersionRequest).build());
    }

    /**
     * <p>
     * Sets a limit on the number of concurrent executions available to this function. It is a subset of your account's
     * total concurrent execution limit per region. Note that Lambda automatically reserves a buffer of 100 concurrent
     * executions for functions without any reserved concurrency limit. This means if your account limit is 1000, you
     * have a total of 900 available to allocate to individual functions. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     * @return A Java Future containing the result of the PutFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutFunctionConcurrencyResponse> putFunctionConcurrency(
            PutFunctionConcurrencyRequest putFunctionConcurrencyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets a limit on the number of concurrent executions available to this function. It is a subset of your account's
     * total concurrent execution limit per region. Note that Lambda automatically reserves a buffer of 100 concurrent
     * executions for functions without any reserved concurrency limit. This means if your account limit is 1000, you
     * have a total of 900 available to allocate to individual functions. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionConcurrencyRequest.Builder} avoiding the
     * need to create one manually via {@link PutFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on {@link PutFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutFunctionConcurrency operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.PutFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutFunctionConcurrencyResponse> putFunctionConcurrency(
            Consumer<PutFunctionConcurrencyRequest.Builder> putFunctionConcurrencyRequest) {
        return putFunctionConcurrency(PutFunctionConcurrencyRequest.builder().applyMutation(putFunctionConcurrencyRequest)
                .build());
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a layer version. For more information, see
     * <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     * @return A Java Future containing the result of the RemoveLayerVersionPermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemoveLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveLayerVersionPermissionResponse> removeLayerVersionPermission(
            RemoveLayerVersionPermissionRequest removeLayerVersionPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a layer version. For more information, see
     * <a>AddLayerVersionPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveLayerVersionPermissionRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveLayerVersionPermissionRequest#builder()}
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     *        A {@link Consumer} that will call methods on {@link RemoveLayerVersionPermissionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the RemoveLayerVersionPermission operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemoveLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveLayerVersionPermissionResponse> removeLayerVersionPermission(
            Consumer<RemoveLayerVersionPermissionRequest.Builder> removeLayerVersionPermissionRequest) {
        return removeLayerVersionPermission(RemoveLayerVersionPermissionRequest.builder()
                .applyMutation(removeLayerVersionPermissionRequest).build());
    }

    /**
     * <p>
     * Removes permissions from a function. You can remove individual permissions from an resource policy associated
     * with a Lambda function by providing a statement ID that you provided when you added the permission. When you
     * remove permissions, disable the event source mapping or trigger configuration first to avoid errors.
     * </p>
     * <p>
     * Permissions apply to the Amazon Resource Name (ARN) used to invoke the function, which can be unqualified (the
     * unpublished version of the function), or include a version or alias. If a client uses a version or alias to
     * invoke a function, use the <code>Qualifier</code> parameter to apply permissions to that ARN. For more
     * information about versioning, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * You need permission for the <code>lambda:RemovePermission</code> action.
     * </p>
     *
     * @param removePermissionRequest
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes permissions from a function. You can remove individual permissions from an resource policy associated
     * with a Lambda function by providing a statement ID that you provided when you added the permission. When you
     * remove permissions, disable the event source mapping or trigger configuration first to avoid errors.
     * </p>
     * <p>
     * Permissions apply to the Amazon Resource Name (ARN) used to invoke the function, which can be unqualified (the
     * unpublished version of the function), or include a version or alias. If a client uses a version or alias to
     * invoke a function, use the <code>Qualifier</code> parameter to apply permissions to that ARN. For more
     * information about versioning, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * You need permission for the <code>lambda:RemovePermission</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     * </p>
     *
     * @param removePermissionRequest
     *        A {@link Consumer} that will call methods on {@link RemovePermissionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(
            Consumer<RemovePermissionRequest.Builder> removePermissionRequest) {
        return removePermission(RemovePermissionRequest.builder().applyMutation(removePermissionRequest).build());
    }

    /**
     * <p>
     * Creates a list of tags (key-value pairs) on the Lambda function. Requires the Lambda function ARN (Amazon
     * Resource Name). If a key is specified without a value, Lambda creates a tag with the specified key and a value of
     * null. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">Tagging Lambda
     * Functions</a> in the <b>AWS Lambda Developer Guide</b>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a list of tags (key-value pairs) on the Lambda function. Requires the Lambda function ARN (Amazon
     * Resource Name). If a key is specified without a value, Lambda creates a tag with the specified key and a value of
     * null. For more information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">Tagging Lambda
     * Functions</a> in the <b>AWS Lambda Developer Guide</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a Lambda function. Requires the function ARN (Amazon Resource Name). For more information, see
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">Tagging Lambda Functions</a> in the <b>AWS
     * Lambda Developer Guide</b>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a Lambda function. Requires the function ARN (Amazon Resource Name). For more information, see
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">Tagging Lambda Functions</a> in the <b>AWS
     * Lambda Developer Guide</b>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Using this API you can update the function version to which the alias points and the alias description. For more
     * information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS
     * Lambda Aliases</a>.
     * </p>
     * <p>
     * This requires permission for the lambda:UpdateAlias action.
     * </p>
     *
     * @param updateAliasRequest
     * @return A Java Future containing the result of the UpdateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAliasResponse> updateAlias(UpdateAliasRequest updateAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Using this API you can update the function version to which the alias points and the alias description. For more
     * information, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">Introduction to AWS
     * Lambda Aliases</a>.
     * </p>
     * <p>
     * This requires permission for the lambda:UpdateAlias action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAliasRequest#builder()}
     * </p>
     *
     * @param updateAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateAliasResponse> updateAlias(Consumer<UpdateAliasRequest.Builder> updateAliasRequest) {
        return updateAlias(UpdateAliasRequest.builder().applyMutation(updateAliasRequest).build());
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that AWS Lambda invokes, or pause invocation and
     * resume later from the same location.
     * </p>
     *
     * @param updateEventSourceMappingRequest
     * @return A Java Future containing the result of the UpdateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         attempted to update an EventSoure Mapping in CREATING, or tried to delete a EventSoure mapping currently
     *         in the UPDATING state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventSourceMappingResponse> updateEventSourceMapping(
            UpdateEventSourceMappingRequest updateEventSourceMappingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that AWS Lambda invokes, or pause invocation and
     * resume later from the same location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param updateEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEventSourceMapping operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>ResourceInUseException The operation conflicts with the resource's availability. For example, you
     *         attempted to update an EventSoure Mapping in CREATING, or tried to delete a EventSoure mapping currently
     *         in the UPDATING state.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventSourceMappingResponse> updateEventSourceMapping(
            Consumer<UpdateEventSourceMappingRequest.Builder> updateEventSourceMappingRequest) {
        return updateEventSourceMapping(UpdateEventSourceMappingRequest.builder().applyMutation(updateEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Updates the code for the specified Lambda function. This operation must only be used on an existing Lambda
     * function and cannot be used to update the function configuration.
     * </p>
     * <p>
     * If you are using the versioning feature, note this API will always update the &#36LATEST version of your Lambda
     * function. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:UpdateFunctionCode</code> action.
     * </p>
     *
     * @param updateFunctionCodeRequest
     * @return A Java Future containing the result of the UpdateFunctionCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFunctionCodeResponse> updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the code for the specified Lambda function. This operation must only be used on an existing Lambda
     * function and cannot be used to update the function configuration.
     * </p>
     * <p>
     * If you are using the versioning feature, note this API will always update the &#36LATEST version of your Lambda
     * function. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:UpdateFunctionCode</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionCodeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFunctionCodeRequest#builder()}
     * </p>
     *
     * @param updateFunctionCodeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionCodeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFunctionCode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>CodeStorageExceededException You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a></li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFunctionCodeResponse> updateFunctionCode(
            Consumer<UpdateFunctionCodeRequest.Builder> updateFunctionCodeRequest) {
        return updateFunctionCode(UpdateFunctionCodeRequest.builder().applyMutation(updateFunctionCodeRequest).build());
    }

    /**
     * <p>
     * Updates the configuration parameters for the specified Lambda function by using the values provided in the
     * request. You provide only the parameters you want to change. This operation must only be used on an existing
     * Lambda function and cannot be used to update the function's code.
     * </p>
     * <p>
     * If you are using the versioning feature, note this API will always update the &#36LATEST version of your Lambda
     * function. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:UpdateFunctionConfiguration</code> action.
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     * @return A Java Future containing the result of the UpdateFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionConfigurationResponse> updateFunctionConfiguration(
            UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration parameters for the specified Lambda function by using the values provided in the
     * request. You provide only the parameters you want to change. This operation must only be used on an existing
     * Lambda function and cannot be used to update the function's code.
     * </p>
     * <p>
     * If you are using the versioning feature, note this API will always update the &#36LATEST version of your Lambda
     * function. For information about the versioning feature, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">AWS Lambda Function Versioning and
     * Aliases</a>.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:UpdateFunctionConfiguration</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFunctionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateFunctionConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceException The AWS Lambda service encountered an internal error.</li>
     *         <li>ResourceNotFoundException The resource (for example, a Lambda function or access policy statement)
     *         specified in the request does not exist.</li>
     *         <li>InvalidParameterValueException One of the parameters in the request is invalid. For example, if you
     *         provided an IAM role for AWS Lambda to assume in the <code>CreateFunction</code> or the
     *         <code>UpdateFunctionConfiguration</code> API, that AWS Lambda is unable to assume you will get this
     *         exception.</li>
     *         <li>TooManyRequestsException Request throughput limit exceeded</li>
     *         <li>ResourceConflictException The resource already exists.</li>
     *         <li>PreconditionFailedException The RevisionId provided does not match the latest RevisionId for the
     *         Lambda function or alias. Call the <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve
     *         the latest RevisionId for your resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>LambdaException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample LambdaAsyncClient.UpdateFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateFunctionConfigurationResponse> updateFunctionConfiguration(
            Consumer<UpdateFunctionConfigurationRequest.Builder> updateFunctionConfigurationRequest) {
        return updateFunctionConfiguration(UpdateFunctionConfigurationRequest.builder()
                .applyMutation(updateFunctionConfigurationRequest).build());
    }
}
