/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFunctionConcurrencyResponse extends LambdaResponse implements
        ToCopyableBuilder<PutFunctionConcurrencyResponse.Builder, PutFunctionConcurrencyResponse> {
    private static final SdkField<Integer> RESERVED_CONCURRENT_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(PutFunctionConcurrencyResponse::reservedConcurrentExecutions))
            .setter(setter(Builder::reservedConcurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedConcurrentExecutions")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESERVED_CONCURRENT_EXECUTIONS_FIELD));

    private final Integer reservedConcurrentExecutions;

    private PutFunctionConcurrencyResponse(BuilderImpl builder) {
        super(builder);
        this.reservedConcurrentExecutions = builder.reservedConcurrentExecutions;
    }

    /**
     * <p>
     * The number of concurrent executions reserved for this function. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     * 
     * @return The number of concurrent executions reserved for this function. For more information, see <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     */
    public Integer reservedConcurrentExecutions() {
        return reservedConcurrentExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedConcurrentExecutions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionConcurrencyResponse)) {
            return false;
        }
        PutFunctionConcurrencyResponse other = (PutFunctionConcurrencyResponse) obj;
        return Objects.equals(reservedConcurrentExecutions(), other.reservedConcurrentExecutions());
    }

    @Override
    public String toString() {
        return ToString.builder("PutFunctionConcurrencyResponse")
                .add("ReservedConcurrentExecutions", reservedConcurrentExecutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(reservedConcurrentExecutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionConcurrencyResponse, T> g) {
        return obj -> g.apply((PutFunctionConcurrencyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutFunctionConcurrencyResponse> {
        /**
         * <p>
         * The number of concurrent executions reserved for this function. For more information, see <a
         * href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
         * </p>
         * 
         * @param reservedConcurrentExecutions
         *        The number of concurrent executions reserved for this function. For more information, see <a
         *        href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing
         *        Concurrency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedConcurrentExecutions(Integer reservedConcurrentExecutions);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private Integer reservedConcurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionConcurrencyResponse model) {
            super(model);
            reservedConcurrentExecutions(model.reservedConcurrentExecutions);
        }

        public final Integer getReservedConcurrentExecutions() {
            return reservedConcurrentExecutions;
        }

        @Override
        public final Builder reservedConcurrentExecutions(Integer reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
            return this;
        }

        public final void setReservedConcurrentExecutions(Integer reservedConcurrentExecutions) {
            this.reservedConcurrentExecutions = reservedConcurrentExecutions;
        }

        @Override
        public PutFunctionConcurrencyResponse build() {
            return new PutFunctionConcurrencyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
