/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemovePermissionRequest extends LambdaRequest implements
        ToCopyableBuilder<RemovePermissionRequest.Builder, RemovePermissionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemovePermissionRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemovePermissionRequest::statementId)).setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("StatementId").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemovePermissionRequest::qualifier)).setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemovePermissionRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            STATEMENT_ID_FIELD, QUALIFIER_FIELD, REVISION_ID_FIELD));

    private final String functionName;

    private final String statementId;

    private final String qualifier;

    private final String revisionId;

    private RemovePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.statementId = builder.statementId;
        this.qualifier = builder.qualifier;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Statement ID of the permission to remove.
     * </p>
     * 
     * @return Statement ID of the permission to remove.
     */
    public String statementId() {
        return statementId;
    }

    /**
     * <p>
     * Specify a version or alias to remove permissions from a published version of the function.
     * </p>
     * 
     * @return Specify a version or alias to remove permissions from a published version of the function.
     */
    public String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * An optional value you can use to ensure you are updating the latest update of the function version or alias. If
     * the <code>RevisionID</code> you pass doesn't match the latest <code>RevisionId</code> of the function or alias,
     * it will fail with an error message, advising you to retrieve the latest function version or alias
     * <code>RevisionID</code> using either <a>GetFunction</a> or <a>GetAlias</a>.
     * </p>
     * 
     * @return An optional value you can use to ensure you are updating the latest update of the function version or
     *         alias. If the <code>RevisionID</code> you pass doesn't match the latest <code>RevisionId</code> of the
     *         function or alias, it will fail with an error message, advising you to retrieve the latest function
     *         version or alias <code>RevisionID</code> using either <a>GetFunction</a> or <a>GetAlias</a>.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(statementId(), other.statementId())
                && Objects.equals(qualifier(), other.qualifier()) && Objects.equals(revisionId(), other.revisionId());
    }

    @Override
    public String toString() {
        return ToString.builder("RemovePermissionRequest").add("FunctionName", functionName()).add("StatementId", statementId())
                .add("Qualifier", qualifier()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemovePermissionRequest, T> g) {
        return obj -> g.apply((RemovePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemovePermissionRequest> {
        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Statement ID of the permission to remove.
         * </p>
         * 
         * @param statementId
         *        Statement ID of the permission to remove.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * Specify a version or alias to remove permissions from a published version of the function.
         * </p>
         * 
         * @param qualifier
         *        Specify a version or alias to remove permissions from a published version of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * An optional value you can use to ensure you are updating the latest update of the function version or alias.
         * If the <code>RevisionID</code> you pass doesn't match the latest <code>RevisionId</code> of the function or
         * alias, it will fail with an error message, advising you to retrieve the latest function version or alias
         * <code>RevisionID</code> using either <a>GetFunction</a> or <a>GetAlias</a>.
         * </p>
         * 
         * @param revisionId
         *        An optional value you can use to ensure you are updating the latest update of the function version or
         *        alias. If the <code>RevisionID</code> you pass doesn't match the latest <code>RevisionId</code> of the
         *        function or alias, it will fail with an error message, advising you to retrieve the latest function
         *        version or alias <code>RevisionID</code> using either <a>GetFunction</a> or <a>GetAlias</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String statementId;

        private String qualifier;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            super(model);
            functionName(model.functionName);
            statementId(model.statementId);
            qualifier(model.qualifier);
            revisionId(model.revisionId);
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getStatementId() {
            return statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public final String getQualifier() {
            return qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
