/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The function's AWS X-Ray tracing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TracingConfig implements SdkPojo, Serializable, ToCopyableBuilder<TracingConfig.Builder, TracingConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TracingConfig::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private TracingConfig(BuilderImpl builder) {
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The tracing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link TracingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The tracing mode.
     * @see TracingMode
     */
    public TracingMode mode() {
        return TracingMode.fromValue(mode);
    }

    /**
     * <p>
     * The tracing mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link TracingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The tracing mode.
     * @see TracingMode
     */
    public String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TracingConfig)) {
            return false;
        }
        TracingConfig other = (TracingConfig) obj;
        return Objects.equals(modeAsString(), other.modeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("TracingConfig").add("Mode", modeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TracingConfig, T> g) {
        return obj -> g.apply((TracingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TracingConfig> {
        /**
         * <p>
         * The tracing mode.
         * </p>
         * 
         * @param mode
         *        The tracing mode.
         * @see TracingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TracingMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The tracing mode.
         * </p>
         * 
         * @param mode
         *        The tracing mode.
         * @see TracingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TracingMode
         */
        Builder mode(TracingMode mode);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(TracingConfig model) {
            mode(model.mode);
        }

        public final String getModeAsString() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(TracingMode mode) {
            this.mode(mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public TracingConfig build() {
            return new TracingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
