/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPolicyResponse extends LambdaResponse implements
        ToCopyableBuilder<GetPolicyResponse.Builder, GetPolicyResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPolicyResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPolicyResponse::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD,
            REVISION_ID_FIELD));

    private final String policy;

    private final String revisionId;

    private GetPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The resource-based policy.
     * </p>
     * 
     * @return The resource-based policy.
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * A unique identifier for the current revision of the policy.
     * </p>
     * 
     * @return A unique identifier for the current revision of the policy.
     */
    public String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyResponse)) {
            return false;
        }
        GetPolicyResponse other = (GetPolicyResponse) obj;
        return Objects.equals(policy(), other.policy()) && Objects.equals(revisionId(), other.revisionId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetPolicyResponse").add("Policy", policy()).add("RevisionId", revisionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyResponse, T> g) {
        return obj -> g.apply((GetPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPolicyResponse> {
        /**
         * <p>
         * The resource-based policy.
         * </p>
         * 
         * @param policy
         *        The resource-based policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * A unique identifier for the current revision of the policy.
         * </p>
         * 
         * @param revisionId
         *        A unique identifier for the current revision of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String policy;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyResponse model) {
            super(model);
            policy(model.policy);
            revisionId(model.revisionId);
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public GetPolicyResponse build() {
            return new GetPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
