/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Layer implements SdkPojo, Serializable, ToCopyableBuilder<Layer.Builder, Layer> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Layer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Layer::codeSize)).setter(setter(Builder::codeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CODE_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Long codeSize;

    private Layer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.codeSize = builder.codeSize;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function layer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function layer.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The size of the layer archive in bytes.
     * </p>
     * 
     * @return The size of the layer archive in bytes.
     */
    public Long codeSize() {
        return codeSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(codeSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(codeSize(), other.codeSize());
    }

    @Override
    public String toString() {
        return ToString.builder("Layer").add("Arn", arn()).add("CodeSize", codeSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CodeSize":
            return Optional.ofNullable(clazz.cast(codeSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Layer, T> g) {
        return obj -> g.apply((Layer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Layer> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function layer.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the function layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The size of the layer archive in bytes.
         * </p>
         * 
         * @param codeSize
         *        The size of the layer archive in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSize(Long codeSize);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Long codeSize;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            arn(model.arn);
            codeSize(model.codeSize);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Long getCodeSize() {
            return codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        @Override
        public Layer build() {
            return new Layer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
