/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a function's deployment package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FunctionCodeLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<FunctionCodeLocation.Builder, FunctionCodeLocation> {
    private static final SdkField<String> REPOSITORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionCodeLocation::repositoryType)).setter(setter(Builder::repositoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryType").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FunctionCodeLocation::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_TYPE_FIELD,
            LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryType;

    private final String location;

    private FunctionCodeLocation(BuilderImpl builder) {
        this.repositoryType = builder.repositoryType;
        this.location = builder.location;
    }

    /**
     * <p>
     * The service hosting the file.
     * </p>
     * 
     * @return The service hosting the file.
     */
    public String repositoryType() {
        return repositoryType;
    }

    /**
     * <p>
     * A pre-signed URL that you can use to download the deployment package.
     * </p>
     * 
     * @return A pre-signed URL that you can use to download the deployment package.
     */
    public String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryType());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionCodeLocation)) {
            return false;
        }
        FunctionCodeLocation other = (FunctionCodeLocation) obj;
        return Objects.equals(repositoryType(), other.repositoryType()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FunctionCodeLocation").add("RepositoryType", repositoryType()).add("Location", location())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryType":
            return Optional.ofNullable(clazz.cast(repositoryType()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FunctionCodeLocation, T> g) {
        return obj -> g.apply((FunctionCodeLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FunctionCodeLocation> {
        /**
         * <p>
         * The service hosting the file.
         * </p>
         * 
         * @param repositoryType
         *        The service hosting the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryType(String repositoryType);

        /**
         * <p>
         * A pre-signed URL that you can use to download the deployment package.
         * </p>
         * 
         * @param location
         *        A pre-signed URL that you can use to download the deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryType;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionCodeLocation model) {
            repositoryType(model.repositoryType);
            location(model.location);
        }

        public final String getRepositoryType() {
            return repositoryType;
        }

        @Override
        public final Builder repositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
            return this;
        }

        public final void setRepositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public FunctionCodeLocation build() {
            return new FunctionCodeLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
