/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FunctionVersion {
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FunctionVersion> VALUE_MAP;
    private final String value;

    private FunctionVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FunctionVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FunctionVersion> knownValues() {
        EnumSet<FunctionVersion> knownValues = EnumSet.allOf(FunctionVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FunctionVersion.class, FunctionVersion::toString);
    }
}

