/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLayerVersionPolicyRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, GetLayerVersionPolicyRequest> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerName").getter(GetLayerVersionPolicyRequest.getter(GetLayerVersionPolicyRequest::layerName)).setter(GetLayerVersionPolicyRequest.setter(Builder::layerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()}).build();
    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("VersionNumber").getter(GetLayerVersionPolicyRequest.getter(GetLayerVersionPolicyRequest::versionNumber)).setter(GetLayerVersionPolicyRequest.setter(Builder::versionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD, VERSION_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLayerVersionPolicyRequest.memberNameToFieldInitializer();
    private final String layerName;
    private final Long versionNumber;

    private GetLayerVersionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.versionNumber = builder.versionNumber;
    }

    public final String layerName() {
        return this.layerName;
    }

    public final Long versionNumber() {
        return this.versionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.layerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLayerVersionPolicyRequest)) {
            return false;
        }
        GetLayerVersionPolicyRequest other = (GetLayerVersionPolicyRequest)((Object)obj);
        return Objects.equals(this.layerName(), other.layerName()) && Objects.equals(this.versionNumber(), other.versionNumber());
    }

    public final String toString() {
        return ToString.builder((String)"GetLayerVersionPolicyRequest").add("LayerName", (Object)this.layerName()).add("VersionNumber", (Object)this.versionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LayerName": {
                return Optional.ofNullable(clazz.cast(this.layerName()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LayerName", LAYER_NAME_FIELD);
        map.put("VersionNumber", VERSION_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLayerVersionPolicyRequest, T> g) {
        return obj -> g.apply((GetLayerVersionPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String layerName;
        private Long versionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLayerVersionPolicyRequest model) {
            super(model);
            this.layerName(model.layerName);
            this.versionNumber(model.versionNumber);
        }

        public final String getLayerName() {
            return this.layerName;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLayerVersionPolicyRequest build() {
            return new GetLayerVersionPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLayerVersionPolicyRequest> {
        public Builder layerName(String var1);

        public Builder versionNumber(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

