/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model.invokewithresponsestreamresponseevent;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.lambda.model.InvokeResponseStreamUpdate;
import software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamResponseEvent;
import software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.lambda.model.InvokeResponseStreamUpdate} that represents
 * the {@code InvokeWithResponseStreamResponseEvent$PayloadChunk} event. Do not use this class directly. Instead, use
 * the static builder methods on
 * {@link software.amazon.awssdk.services.lambda.model.InvokeWithResponseStreamResponseEvent}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultPayloadChunk extends InvokeResponseStreamUpdate {
    private static final long serialVersionUID = 1L;

    DefaultPayloadChunk(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(InvokeWithResponseStreamResponseHandler.Visitor visitor) {
        visitor.visitPayloadChunk(this);
    }

    @Override
    public InvokeWithResponseStreamResponseEvent.EventType sdkEventType() {
        return InvokeWithResponseStreamResponseEvent.EventType.PAYLOAD_CHUNK;
    }

    public interface Builder extends InvokeResponseStreamUpdate.Builder {
        @Override
        DefaultPayloadChunk build();
    }

    private static final class BuilderImpl extends InvokeResponseStreamUpdate.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultPayloadChunk event) {
            super(event);
        }

        @Override
        public DefaultPayloadChunk build() {
            return new DefaultPayloadChunk(this);
        }
    }
}
