/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.AddPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddPermissionResponse;
import software.amazon.awssdk.services.lambda.model.CodeStorageExceededException;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.Ec2AccessDeniedException;
import software.amazon.awssdk.services.lambda.model.Ec2ThrottledException;
import software.amazon.awssdk.services.lambda.model.Ec2UnexpectedException;
import software.amazon.awssdk.services.lambda.model.EniLimitReachedException;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyResponse;
import software.amazon.awssdk.services.lambda.model.InvalidParameterValueException;
import software.amazon.awssdk.services.lambda.model.InvalidRequestContentException;
import software.amazon.awssdk.services.lambda.model.InvalidRuntimeException;
import software.amazon.awssdk.services.lambda.model.InvalidSecurityGroupIdException;
import software.amazon.awssdk.services.lambda.model.InvalidSubnetIdException;
import software.amazon.awssdk.services.lambda.model.InvalidZipFileException;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.lambda.model.KmsDisabledException;
import software.amazon.awssdk.services.lambda.model.KmsInvalidStateException;
import software.amazon.awssdk.services.lambda.model.KmsNotFoundException;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.lambda.model.PreconditionFailedException;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.RemovePermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemovePermissionResponse;
import software.amazon.awssdk.services.lambda.model.RequestTooLargeException;
import software.amazon.awssdk.services.lambda.model.ResourceConflictException;
import software.amazon.awssdk.services.lambda.model.ResourceInUseException;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.services.lambda.model.SubnetIpAddressLimitReachedException;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.TooManyRequestsException;
import software.amazon.awssdk.services.lambda.model.UnsupportedMediaTypeException;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateAliasRequest;
import software.amazon.awssdk.services.lambda.model.UpdateAliasResponse;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable;

/**
 * Service client for accessing AWS Lambda. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Lambda</fullname>
 * <p>
 * <b>Overview</b>
 * </p>
 * <p>
 * This is the <i>AWS Lambda API Reference</i>. The AWS Lambda Developer Guide provides additional information. For the
 * service overview, see <a href="http://docs.aws.amazon.com/lambda/latest/dg/welcome.html">What is AWS Lambda</a>, and
 * for information about how the service works, see <a
 * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html">AWS Lambda: How it Works</a> in the
 * <b>AWS Lambda Developer Guide</b>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface LambdaClient extends SdkClient {
    String SERVICE_NAME = "lambda";

    /**
     * Create a {@link LambdaClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static LambdaClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link LambdaClient}.
     */
    static LambdaClientBuilder builder() {
        return new DefaultLambdaClientBuilder();
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. Use this
     * action to grant layer usage permission to other accounts. You can grant permission to a single account, all AWS
     * accounts, or all accounts in an organization.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     * @return Result of the AddLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws PolicyLengthExceededException
     *         Lambda function access policy is limited to 20 KB.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default AddLayerVersionPermissionResponse addLayerVersionPermission(
            AddLayerVersionPermissionRequest addLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, InvalidParameterValueException,
            PolicyLengthExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. Use this
     * action to grant layer usage permission to other accounts. You can grant permission to a single account, all AWS
     * accounts, or all accounts in an organization.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddLayerVersionPermissionRequest.Builder} avoiding
     * the need to create one manually via {@link AddLayerVersionPermissionRequest#builder()}
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     *        A {@link Consumer} that will call methods on {@link AddLayerVersionPermissionRequest.Builder} to create a
     *        request.
     * @return Result of the AddLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws PolicyLengthExceededException
     *         Lambda function access policy is limited to 20 KB.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default AddLayerVersionPermissionResponse addLayerVersionPermission(
            Consumer<AddLayerVersionPermissionRequest.Builder> addLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, InvalidParameterValueException,
            PolicyLengthExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        return addLayerVersionPermission(AddLayerVersionPermissionRequest.builder()
                .applyMutation(addLayerVersionPermissionRequest).build());
    }

    /**
     * <p>
     * Grants an AWS service or another account permission to use a function. You can apply the policy at the function
     * level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the
     * invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. For AWS services,
     * the principal is a domain-style identifier defined by the service, like <code>s3.amazonaws.com</code> or
     * <code>sns.amazonaws.com</code>. For AWS services, you can also specify the ARN or owning account of the
     * associated resource as the <code>SourceArn</code> or <code>SourceAccount</code>. If you grant permission to a
     * service principal without specifying the source, other accounts could potentially configure resources in their
     * account to invoke your Lambda function.
     * </p>
     * <p>
     * This action adds a statement to a resource-based permission policy for the function. For more information about
     * function policies, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Lambda Function
     * Policies</a>.
     * </p>
     *
     * @param addPermissionRequest
     * @return Result of the AddPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws PolicyLengthExceededException
     *         Lambda function access policy is limited to 20 KB.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, PolicyLengthExceededException,
            TooManyRequestsException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants an AWS service or another account permission to use a function. You can apply the policy at the function
     * level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the
     * invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. For AWS services,
     * the principal is a domain-style identifier defined by the service, like <code>s3.amazonaws.com</code> or
     * <code>sns.amazonaws.com</code>. For AWS services, you can also specify the ARN or owning account of the
     * associated resource as the <code>SourceArn</code> or <code>SourceAccount</code>. If you grant permission to a
     * service principal without specifying the source, other accounts could potentially configure resources in their
     * account to invoke your Lambda function.
     * </p>
     * <p>
     * This action adds a statement to a resource-based permission policy for the function. For more information about
     * function policies, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Lambda Function
     * Policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link AddPermissionRequest#builder()}
     * </p>
     *
     * @param addPermissionRequest
     *        A {@link Consumer} that will call methods on {@link AddPermissionRequest.Builder} to create a request.
     * @return Result of the AddPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws PolicyLengthExceededException
     *         Lambda function access policy is limited to 20 KB.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default AddPermissionResponse addPermission(Consumer<AddPermissionRequest.Builder> addPermissionRequest)
            throws ServiceException, ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException,
            PolicyLengthExceededException, TooManyRequestsException, PreconditionFailedException, AwsServiceException,
            SdkClientException, LambdaException {
        return addPermission(AddPermissionRequest.builder().applyMutation(addPermissionRequest).build());
    }

    /**
     * <p>
     * Creates an <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a> for a Lambda
     * function version. Use aliases to provide clients with a function identifier that you can update to invoke a
     * different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     *
     * @param createAliasRequest
     * @return Result of the CreateAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a> for a Lambda
     * function version. Use aliases to provide clients with a function identifier that you can update to invoke a
     * different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on {@link CreateAliasRequest.Builder} to create a request.
     * @return Result of the CreateAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAliasResponse createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates a mapping between an event source and an AWS Lambda function. Lambda reads items from the event source
     * and triggers the function.
     * </p>
     * <p>
     * For details about each event source type, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html">Using AWS Lambda with Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html">Using AWS Lambda with Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html">Using AWS Lambda with Amazon DynamoDB</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventSourceMappingRequest
     * @return Result of the CreateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventSourceMappingResponse createEventSourceMapping(
            CreateEventSourceMappingRequest createEventSourceMappingRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a mapping between an event source and an AWS Lambda function. Lambda reads items from the event source
     * and triggers the function.
     * </p>
     * <p>
     * For details about each event source type, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html">Using AWS Lambda with Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html">Using AWS Lambda with Amazon SQS</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="http://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html">Using AWS Lambda with Amazon DynamoDB</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param createEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return Result of the CreateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventSourceMappingResponse createEventSourceMapping(
            Consumer<CreateEventSourceMappingRequest.Builder> createEventSourceMappingRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        return createEventSourceMapping(CreateEventSourceMappingRequest.builder().applyMutation(createEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html">deployment package</a> and an <a
     * href
     * ="http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">execution
     * role</a>. The deployment package contains your function code. The execution role grants the function permission
     * to use AWS services such as Amazon CloudWatch Logs for log streaming and AWS X-Ray for request tracing.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. A published version is a
     * snapshot of your function code and configuration that can not be changed. An alias is a named resource that maps
     * to a version, and can be changed to map to a different version. Use the <code>Publish</code> parameter to create
     * version <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * If another account or a AWS service invokes your function, use <a>AddPermission</a> to grant permission by
     * creating a resource-based IAM policy. You can grant permissions at the function level, on a version, or on an
     * alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other AWS
     * services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a function trigger in
     * the other service. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/invoking-lambda-functions.html">Invoking Functions</a>.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException, TooManyRequestsException,
            CodeStorageExceededException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html">deployment package</a> and an <a
     * href
     * ="http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">execution
     * role</a>. The deployment package contains your function code. The execution role grants the function permission
     * to use AWS services such as Amazon CloudWatch Logs for log streaming and AWS X-Ray for request tracing.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. A published version is a
     * snapshot of your function code and configuration that can not be changed. An alias is a named resource that maps
     * to a version, and can be changed to map to a different version. Use the <code>Publish</code> parameter to create
     * version <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * If another account or a AWS service invokes your function, use <a>AddPermission</a> to grant permission by
     * creating a resource-based IAM policy. You can grant permissions at the function level, on a version, or on an
     * alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other AWS
     * services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a function trigger in
     * the other service. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/invoking-lambda-functions.html">Invoking Functions</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFunctionRequest#builder()}
     * </p>
     *
     * @param createFunctionRequest
     *        A {@link Consumer} that will call methods on {@link CreateFunctionRequest.Builder} to create a request.
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFunctionResponse createFunction(Consumer<CreateFunctionRequest.Builder> createFunctionRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException,
            TooManyRequestsException, CodeStorageExceededException, AwsServiceException, SdkClientException, LambdaException {
        return createFunction(CreateFunctionRequest.builder().applyMutation(createFunctionRequest).build());
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param deleteAliasRequest
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAliasRequest#builder()}
     * </p>
     *
     * @param deleteAliasRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAliasRequest.Builder} to create a request.
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAliasResponse deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return deleteAlias(DeleteAliasRequest.builder().applyMutation(deleteAliasRequest).build());
    }

    /**
     * <p>
     * Deletes an <a href="http://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     * @return Result of the DeleteEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to update an
     *         EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventSourceMappingResponse deleteEventSourceMapping(
            DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, ResourceInUseException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <a href="http://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to update an
     *         EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventSourceMappingResponse deleteEventSourceMapping(
            Consumer<DeleteEventSourceMappingRequest.Builder> deleteEventSourceMappingRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceInUseException,
            AwsServiceException, SdkClientException, LambdaException {
        return deleteEventSourceMapping(DeleteEventSourceMappingRequest.builder().applyMutation(deleteEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted.
     * </p>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For AWS
     * services and resources that invoke your function directly, delete the trigger in the service where you originally
     * configured it.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted.
     * </p>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For AWS
     * services and resources that invoke your function directly, delete the trigger in the service where you originally
     * configured it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFunctionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionRequest.Builder} to create a request.
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFunctionResponse deleteFunction(Consumer<DeleteFunctionRequest.Builder> deleteFunctionRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        return deleteFunction(DeleteFunctionRequest.builder().applyMutation(deleteFunctionRequest).build());
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     * @return Result of the DeleteFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionConcurrencyResponse deleteFunctionConcurrency(
            DeleteFunctionConcurrencyRequest deleteFunctionConcurrencyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionConcurrencyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFunctionConcurrencyResponse deleteFunctionConcurrency(
            Consumer<DeleteFunctionConcurrencyRequest.Builder> deleteFunctionConcurrencyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return deleteFunctionConcurrency(DeleteFunctionConcurrencyRequest.builder()
                .applyMutation(deleteFunctionConcurrencyRequest).build());
    }

    /**
     * <p>
     * Deletes a version of an <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a
     * copy of the version remains in Lambda until no functions refer to it.
     * </p>
     *
     * @param deleteLayerVersionRequest
     * @return Result of the DeleteLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLayerVersionResponse deleteLayerVersion(DeleteLayerVersionRequest deleteLayerVersionRequest)
            throws ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a version of an <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a
     * copy of the version remains in Lambda until no functions refer to it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLayerVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLayerVersionRequest#builder()}
     * </p>
     *
     * @param deleteLayerVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLayerVersionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLayerVersionResponse deleteLayerVersion(Consumer<DeleteLayerVersionRequest.Builder> deleteLayerVersionRequest)
            throws ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return deleteLayerVersion(DeleteLayerVersionRequest.builder().applyMutation(deleteLayerVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in a region.
     * </p>
     *
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAccountSettings
     * @see #getAccountSettings(GetAccountSettingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings() throws TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return getAccountSettings(GetAccountSettingsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in a region.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest)
            throws TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in a region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountSettingsRequest.Builder} to create a
     *        request.
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings(Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest)
            throws TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param getAliasRequest
     * @return Result of the GetAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAliasResponse getAlias(GetAliasRequest getAliasRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAliasRequest.Builder} avoiding the need to
     * create one manually via {@link GetAliasRequest#builder()}
     * </p>
     *
     * @param getAliasRequest
     *        A {@link Consumer} that will call methods on {@link GetAliasRequest.Builder} to create a request.
     * @return Result of the GetAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAliasResponse getAlias(Consumer<GetAliasRequest.Builder> getAliasRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return getAlias(GetAliasRequest.builder().applyMutation(getAliasRequest).build());
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     *
     * @param getEventSourceMappingRequest
     * @return Result of the GetEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventSourceMappingResponse getEventSourceMapping(GetEventSourceMappingRequest getEventSourceMappingRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventSourceMappingRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param getEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on {@link GetEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return Result of the GetEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventSourceMappingResponse getEventSourceMapping(
            Consumer<GetEventSourceMappingRequest.Builder> getEventSourceMappingRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return getEventSourceMapping(GetEventSourceMappingRequest.builder().applyMutation(getEventSourceMappingRequest).build());
    }

    /**
     * <p>
     * Returns information about function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details specific to that version are returned.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details specific to that version are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link GetFunctionRequest#builder()}
     * </p>
     *
     * @param getFunctionRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionRequest.Builder} to create a request.
     * @return Result of the GetFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFunctionResponse getFunction(Consumer<GetFunctionRequest.Builder> getFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return getFunction(GetFunctionRequest.builder().applyMutation(getFunctionRequest).build());
    }

    /**
     * <p>
     * Returns a the version-specific settings of a Lambda function or version. The output includes only options that
     * can vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     *
     * @param getFunctionConfigurationRequest
     * @return Result of the GetFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionConfigurationResponse getFunctionConfiguration(
            GetFunctionConfigurationRequest getFunctionConfigurationRequest) throws ServiceException, ResourceNotFoundException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a the version-specific settings of a Lambda function or version. The output includes only options that
     * can vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetFunctionConfigurationRequest#builder()}
     * </p>
     *
     * @param getFunctionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetFunctionConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFunctionConfigurationResponse getFunctionConfiguration(
            Consumer<GetFunctionConfigurationRequest.Builder> getFunctionConfigurationRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return getFunctionConfiguration(GetFunctionConfigurationRequest.builder().applyMutation(getFunctionConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionRequest
     * @return Result of the GetLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLayerVersionResponse getLayerVersion(GetLayerVersionRequest getLayerVersionRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>, with a link to
     * download the layer archive that's valid for 10 minutes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetLayerVersionRequest#builder()}
     * </p>
     *
     * @param getLayerVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetLayerVersionRequest.Builder} to create a request.
     * @return Result of the GetLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLayerVersionResponse getLayerVersion(Consumer<GetLayerVersionRequest.Builder> getLayerVersionRequest)
            throws ServiceException, InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        return getLayerVersion(GetLayerVersionRequest.builder().applyMutation(getLayerVersionRequest).build());
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     * @return Result of the GetLayerVersionPolicy operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLayerVersionPolicyResponse getLayerVersionPolicy(GetLayerVersionPolicyRequest getLayerVersionPolicyRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayerVersionPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetLayerVersionPolicyRequest#builder()}
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetLayerVersionPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetLayerVersionPolicy operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLayerVersionPolicyResponse getLayerVersionPolicy(
            Consumer<GetLayerVersionPolicyRequest.Builder> getLayerVersionPolicyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return getLayerVersionPolicy(GetLayerVersionPolicyRequest.builder().applyMutation(getLayerVersionPolicyRequest).build());
    }

    /**
     * <p>
     * Returns the <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ServiceException, ResourceNotFoundException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on {@link GetPolicyRequest.Builder} to create a request.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPolicyResponse getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously and wait for the response, or asynchronously.
     * To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.
     * </p>
     * <p>
     * For synchronous invocation, details about the function response, including errors, are included in the response
     * body and headers. For either invocation type, you can find more information in the <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/dlq.html">trace</a>. To record function errors for asynchronous
     * invocations, configure your function with a <a href="http://docs.aws.amazon.com/lambda/latest/dg/dlq.html">dead
     * letter queue</a>.
     * </p>
     * <p>
     * The status code in the API response does not reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">limit errors</a>, or issues with your function's
     * code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if executing the
     * function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client may be disconnected during synchronous invocation while it waits
     * for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long
     * connections with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:InvokeFunction</code> action.
     * </p>
     *
     * @param invokeRequest
     * @return Result of the Invoke operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidRequestContentException
     *         The request body could not be parsed as JSON.
     * @throws RequestTooLargeException
     *         The request payload exceeded the <code>Invoke</code> request body JSON input limit. For more information,
     *         see <a href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>.
     * @throws UnsupportedMediaTypeException
     *         The content type of the <code>Invoke</code> request body is not JSON.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws Ec2UnexpectedException
     *         AWS Lambda received an unexpected EC2 client exception while setting up for the Lambda function.
     * @throws SubnetIpAddressLimitReachedException
     *         AWS Lambda was not able to set up VPC access for the Lambda function because one or more configured
     *         subnets has no available IP addresses.
     * @throws EniLimitReachedException
     *         AWS Lambda was not able to create an Elastic Network Interface (ENI) in the VPC, specified as part of
     *         Lambda function configuration, because the limit for network interfaces has been reached.
     * @throws Ec2ThrottledException
     *         AWS Lambda was throttled by Amazon EC2 during Lambda function initialization using the execution role
     *         provided for the Lambda function.
     * @throws Ec2AccessDeniedException
     *         Need additional permissions to configure VPC settings.
     * @throws InvalidSubnetIdException
     *         The Subnet ID provided in the Lambda function VPC configuration is invalid.
     * @throws InvalidSecurityGroupIdException
     *         The Security Group ID provided in the Lambda function VPC configuration is invalid.
     * @throws InvalidZipFileException
     *         AWS Lambda could not unzip the deployment package.
     * @throws KmsDisabledException
     *         Lambda was unable to decrypt the environment variables because the KMS key used is disabled. Check the
     *         Lambda function's KMS key settings.
     * @throws KmsInvalidStateException
     *         Lambda was unable to decrypt the environment variables because the KMS key used is in an invalid state
     *         for Decrypt. Check the function's KMS key settings.
     * @throws KmsAccessDeniedException
     *         Lambda was unable to decrypt the environment variables because KMS access was denied. Check the Lambda
     *         function's KMS permissions.
     * @throws KmsNotFoundException
     *         Lambda was unable to decrypt the environment variables because the KMS key was not found. Check the
     *         function's KMS key settings.
     * @throws InvalidRuntimeException
     *         The runtime or runtime version specified is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.Invoke
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    default InvokeResponse invoke(InvokeRequest invokeRequest) throws ServiceException, ResourceNotFoundException,
            InvalidRequestContentException, RequestTooLargeException, UnsupportedMediaTypeException, TooManyRequestsException,
            InvalidParameterValueException, Ec2UnexpectedException, SubnetIpAddressLimitReachedException,
            EniLimitReachedException, Ec2ThrottledException, Ec2AccessDeniedException, InvalidSubnetIdException,
            InvalidSecurityGroupIdException, InvalidZipFileException, KmsDisabledException, KmsInvalidStateException,
            KmsAccessDeniedException, KmsNotFoundException, InvalidRuntimeException, AwsServiceException, SdkClientException,
            LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously and wait for the response, or asynchronously.
     * To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.
     * </p>
     * <p>
     * For synchronous invocation, details about the function response, including errors, are included in the response
     * body and headers. For either invocation type, you can find more information in the <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/dlq.html">trace</a>. To record function errors for asynchronous
     * invocations, configure your function with a <a href="http://docs.aws.amazon.com/lambda/latest/dg/dlq.html">dead
     * letter queue</a>.
     * </p>
     * <p>
     * The status code in the API response does not reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">limit errors</a>, or issues with your function's
     * code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if executing the
     * function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client may be disconnected during synchronous invocation while it waits
     * for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long
     * connections with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:InvokeFunction</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InvokeRequest.Builder} avoiding the need to create
     * one manually via {@link InvokeRequest#builder()}
     * </p>
     *
     * @param invokeRequest
     *        A {@link Consumer} that will call methods on {@link InvocationRequest.Builder} to create a request.
     * @return Result of the Invoke operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidRequestContentException
     *         The request body could not be parsed as JSON.
     * @throws RequestTooLargeException
     *         The request payload exceeded the <code>Invoke</code> request body JSON input limit. For more information,
     *         see <a href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>.
     * @throws UnsupportedMediaTypeException
     *         The content type of the <code>Invoke</code> request body is not JSON.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws Ec2UnexpectedException
     *         AWS Lambda received an unexpected EC2 client exception while setting up for the Lambda function.
     * @throws SubnetIpAddressLimitReachedException
     *         AWS Lambda was not able to set up VPC access for the Lambda function because one or more configured
     *         subnets has no available IP addresses.
     * @throws EniLimitReachedException
     *         AWS Lambda was not able to create an Elastic Network Interface (ENI) in the VPC, specified as part of
     *         Lambda function configuration, because the limit for network interfaces has been reached.
     * @throws Ec2ThrottledException
     *         AWS Lambda was throttled by Amazon EC2 during Lambda function initialization using the execution role
     *         provided for the Lambda function.
     * @throws Ec2AccessDeniedException
     *         Need additional permissions to configure VPC settings.
     * @throws InvalidSubnetIdException
     *         The Subnet ID provided in the Lambda function VPC configuration is invalid.
     * @throws InvalidSecurityGroupIdException
     *         The Security Group ID provided in the Lambda function VPC configuration is invalid.
     * @throws InvalidZipFileException
     *         AWS Lambda could not unzip the deployment package.
     * @throws KmsDisabledException
     *         Lambda was unable to decrypt the environment variables because the KMS key used is disabled. Check the
     *         Lambda function's KMS key settings.
     * @throws KmsInvalidStateException
     *         Lambda was unable to decrypt the environment variables because the KMS key used is in an invalid state
     *         for Decrypt. Check the function's KMS key settings.
     * @throws KmsAccessDeniedException
     *         Lambda was unable to decrypt the environment variables because KMS access was denied. Check the Lambda
     *         function's KMS permissions.
     * @throws KmsNotFoundException
     *         Lambda was unable to decrypt the environment variables because the KMS key was not found. Check the
     *         function's KMS key settings.
     * @throws InvalidRuntimeException
     *         The runtime or runtime version specified is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.Invoke
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    default InvokeResponse invoke(Consumer<InvokeRequest.Builder> invokeRequest) throws ServiceException,
            ResourceNotFoundException, InvalidRequestContentException, RequestTooLargeException, UnsupportedMediaTypeException,
            TooManyRequestsException, InvalidParameterValueException, Ec2UnexpectedException,
            SubnetIpAddressLimitReachedException, EniLimitReachedException, Ec2ThrottledException, Ec2AccessDeniedException,
            InvalidSubnetIdException, InvalidSecurityGroupIdException, InvalidZipFileException, KmsDisabledException,
            KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, InvalidRuntimeException,
            AwsServiceException, SdkClientException, LambdaException {
        return invoke(InvokeRequest.builder().applyMutation(invokeRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a> for a
     * Lambda function.
     * </p>
     *
     * @param listAliasesRequest
     * @return Result of the ListAliases operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a> for a
     * Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on {@link ListAliasesRequest.Builder} to create a request.
     * @return Result of the ListAliases operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesResponse listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     *
     * @return Result of the ListEventSourceMappings operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see #listEventSourceMappings(ListEventSourceMappingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsResponse listEventSourceMappings() throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return listEventSourceMappings(ListEventSourceMappingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return Result of the ListEventSourceMappings operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsResponse listEventSourceMappings(ListEventSourceMappingsRequest listEventSourceMappingsRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourceMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventSourceMappingsRequest#builder()}
     * </p>
     *
     * @param listEventSourceMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSourceMappingsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEventSourceMappings operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsResponse listEventSourceMappings(
            Consumer<ListEventSourceMappingsRequest.Builder> listEventSourceMappingsRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listEventSourceMappings(ListEventSourceMappingsRequest.builder().applyMutation(listEventSourceMappingsRequest)
                .build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client
     *             .listEventSourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see #listEventSourceMappingsPaginator(ListEventSourceMappingsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsIterable listEventSourceMappingsPaginator() throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listEventSourceMappingsPaginator(ListEventSourceMappingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client
     *             .listEventSourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsIterable listEventSourceMappingsPaginator(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client
     *             .listEventSourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventSourceMappingsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEventSourceMappingsRequest#builder()}
     * </p>
     *
     * @param listEventSourceMappingsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventSourceMappingsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    default ListEventSourceMappingsIterable listEventSourceMappingsPaginator(
            Consumer<ListEventSourceMappingsRequest.Builder> listEventSourceMappingsRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listEventSourceMappingsPaginator(ListEventSourceMappingsRequest.builder()
                .applyMutation(listEventSourceMappingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     *
     * @return Result of the ListFunctions operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see #listFunctions(ListFunctionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions() throws ServiceException, TooManyRequestsException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return listFunctions(ListFunctionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws ServiceException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionsRequest.Builder} to create a request.
     * @return Result of the ListFunctions operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest)
            throws ServiceException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return listFunctions(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see #listFunctionsPaginator(ListFunctionsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsIterable listFunctionsPaginator() throws ServiceException, TooManyRequestsException,
            InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return listFunctionsPaginator(ListFunctionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @param listFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsIterable listFunctionsPaginator(ListFunctionsRequest listFunctionsRequest) throws ServiceException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFunctionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsIterable listFunctionsPaginator(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest)
            throws ServiceException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        return listFunctionsPaginator(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of an <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime.
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return Result of the ListLayerVersions operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayerVersionsResponse listLayerVersions(ListLayerVersionsRequest listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of an <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayerVersionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLayerVersionsRequest#builder()}
     * </p>
     *
     * @param listLayerVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListLayerVersionsRequest.Builder} to create a request.
     * @return Result of the ListLayerVersions operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayerVersionsResponse listLayerVersions(Consumer<ListLayerVersionsRequest.Builder> listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return listLayerVersions(ListLayerVersionsRequest.builder().applyMutation(listLayerVersionsRequest).build());
    }

    /**
     * <p>
     * Lists <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layers</a> and
     * shows information about the latest version of each. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     *
     * @return Result of the ListLayers operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see #listLayers(ListLayersRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersResponse listLayers() throws ServiceException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return listLayers(ListLayersRequest.builder().build());
    }

    /**
     * <p>
     * Lists <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layers</a> and
     * shows information about the latest version of each. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     *
     * @param listLayersRequest
     * @return Result of the ListLayers operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersResponse listLayers(ListLayersRequest listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layers</a> and
     * shows information about the latest version of each. Specify a <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayersRequest.Builder} avoiding the need to
     * create one manually via {@link ListLayersRequest#builder()}
     * </p>
     *
     * @param listLayersRequest
     *        A {@link Consumer} that will call methods on {@link ListLayersRequest.Builder} to create a request.
     * @return Result of the ListLayers operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayersResponse listLayers(Consumer<ListLayersRequest.Builder> listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return listLayers(ListLayersRequest.builder().applyMutation(listLayersRequest).build());
    }

    /**
     * <p>
     * Returns a function's <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also
     * view tags with <a>GetFunction</a>.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a function's <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also
     * view tags with <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTagsRequest#builder()}
     * </p>
     *
     * @param listTagsRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsRequest.Builder} to create a request.
     * @return Result of the ListTags operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsResponse listTags(Consumer<ListTagsRequest.Builder> listTagsRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listTags(ListTagsRequest.builder().applyMutation(listTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each.
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return Result of the ListVersionsByFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVersionsByFunctionResponse listVersionsByFunction(ListVersionsByFunctionRequest listVersionsByFunctionRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVersionsByFunctionRequest.Builder} avoiding the
     * need to create one manually via {@link ListVersionsByFunctionRequest#builder()}
     * </p>
     *
     * @param listVersionsByFunctionRequest
     *        A {@link Consumer} that will call methods on {@link ListVersionsByFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the ListVersionsByFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVersionsByFunctionResponse listVersionsByFunction(
            Consumer<ListVersionsByFunctionRequest.Builder> listVersionsByFunctionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return listVersionsByFunction(ListVersionsByFunctionRequest.builder().applyMutation(listVersionsByFunctionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>
     * from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same version name, a new version
     * is created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     *
     * @param publishLayerVersionRequest
     * @return Result of the PublishLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default PublishLayerVersionResponse publishLayerVersion(PublishLayerVersionRequest publishLayerVersionRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            CodeStorageExceededException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <a href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>
     * from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same version name, a new version
     * is created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishLayerVersionRequest.Builder} avoiding the
     * need to create one manually via {@link PublishLayerVersionRequest#builder()}
     * </p>
     *
     * @param publishLayerVersionRequest
     *        A {@link Consumer} that will call methods on {@link PublishLayerVersionRequest.Builder} to create a
     *        request.
     * @return Result of the PublishLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default PublishLayerVersionResponse publishLayerVersion(
            Consumer<PublishLayerVersionRequest.Builder> publishLayerVersionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, CodeStorageExceededException,
            AwsServiceException, SdkClientException, LambdaException {
        return publishLayerVersion(PublishLayerVersionRequest.builder().applyMutation(publishLayerVersionRequest).build());
    }

    /**
     * <p>
     * Creates a <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * AWS Lambda does not publish a version if the function's configuration and code hasn't changed since the last
     * version. Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function prior to
     * publishing a version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     *
     * @param publishVersionRequest
     * @return Result of the PublishVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default PublishVersionResponse publishVersion(PublishVersionRequest publishVersionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, CodeStorageExceededException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <a href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * AWS Lambda does not publish a version if the function's configuration and code hasn't changed since the last
     * version. Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function prior to
     * publishing a version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishVersionRequest.Builder} avoiding the need to
     * create one manually via {@link PublishVersionRequest#builder()}
     * </p>
     *
     * @param publishVersionRequest
     *        A {@link Consumer} that will call methods on {@link PublishVersionRequest.Builder} to create a request.
     * @return Result of the PublishVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default PublishVersionResponse publishVersion(Consumer<PublishVersionRequest.Builder> publishVersionRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            CodeStorageExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        return publishVersion(PublishVersionRequest.builder().applyMutation(publishVersionRequest).build());
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both guarantees that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     * @return Result of the PutFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default PutFunctionConcurrencyResponse putFunctionConcurrency(PutFunctionConcurrencyRequest putFunctionConcurrencyRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both guarantees that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutFunctionConcurrencyRequest.Builder} avoiding the
     * need to create one manually via {@link PutFunctionConcurrencyRequest#builder()}
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     *        A {@link Consumer} that will call methods on {@link PutFunctionConcurrencyRequest.Builder} to create a
     *        request.
     * @return Result of the PutFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    default PutFunctionConcurrencyResponse putFunctionConcurrency(
            Consumer<PutFunctionConcurrencyRequest.Builder> putFunctionConcurrencyRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return putFunctionConcurrency(PutFunctionConcurrencyRequest.builder().applyMutation(putFunctionConcurrencyRequest)
                .build());
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     * @return Result of the RemoveLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemoveLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveLayerVersionPermissionResponse removeLayerVersionPermission(
            RemoveLayerVersionPermissionRequest removeLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveLayerVersionPermissionRequest.Builder}
     * avoiding the need to create one manually via {@link RemoveLayerVersionPermissionRequest#builder()}
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     *        A {@link Consumer} that will call methods on {@link RemoveLayerVersionPermissionRequest.Builder} to create
     *        a request.
     * @return Result of the RemoveLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemoveLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default RemoveLayerVersionPermissionResponse removeLayerVersionPermission(
            Consumer<RemoveLayerVersionPermissionRequest.Builder> removeLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        return removeLayerVersionPermission(RemoveLayerVersionPermissionRequest.builder()
                .applyMutation(removeLayerVersionPermissionRequest).build());
    }

    /**
     * <p>
     * Revokes function use permission from an AWS service or another account. You can get the ID of the statement from
     * the output of <a>GetPolicy</a>.
     * </p>
     *
     * @param removePermissionRequest
     * @return Result of the RemovePermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Revokes function use permission from an AWS service or another account. You can get the ID of the statement from
     * the output of <a>GetPolicy</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     * </p>
     *
     * @param removePermissionRequest
     *        A {@link Consumer} that will call methods on {@link RemovePermissionRequest.Builder} to create a request.
     * @return Result of the RemovePermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default RemovePermissionResponse removePermission(Consumer<RemovePermissionRequest.Builder> removePermissionRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        return removePermission(RemovePermissionRequest.builder().applyMutation(removePermissionRequest).build());
    }

    /**
     * <p>
     * Adds <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes <a href="http://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param updateAliasRequest
     * @return Result of the UpdateAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateAliasRequest#builder()}
     * </p>
     *
     * @param updateAliasRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAliasRequest.Builder} to create a request.
     * @return Result of the UpdateAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateAliasResponse updateAlias(Consumer<UpdateAliasRequest.Builder> updateAliasRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        return updateAlias(UpdateAliasRequest.builder().applyMutation(updateAliasRequest).build());
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that AWS Lambda invokes, or pause invocation and
     * resume later from the same location.
     * </p>
     *
     * @param updateEventSourceMappingRequest
     * @return Result of the UpdateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to update an
     *         EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventSourceMappingResponse updateEventSourceMapping(
            UpdateEventSourceMappingRequest updateEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, ResourceConflictException, ResourceInUseException,
            AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that AWS Lambda invokes, or pause invocation and
     * resume later from the same location.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventSourceMappingRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateEventSourceMappingRequest#builder()}
     * </p>
     *
     * @param updateEventSourceMappingRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEventSourceMappingRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to update an
     *         EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEventSourceMappingResponse updateEventSourceMapping(
            Consumer<UpdateEventSourceMappingRequest.Builder> updateEventSourceMappingRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            ResourceInUseException, AwsServiceException, SdkClientException, LambdaException {
        return updateEventSourceMapping(UpdateEventSourceMappingRequest.builder().applyMutation(updateEventSourceMappingRequest)
                .build());
    }

    /**
     * <p>
     * Updates a Lambda function's code.
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You cannot modify the code of a published version, only
     * the unpublished version.
     * </p>
     *
     * @param updateFunctionCodeRequest
     * @return Result of the UpdateFunctionCode operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFunctionCodeResponse updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            CodeStorageExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a Lambda function's code.
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You cannot modify the code of a published version, only
     * the unpublished version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionCodeRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFunctionCodeRequest#builder()}
     * </p>
     *
     * @param updateFunctionCodeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionCodeRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFunctionCode operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="http://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFunctionCodeResponse updateFunctionCode(Consumer<UpdateFunctionCodeRequest.Builder> updateFunctionCodeRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            CodeStorageExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        return updateFunctionCode(UpdateFunctionCodeRequest.builder().applyMutation(updateFunctionCodeRequest).build());
    }

    /**
     * <p>
     * Modify the version-specifc settings of a Lambda function.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You cannot
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an account
     * or AWS service, use <a>AddPermission</a>.
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     * @return Result of the UpdateFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionConfigurationResponse updateFunctionConfiguration(
            UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modify the version-specifc settings of a Lambda function.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You cannot
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an account
     * or AWS service, use <a>AddPermission</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateFunctionConfigurationRequest#builder()}
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFunctionConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource (for example, a Lambda function or access policy statement) specified in the request does
     *         not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid. For example, if you provided an IAM role for AWS Lambda
     *         to assume in the <code>CreateFunction</code> or the <code>UpdateFunctionConfiguration</code> API, that
     *         AWS Lambda is unable to assume you will get this exception.
     * @throws TooManyRequestsException
     *         Request throughput limit exceeded.
     * @throws ResourceConflictException
     *         The resource already exists.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFunctionConfigurationResponse updateFunctionConfiguration(
            Consumer<UpdateFunctionConfigurationRequest.Builder> updateFunctionConfigurationRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        return updateFunctionConfiguration(UpdateFunctionConfigurationRequest.builder()
                .applyMutation(updateFunctionConfigurationRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("lambda");
    }
}
