/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeResponse extends LambdaResponse implements ToCopyableBuilder<InvokeResponse.Builder, InvokeResponse> {
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InvokeResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()).build();

    private static final SdkField<String> FUNCTION_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvokeResponse::functionError)).setter(setter(Builder::functionError))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Function-Error").build())
            .build();

    private static final SdkField<String> LOG_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvokeResponse::logResult)).setter(setter(Builder::logResult))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Log-Result").build()).build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(InvokeResponse::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> EXECUTED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InvokeResponse::executedVersion)).setter(setter(Builder::executedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Executed-Version").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            FUNCTION_ERROR_FIELD, LOG_RESULT_FIELD, PAYLOAD_FIELD, EXECUTED_VERSION_FIELD));

    private final Integer statusCode;

    private final String functionError;

    private final String logResult;

    private final SdkBytes payload;

    private final String executedVersion;

    private InvokeResponse(BuilderImpl builder) {
        super(builder);
        this.statusCode = builder.statusCode;
        this.functionError = builder.functionError;
        this.logResult = builder.logResult;
        this.payload = builder.payload;
        this.executedVersion = builder.executedVersion;
    }

    /**
     * <p>
     * The HTTP status code will be in the 200 range for successful request. For the <code>RequestResponse</code>
     * invocation type this status code will be 200. For the <code>Event</code> invocation type this status code will be
     * 202. For the <code>DryRun</code> invocation type the status code will be 204.
     * </p>
     * 
     * @return The HTTP status code will be in the 200 range for successful request. For the
     *         <code>RequestResponse</code> invocation type this status code will be 200. For the <code>Event</code>
     *         invocation type this status code will be 202. For the <code>DryRun</code> invocation type the status code
     *         will be 204.
     */
    public Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * If present, indicates that an error occured during function execution. Details about the error are included in
     * the response payload.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Handled</code> - The runtime caught an error thrown by the function and formatted it into a JSON document.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Unhandled</code> - The runtime did not handle the error. For example, the function ran out of memory or
     * timed out.
     * </p>
     * </li>
     * </ul>
     * 
     * @return If present, indicates that an error occured during function execution. Details about the error are
     *         included in the response payload.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Handled</code> - The runtime caught an error thrown by the function and formatted it into a JSON
     *         document.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Unhandled</code> - The runtime did not handle the error. For example, the function ran out of
     *         memory or timed out.
     *         </p>
     *         </li>
     */
    public String functionError() {
        return functionError;
    }

    /**
     * <p>
     * The last 4 KB of the execution log, base64 encoded.
     * </p>
     * 
     * @return The last 4 KB of the execution log, base64 encoded.
     */
    public String logResult() {
        return logResult;
    }

    /**
     * <p>
     * The response from the function, or an error object.
     * </p>
     * 
     * @return The response from the function, or an error object.
     */
    public SdkBytes payload() {
        return payload;
    }

    /**
     * <p>
     * The version of the function that executed. When you invoke a function with an alias, indicates which version the
     * alias resolved to.
     * </p>
     * 
     * @return The version of the function that executed. When you invoke a function with an alias, indicates which
     *         version the alias resolved to.
     */
    public String executedVersion() {
        return executedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(functionError());
        hashCode = 31 * hashCode + Objects.hashCode(logResult());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(executedVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeResponse)) {
            return false;
        }
        InvokeResponse other = (InvokeResponse) obj;
        return Objects.equals(statusCode(), other.statusCode()) && Objects.equals(functionError(), other.functionError())
                && Objects.equals(logResult(), other.logResult()) && Objects.equals(payload(), other.payload())
                && Objects.equals(executedVersion(), other.executedVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InvokeResponse").add("StatusCode", statusCode()).add("FunctionError", functionError())
                .add("LogResult", logResult()).add("Payload", payload() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExecutedVersion", executedVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "FunctionError":
            return Optional.ofNullable(clazz.cast(functionError()));
        case "LogResult":
            return Optional.ofNullable(clazz.cast(logResult()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "ExecutedVersion":
            return Optional.ofNullable(clazz.cast(executedVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeResponse, T> g) {
        return obj -> g.apply((InvokeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, InvokeResponse> {
        /**
         * <p>
         * The HTTP status code will be in the 200 range for successful request. For the <code>RequestResponse</code>
         * invocation type this status code will be 200. For the <code>Event</code> invocation type this status code
         * will be 202. For the <code>DryRun</code> invocation type the status code will be 204.
         * </p>
         * 
         * @param statusCode
         *        The HTTP status code will be in the 200 range for successful request. For the
         *        <code>RequestResponse</code> invocation type this status code will be 200. For the <code>Event</code>
         *        invocation type this status code will be 202. For the <code>DryRun</code> invocation type the status
         *        code will be 204.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * If present, indicates that an error occured during function execution. Details about the error are included
         * in the response payload.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Handled</code> - The runtime caught an error thrown by the function and formatted it into a JSON
         * document.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Unhandled</code> - The runtime did not handle the error. For example, the function ran out of memory or
         * timed out.
         * </p>
         * </li>
         * </ul>
         * 
         * @param functionError
         *        If present, indicates that an error occured during function execution. Details about the error are
         *        included in the response payload.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Handled</code> - The runtime caught an error thrown by the function and formatted it into a JSON
         *        document.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Unhandled</code> - The runtime did not handle the error. For example, the function ran out of
         *        memory or timed out.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionError(String functionError);

        /**
         * <p>
         * The last 4 KB of the execution log, base64 encoded.
         * </p>
         * 
         * @param logResult
         *        The last 4 KB of the execution log, base64 encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logResult(String logResult);

        /**
         * <p>
         * The response from the function, or an error object.
         * </p>
         * 
         * @param payload
         *        The response from the function, or an error object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        /**
         * <p>
         * The version of the function that executed. When you invoke a function with an alias, indicates which version
         * the alias resolved to.
         * </p>
         * 
         * @param executedVersion
         *        The version of the function that executed. When you invoke a function with an alias, indicates which
         *        version the alias resolved to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executedVersion(String executedVersion);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private Integer statusCode;

        private String functionError;

        private String logResult;

        private SdkBytes payload;

        private String executedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeResponse model) {
            super(model);
            statusCode(model.statusCode);
            functionError(model.functionError);
            logResult(model.logResult);
            payload(model.payload);
            executedVersion(model.executedVersion);
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getFunctionError() {
            return functionError;
        }

        @Override
        public final Builder functionError(String functionError) {
            this.functionError = functionError;
            return this;
        }

        public final void setFunctionError(String functionError) {
            this.functionError = functionError;
        }

        public final String getLogResult() {
            return logResult;
        }

        @Override
        public final Builder logResult(String logResult) {
            this.logResult = logResult;
            return this;
        }

        public final void setLogResult(String logResult) {
            this.logResult = logResult;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = StandardMemberCopier.copy(payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        public final String getExecutedVersion() {
            return executedVersion;
        }

        @Override
        public final Builder executedVersion(String executedVersion) {
            this.executedVersion = executedVersion;
            return this;
        }

        public final void setExecutedVersion(String executedVersion) {
            this.executedVersion = executedVersion;
        }

        @Override
        public InvokeResponse build() {
            return new InvokeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
