/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.FunctionUrlAuthType;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddPermissionRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, AddPermissionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(AddPermissionRequest.getter(AddPermissionRequest::functionName)).setter(AddPermissionRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatementId").getter(AddPermissionRequest.getter(AddPermissionRequest::statementId)).setter(AddPermissionRequest.setter(Builder::statementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementId").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(AddPermissionRequest.getter(AddPermissionRequest::action)).setter(AddPermissionRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Principal").getter(AddPermissionRequest.getter(AddPermissionRequest::principal)).setter(AddPermissionRequest.setter(Builder::principal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(AddPermissionRequest.getter(AddPermissionRequest::sourceArn)).setter(AddPermissionRequest.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> SOURCE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceAccount").getter(AddPermissionRequest.getter(AddPermissionRequest::sourceAccount)).setter(AddPermissionRequest.setter(Builder::sourceAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccount").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceToken").getter(AddPermissionRequest.getter(AddPermissionRequest::eventSourceToken)).setter(AddPermissionRequest.setter(Builder::eventSourceToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceToken").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qualifier").getter(AddPermissionRequest.getter(AddPermissionRequest::qualifier)).setter(AddPermissionRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevisionId").getter(AddPermissionRequest.getter(AddPermissionRequest::revisionId)).setter(AddPermissionRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()}).build();
    private static final SdkField<String> PRINCIPAL_ORG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalOrgID").getter(AddPermissionRequest.getter(AddPermissionRequest::principalOrgID)).setter(AddPermissionRequest.setter(Builder::principalOrgID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalOrgID").build()}).build();
    private static final SdkField<String> FUNCTION_URL_AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionUrlAuthType").getter(AddPermissionRequest.getter(AddPermissionRequest::functionUrlAuthTypeAsString)).setter(AddPermissionRequest.setter(Builder::functionUrlAuthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionUrlAuthType").build()}).build();
    private static final SdkField<Boolean> INVOKED_VIA_FUNCTION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InvokedViaFunctionUrl").getter(AddPermissionRequest.getter(AddPermissionRequest::invokedViaFunctionUrl)).setter(AddPermissionRequest.setter(Builder::invokedViaFunctionUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokedViaFunctionUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, STATEMENT_ID_FIELD, ACTION_FIELD, PRINCIPAL_FIELD, SOURCE_ARN_FIELD, SOURCE_ACCOUNT_FIELD, EVENT_SOURCE_TOKEN_FIELD, QUALIFIER_FIELD, REVISION_ID_FIELD, PRINCIPAL_ORG_ID_FIELD, FUNCTION_URL_AUTH_TYPE_FIELD, INVOKED_VIA_FUNCTION_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddPermissionRequest.memberNameToFieldInitializer();
    private final String functionName;
    private final String statementId;
    private final String action;
    private final String principal;
    private final String sourceArn;
    private final String sourceAccount;
    private final String eventSourceToken;
    private final String qualifier;
    private final String revisionId;
    private final String principalOrgID;
    private final String functionUrlAuthType;
    private final Boolean invokedViaFunctionUrl;

    private AddPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.statementId = builder.statementId;
        this.action = builder.action;
        this.principal = builder.principal;
        this.sourceArn = builder.sourceArn;
        this.sourceAccount = builder.sourceAccount;
        this.eventSourceToken = builder.eventSourceToken;
        this.qualifier = builder.qualifier;
        this.revisionId = builder.revisionId;
        this.principalOrgID = builder.principalOrgID;
        this.functionUrlAuthType = builder.functionUrlAuthType;
        this.invokedViaFunctionUrl = builder.invokedViaFunctionUrl;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String statementId() {
        return this.statementId;
    }

    public final String action() {
        return this.action;
    }

    public final String principal() {
        return this.principal;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String sourceAccount() {
        return this.sourceAccount;
    }

    public final String eventSourceToken() {
        return this.eventSourceToken;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String principalOrgID() {
        return this.principalOrgID;
    }

    public final FunctionUrlAuthType functionUrlAuthType() {
        return FunctionUrlAuthType.fromValue(this.functionUrlAuthType);
    }

    public final String functionUrlAuthTypeAsString() {
        return this.functionUrlAuthType;
    }

    public final Boolean invokedViaFunctionUrl() {
        return this.invokedViaFunctionUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalOrgID());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionUrlAuthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokedViaFunctionUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.statementId(), other.statementId()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.sourceAccount(), other.sourceAccount()) && Objects.equals(this.eventSourceToken(), other.eventSourceToken()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.principalOrgID(), other.principalOrgID()) && Objects.equals(this.functionUrlAuthTypeAsString(), other.functionUrlAuthTypeAsString()) && Objects.equals(this.invokedViaFunctionUrl(), other.invokedViaFunctionUrl());
    }

    public final String toString() {
        return ToString.builder((String)"AddPermissionRequest").add("FunctionName", (Object)this.functionName()).add("StatementId", (Object)this.statementId()).add("Action", (Object)this.action()).add("Principal", (Object)this.principal()).add("SourceArn", (Object)this.sourceArn()).add("SourceAccount", (Object)this.sourceAccount()).add("EventSourceToken", (Object)this.eventSourceToken()).add("Qualifier", (Object)this.qualifier()).add("RevisionId", (Object)this.revisionId()).add("PrincipalOrgID", (Object)this.principalOrgID()).add("FunctionUrlAuthType", (Object)this.functionUrlAuthTypeAsString()).add("InvokedViaFunctionUrl", (Object)this.invokedViaFunctionUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "StatementId": {
                return Optional.ofNullable(clazz.cast(this.statementId()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "SourceAccount": {
                return Optional.ofNullable(clazz.cast(this.sourceAccount()));
            }
            case "EventSourceToken": {
                return Optional.ofNullable(clazz.cast(this.eventSourceToken()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "RevisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "PrincipalOrgID": {
                return Optional.ofNullable(clazz.cast(this.principalOrgID()));
            }
            case "FunctionUrlAuthType": {
                return Optional.ofNullable(clazz.cast(this.functionUrlAuthTypeAsString()));
            }
            case "InvokedViaFunctionUrl": {
                return Optional.ofNullable(clazz.cast(this.invokedViaFunctionUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("StatementId", STATEMENT_ID_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Principal", PRINCIPAL_FIELD);
        map.put("SourceArn", SOURCE_ARN_FIELD);
        map.put("SourceAccount", SOURCE_ACCOUNT_FIELD);
        map.put("EventSourceToken", EVENT_SOURCE_TOKEN_FIELD);
        map.put("Qualifier", QUALIFIER_FIELD);
        map.put("RevisionId", REVISION_ID_FIELD);
        map.put("PrincipalOrgID", PRINCIPAL_ORG_ID_FIELD);
        map.put("FunctionUrlAuthType", FUNCTION_URL_AUTH_TYPE_FIELD);
        map.put("InvokedViaFunctionUrl", INVOKED_VIA_FUNCTION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddPermissionRequest, T> g) {
        return obj -> g.apply((AddPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String statementId;
        private String action;
        private String principal;
        private String sourceArn;
        private String sourceAccount;
        private String eventSourceToken;
        private String qualifier;
        private String revisionId;
        private String principalOrgID;
        private String functionUrlAuthType;
        private Boolean invokedViaFunctionUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.statementId(model.statementId);
            this.action(model.action);
            this.principal(model.principal);
            this.sourceArn(model.sourceArn);
            this.sourceAccount(model.sourceAccount);
            this.eventSourceToken(model.eventSourceToken);
            this.qualifier(model.qualifier);
            this.revisionId(model.revisionId);
            this.principalOrgID(model.principalOrgID);
            this.functionUrlAuthType(model.functionUrlAuthType);
            this.invokedViaFunctionUrl(model.invokedViaFunctionUrl);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getStatementId() {
            return this.statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final String getPrincipal() {
            return this.principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSourceAccount() {
            return this.sourceAccount;
        }

        public final void setSourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
        }

        @Override
        public final Builder sourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public final String getEventSourceToken() {
            return this.eventSourceToken;
        }

        public final void setEventSourceToken(String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
        }

        @Override
        public final Builder eventSourceToken(String eventSourceToken) {
            this.eventSourceToken = eventSourceToken;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getPrincipalOrgID() {
            return this.principalOrgID;
        }

        public final void setPrincipalOrgID(String principalOrgID) {
            this.principalOrgID = principalOrgID;
        }

        @Override
        public final Builder principalOrgID(String principalOrgID) {
            this.principalOrgID = principalOrgID;
            return this;
        }

        public final String getFunctionUrlAuthType() {
            return this.functionUrlAuthType;
        }

        public final void setFunctionUrlAuthType(String functionUrlAuthType) {
            this.functionUrlAuthType = functionUrlAuthType;
        }

        @Override
        public final Builder functionUrlAuthType(String functionUrlAuthType) {
            this.functionUrlAuthType = functionUrlAuthType;
            return this;
        }

        @Override
        public final Builder functionUrlAuthType(FunctionUrlAuthType functionUrlAuthType) {
            this.functionUrlAuthType(functionUrlAuthType == null ? null : functionUrlAuthType.toString());
            return this;
        }

        public final Boolean getInvokedViaFunctionUrl() {
            return this.invokedViaFunctionUrl;
        }

        public final void setInvokedViaFunctionUrl(Boolean invokedViaFunctionUrl) {
            this.invokedViaFunctionUrl = invokedViaFunctionUrl;
        }

        @Override
        public final Builder invokedViaFunctionUrl(Boolean invokedViaFunctionUrl) {
            this.invokedViaFunctionUrl = invokedViaFunctionUrl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddPermissionRequest> {
        public Builder functionName(String var1);

        public Builder statementId(String var1);

        public Builder action(String var1);

        public Builder principal(String var1);

        public Builder sourceArn(String var1);

        public Builder sourceAccount(String var1);

        public Builder eventSourceToken(String var1);

        public Builder qualifier(String var1);

        public Builder revisionId(String var1);

        public Builder principalOrgID(String var1);

        public Builder functionUrlAuthType(String var1);

        public Builder functionUrlAuthType(FunctionUrlAuthType var1);

        public Builder invokedViaFunctionUrl(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

