/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.CapacityProviderPermissionsConfig;
import software.amazon.awssdk.services.lambda.model.CapacityProviderScalingConfig;
import software.amazon.awssdk.services.lambda.model.CapacityProviderState;
import software.amazon.awssdk.services.lambda.model.CapacityProviderVpcConfig;
import software.amazon.awssdk.services.lambda.model.InstanceRequirements;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CapacityProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CapacityProvider> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityProviderArn").getter(CapacityProvider.getter(CapacityProvider::capacityProviderArn)).setter(CapacityProvider.setter(Builder::capacityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CapacityProvider.getter(CapacityProvider::stateAsString)).setter(CapacityProvider.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<CapacityProviderVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CapacityProvider.getter(CapacityProvider::vpcConfig)).setter(CapacityProvider.setter(Builder::vpcConfig)).constructor(CapacityProviderVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<CapacityProviderPermissionsConfig> PERMISSIONS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PermissionsConfig").getter(CapacityProvider.getter(CapacityProvider::permissionsConfig)).setter(CapacityProvider.setter(Builder::permissionsConfig)).constructor(CapacityProviderPermissionsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsConfig").build()}).build();
    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(CapacityProvider.getter(CapacityProvider::instanceRequirements)).setter(CapacityProvider.setter(Builder::instanceRequirements)).constructor(InstanceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").build()}).build();
    private static final SdkField<CapacityProviderScalingConfig> CAPACITY_PROVIDER_SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityProviderScalingConfig").getter(CapacityProvider.getter(CapacityProvider::capacityProviderScalingConfig)).setter(CapacityProvider.setter(Builder::capacityProviderScalingConfig)).constructor(CapacityProviderScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderScalingConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(CapacityProvider.getter(CapacityProvider::kmsKeyArn)).setter(CapacityProvider.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModified").getter(CapacityProvider.getter(CapacityProvider::lastModified)).setter(CapacityProvider.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD, STATE_FIELD, VPC_CONFIG_FIELD, PERMISSIONS_CONFIG_FIELD, INSTANCE_REQUIREMENTS_FIELD, CAPACITY_PROVIDER_SCALING_CONFIG_FIELD, KMS_KEY_ARN_FIELD, LAST_MODIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CapacityProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String capacityProviderArn;
    private final String state;
    private final CapacityProviderVpcConfig vpcConfig;
    private final CapacityProviderPermissionsConfig permissionsConfig;
    private final InstanceRequirements instanceRequirements;
    private final CapacityProviderScalingConfig capacityProviderScalingConfig;
    private final String kmsKeyArn;
    private final String lastModified;

    private CapacityProvider(BuilderImpl builder) {
        this.capacityProviderArn = builder.capacityProviderArn;
        this.state = builder.state;
        this.vpcConfig = builder.vpcConfig;
        this.permissionsConfig = builder.permissionsConfig;
        this.instanceRequirements = builder.instanceRequirements;
        this.capacityProviderScalingConfig = builder.capacityProviderScalingConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastModified = builder.lastModified;
    }

    public final String capacityProviderArn() {
        return this.capacityProviderArn;
    }

    public final CapacityProviderState state() {
        return CapacityProviderState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final CapacityProviderVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final CapacityProviderPermissionsConfig permissionsConfig() {
        return this.permissionsConfig;
    }

    public final InstanceRequirements instanceRequirements() {
        return this.instanceRequirements;
    }

    public final CapacityProviderScalingConfig capacityProviderScalingConfig() {
        return this.capacityProviderScalingConfig;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderScalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProvider)) {
            return false;
        }
        CapacityProvider other = (CapacityProvider)obj;
        return Objects.equals(this.capacityProviderArn(), other.capacityProviderArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.permissionsConfig(), other.permissionsConfig()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements()) && Objects.equals(this.capacityProviderScalingConfig(), other.capacityProviderScalingConfig()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.lastModified(), other.lastModified());
    }

    public final String toString() {
        return ToString.builder((String)"CapacityProvider").add("CapacityProviderArn", (Object)this.capacityProviderArn()).add("State", (Object)this.stateAsString()).add("VpcConfig", (Object)this.vpcConfig()).add("PermissionsConfig", (Object)this.permissionsConfig()).add("InstanceRequirements", (Object)this.instanceRequirements()).add("CapacityProviderScalingConfig", (Object)this.capacityProviderScalingConfig()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("LastModified", (Object)this.lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "PermissionsConfig": {
                return Optional.ofNullable(clazz.cast(this.permissionsConfig()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
            case "CapacityProviderScalingConfig": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderScalingConfig()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityProviderArn", CAPACITY_PROVIDER_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("PermissionsConfig", PERMISSIONS_CONFIG_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("CapacityProviderScalingConfig", CAPACITY_PROVIDER_SCALING_CONFIG_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityProvider, T> g) {
        return obj -> g.apply((CapacityProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String capacityProviderArn;
        private String state;
        private CapacityProviderVpcConfig vpcConfig;
        private CapacityProviderPermissionsConfig permissionsConfig;
        private InstanceRequirements instanceRequirements;
        private CapacityProviderScalingConfig capacityProviderScalingConfig;
        private String kmsKeyArn;
        private String lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProvider model) {
            this.capacityProviderArn(model.capacityProviderArn);
            this.state(model.state);
            this.vpcConfig(model.vpcConfig);
            this.permissionsConfig(model.permissionsConfig);
            this.instanceRequirements(model.instanceRequirements);
            this.capacityProviderScalingConfig(model.capacityProviderScalingConfig);
            this.kmsKeyArn(model.kmsKeyArn);
            this.lastModified(model.lastModified);
        }

        public final String getCapacityProviderArn() {
            return this.capacityProviderArn;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CapacityProviderState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final CapacityProviderVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(CapacityProviderVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(CapacityProviderVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final CapacityProviderPermissionsConfig.Builder getPermissionsConfig() {
            return this.permissionsConfig != null ? this.permissionsConfig.toBuilder() : null;
        }

        public final void setPermissionsConfig(CapacityProviderPermissionsConfig.BuilderImpl permissionsConfig) {
            this.permissionsConfig = permissionsConfig != null ? permissionsConfig.build() : null;
        }

        @Override
        public final Builder permissionsConfig(CapacityProviderPermissionsConfig permissionsConfig) {
            this.permissionsConfig = permissionsConfig;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final CapacityProviderScalingConfig.Builder getCapacityProviderScalingConfig() {
            return this.capacityProviderScalingConfig != null ? this.capacityProviderScalingConfig.toBuilder() : null;
        }

        public final void setCapacityProviderScalingConfig(CapacityProviderScalingConfig.BuilderImpl capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig != null ? capacityProviderScalingConfig.build() : null;
        }

        @Override
        public final Builder capacityProviderScalingConfig(CapacityProviderScalingConfig capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public CapacityProvider build() {
            return new CapacityProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CapacityProvider> {
        public Builder capacityProviderArn(String var1);

        public Builder state(String var1);

        public Builder state(CapacityProviderState var1);

        public Builder vpcConfig(CapacityProviderVpcConfig var1);

        default public Builder vpcConfig(Consumer<CapacityProviderVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((CapacityProviderVpcConfig)((CapacityProviderVpcConfig.Builder)CapacityProviderVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder permissionsConfig(CapacityProviderPermissionsConfig var1);

        default public Builder permissionsConfig(Consumer<CapacityProviderPermissionsConfig.Builder> permissionsConfig) {
            return this.permissionsConfig((CapacityProviderPermissionsConfig)((CapacityProviderPermissionsConfig.Builder)CapacityProviderPermissionsConfig.builder().applyMutation(permissionsConfig)).build());
        }

        public Builder instanceRequirements(InstanceRequirements var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirements)((InstanceRequirements.Builder)InstanceRequirements.builder().applyMutation(instanceRequirements)).build());
        }

        public Builder capacityProviderScalingConfig(CapacityProviderScalingConfig var1);

        default public Builder capacityProviderScalingConfig(Consumer<CapacityProviderScalingConfig.Builder> capacityProviderScalingConfig) {
            return this.capacityProviderScalingConfig((CapacityProviderScalingConfig)((CapacityProviderScalingConfig.Builder)CapacityProviderScalingConfig.builder().applyMutation(capacityProviderScalingConfig)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder lastModified(String var1);
    }
}

