/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for chained function invocations in durable executions, including retry settings and timeout
 * configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChainedInvokeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<ChainedInvokeOptions.Builder, ChainedInvokeOptions> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(ChainedInvokeOptions::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TenantId").getter(getter(ChainedInvokeOptions::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TenantId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            TENANT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String functionName;

    private final String tenantId;

    private ChainedInvokeOptions(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.tenantId = builder.tenantId;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function to invoke.
     * </p>
     * 
     * @return The name or ARN of the Lambda function to invoke.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The tenant identifier for the chained invocation.
     * </p>
     * 
     * @return The tenant identifier for the chained invocation.
     */
    public final String tenantId() {
        return tenantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChainedInvokeOptions)) {
            return false;
        }
        ChainedInvokeOptions other = (ChainedInvokeOptions) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(tenantId(), other.tenantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChainedInvokeOptions").add("FunctionName", functionName()).add("TenantId", tenantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "TenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("TenantId", TENANT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChainedInvokeOptions, T> g) {
        return obj -> g.apply((ChainedInvokeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChainedInvokeOptions> {
        /**
         * <p>
         * The name or ARN of the Lambda function to invoke.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function to invoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The tenant identifier for the chained invocation.
         * </p>
         * 
         * @param tenantId
         *        The tenant identifier for the chained invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);
    }

    static final class BuilderImpl implements Builder {
        private String functionName;

        private String tenantId;

        private BuilderImpl() {
        }

        private BuilderImpl(ChainedInvokeOptions model) {
            functionName(model.functionName);
            tenantId(model.tenantId);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public ChainedInvokeOptions build() {
            return new ChainedInvokeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
