/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a <a href="https://docs.aws.amazon.com/lambda/latest/dg/durable-functions.html">durable
 * execution</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Execution implements SdkPojo, Serializable, ToCopyableBuilder<Execution.Builder, Execution> {
    private static final SdkField<String> DURABLE_EXECUTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionArn").getter(getter(Execution::durableExecutionArn))
            .setter(setter(Builder::durableExecutionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionArn").build())
            .build();

    private static final SdkField<String> DURABLE_EXECUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionName").getter(getter(Execution::durableExecutionName))
            .setter(setter(Builder::durableExecutionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurableExecutionName").build())
            .build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(Execution::functionArn)).setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Execution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(Execution::startTimestamp)).setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimestamp").getter(getter(Execution::endTimestamp)).setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURABLE_EXECUTION_ARN_FIELD,
            DURABLE_EXECUTION_NAME_FIELD, FUNCTION_ARN_FIELD, STATUS_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String durableExecutionArn;

    private final String durableExecutionName;

    private final String functionArn;

    private final String status;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private Execution(BuilderImpl builder) {
        this.durableExecutionArn = builder.durableExecutionArn;
        this.durableExecutionName = builder.durableExecutionName;
        this.functionArn = builder.functionArn;
        this.status = builder.status;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the durable execution, if this execution is a durable execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the durable execution, if this execution is a durable execution.
     */
    public final String durableExecutionArn() {
        return durableExecutionArn;
    }

    /**
     * <p>
     * The unique name of the durable execution, if one was provided when the execution was started.
     * </p>
     * 
     * @return The unique name of the durable execution, if one was provided when the execution was started.
     */
    public final String durableExecutionName() {
        return durableExecutionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function.
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The current status of the durable execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the durable execution.
     * @see ExecutionStatus
     */
    public final ExecutionStatus status() {
        return ExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the durable execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the durable execution.
     * @see ExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the durable execution started, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time when the durable execution started, in <a
     *         href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The date and time when the durable execution ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
     * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time when the durable execution ended, in <a
     *         href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionArn());
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Execution)) {
            return false;
        }
        Execution other = (Execution) obj;
        return Objects.equals(durableExecutionArn(), other.durableExecutionArn())
                && Objects.equals(durableExecutionName(), other.durableExecutionName())
                && Objects.equals(functionArn(), other.functionArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(endTimestamp(), other.endTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Execution").add("DurableExecutionArn", durableExecutionArn())
                .add("DurableExecutionName", durableExecutionName()).add("FunctionArn", functionArn())
                .add("Status", statusAsString()).add("StartTimestamp", startTimestamp()).add("EndTimestamp", endTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurableExecutionArn":
            return Optional.ofNullable(clazz.cast(durableExecutionArn()));
        case "DurableExecutionName":
            return Optional.ofNullable(clazz.cast(durableExecutionName()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "EndTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurableExecutionArn", DURABLE_EXECUTION_ARN_FIELD);
        map.put("DurableExecutionName", DURABLE_EXECUTION_NAME_FIELD);
        map.put("FunctionArn", FUNCTION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Execution, T> g) {
        return obj -> g.apply((Execution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Execution> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the durable execution, if this execution is a durable execution.
         * </p>
         * 
         * @param durableExecutionArn
         *        The Amazon Resource Name (ARN) of the durable execution, if this execution is a durable execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionArn(String durableExecutionArn);

        /**
         * <p>
         * The unique name of the durable execution, if one was provided when the execution was started.
         * </p>
         * 
         * @param durableExecutionName
         *        The unique name of the durable execution, if one was provided when the execution was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionName(String durableExecutionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The current status of the durable execution.
         * </p>
         * 
         * @param status
         *        The current status of the durable execution.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the durable execution.
         * </p>
         * 
         * @param status
         *        The current status of the durable execution.
         * @see ExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionStatus
         */
        Builder status(ExecutionStatus status);

        /**
         * <p>
         * The date and time when the durable execution started, in <a
         * href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param startTimestamp
         *        The date and time when the durable execution started, in <a
         *        href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The date and time when the durable execution ended, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601
         * format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param endTimestamp
         *        The date and time when the durable execution ended, in <a
         *        href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String durableExecutionArn;

        private String durableExecutionName;

        private String functionArn;

        private String status;

        private Instant startTimestamp;

        private Instant endTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Execution model) {
            durableExecutionArn(model.durableExecutionArn);
            durableExecutionName(model.durableExecutionName);
            functionArn(model.functionArn);
            status(model.status);
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
        }

        public final String getDurableExecutionArn() {
            return durableExecutionArn;
        }

        public final void setDurableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
        }

        @Override
        public final Builder durableExecutionArn(String durableExecutionArn) {
            this.durableExecutionArn = durableExecutionArn;
            return this;
        }

        public final String getDurableExecutionName() {
            return durableExecutionName;
        }

        public final void setDurableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
        }

        @Override
        public final Builder durableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
            return this;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        @Override
        public Execution build() {
            return new Execution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
