/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCapacityProvidersResponse extends LambdaResponse implements
        ToCopyableBuilder<ListCapacityProvidersResponse.Builder, ListCapacityProvidersResponse> {
    private static final SdkField<List<CapacityProvider>> CAPACITY_PROVIDERS_FIELD = SdkField
            .<List<CapacityProvider>> builder(MarshallingType.LIST)
            .memberName("CapacityProviders")
            .getter(getter(ListCapacityProvidersResponse::capacityProviders))
            .setter(setter(Builder::capacityProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListCapacityProvidersResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDERS_FIELD,
            NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CapacityProvider> capacityProviders;

    private final String nextMarker;

    private ListCapacityProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.capacityProviders = builder.capacityProviders;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviders property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityProviders() {
        return capacityProviders != null && !(capacityProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of capacity providers in your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviders} method.
     * </p>
     * 
     * @return A list of capacity providers in your account.
     */
    public final List<CapacityProvider> capacityProviders() {
        return capacityProviders;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviders() ? capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapacityProvidersResponse)) {
            return false;
        }
        ListCapacityProvidersResponse other = (ListCapacityProvidersResponse) obj;
        return hasCapacityProviders() == other.hasCapacityProviders()
                && Objects.equals(capacityProviders(), other.capacityProviders())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCapacityProvidersResponse")
                .add("CapacityProviders", hasCapacityProviders() ? capacityProviders() : null).add("NextMarker", nextMarker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviders":
            return Optional.ofNullable(clazz.cast(capacityProviders()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityProviders", CAPACITY_PROVIDERS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCapacityProvidersResponse, T> g) {
        return obj -> g.apply((ListCapacityProvidersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCapacityProvidersResponse> {
        /**
         * <p>
         * A list of capacity providers in your account.
         * </p>
         * 
         * @param capacityProviders
         *        A list of capacity providers in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(Collection<CapacityProvider> capacityProviders);

        /**
         * <p>
         * A list of capacity providers in your account.
         * </p>
         * 
         * @param capacityProviders
         *        A list of capacity providers in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviders(CapacityProvider... capacityProviders);

        /**
         * <p>
         * A list of capacity providers in your account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lambda.model.CapacityProvider.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lambda.model.CapacityProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lambda.model.CapacityProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityProviders(List<CapacityProvider>)}.
         * 
         * @param capacityProviders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lambda.model.CapacityProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviders(java.util.Collection<CapacityProvider>)
         */
        Builder capacityProviders(Consumer<CapacityProvider.Builder>... capacityProviders);

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextMarker
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private List<CapacityProvider> capacityProviders = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapacityProvidersResponse model) {
            super(model);
            capacityProviders(model.capacityProviders);
            nextMarker(model.nextMarker);
        }

        public final List<CapacityProvider.Builder> getCapacityProviders() {
            List<CapacityProvider.Builder> result = CapacityProvidersListCopier.copyToBuilder(this.capacityProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviders(Collection<CapacityProvider.BuilderImpl> capacityProviders) {
            this.capacityProviders = CapacityProvidersListCopier.copyFromBuilder(capacityProviders);
        }

        @Override
        public final Builder capacityProviders(Collection<CapacityProvider> capacityProviders) {
            this.capacityProviders = CapacityProvidersListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(CapacityProvider... capacityProviders) {
            capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(Consumer<CapacityProvider.Builder>... capacityProviders) {
            capacityProviders(Stream.of(capacityProviders).map(c -> CapacityProvider.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListCapacityProvidersResponse build() {
            return new ListCapacityProvidersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
