/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the capacity provider that manages compute resources for Lambda functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityProviderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityProviderConfig.Builder, CapacityProviderConfig> {
    private static final SdkField<LambdaManagedInstancesCapacityProviderConfig> LAMBDA_MANAGED_INSTANCES_CAPACITY_PROVIDER_CONFIG_FIELD = SdkField
            .<LambdaManagedInstancesCapacityProviderConfig> builder(MarshallingType.SDK_POJO)
            .memberName("LambdaManagedInstancesCapacityProviderConfig")
            .getter(getter(CapacityProviderConfig::lambdaManagedInstancesCapacityProviderConfig))
            .setter(setter(Builder::lambdaManagedInstancesCapacityProviderConfig))
            .constructor(LambdaManagedInstancesCapacityProviderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LambdaManagedInstancesCapacityProviderConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LAMBDA_MANAGED_INSTANCES_CAPACITY_PROVIDER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LambdaManagedInstancesCapacityProviderConfig lambdaManagedInstancesCapacityProviderConfig;

    private CapacityProviderConfig(BuilderImpl builder) {
        this.lambdaManagedInstancesCapacityProviderConfig = builder.lambdaManagedInstancesCapacityProviderConfig;
    }

    /**
     * <p>
     * Configuration for Lambda-managed instances used by the capacity provider.
     * </p>
     * 
     * @return Configuration for Lambda-managed instances used by the capacity provider.
     */
    public final LambdaManagedInstancesCapacityProviderConfig lambdaManagedInstancesCapacityProviderConfig() {
        return lambdaManagedInstancesCapacityProviderConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaManagedInstancesCapacityProviderConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityProviderConfig)) {
            return false;
        }
        CapacityProviderConfig other = (CapacityProviderConfig) obj;
        return Objects.equals(lambdaManagedInstancesCapacityProviderConfig(),
                other.lambdaManagedInstancesCapacityProviderConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityProviderConfig")
                .add("LambdaManagedInstancesCapacityProviderConfig", lambdaManagedInstancesCapacityProviderConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaManagedInstancesCapacityProviderConfig":
            return Optional.ofNullable(clazz.cast(lambdaManagedInstancesCapacityProviderConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LambdaManagedInstancesCapacityProviderConfig", LAMBDA_MANAGED_INSTANCES_CAPACITY_PROVIDER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityProviderConfig, T> g) {
        return obj -> g.apply((CapacityProviderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityProviderConfig> {
        /**
         * <p>
         * Configuration for Lambda-managed instances used by the capacity provider.
         * </p>
         * 
         * @param lambdaManagedInstancesCapacityProviderConfig
         *        Configuration for Lambda-managed instances used by the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaManagedInstancesCapacityProviderConfig(
                LambdaManagedInstancesCapacityProviderConfig lambdaManagedInstancesCapacityProviderConfig);

        /**
         * <p>
         * Configuration for Lambda-managed instances used by the capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LambdaManagedInstancesCapacityProviderConfig.Builder} avoiding the need to create one manually via
         * {@link LambdaManagedInstancesCapacityProviderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaManagedInstancesCapacityProviderConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #lambdaManagedInstancesCapacityProviderConfig(LambdaManagedInstancesCapacityProviderConfig)}.
         * 
         * @param lambdaManagedInstancesCapacityProviderConfig
         *        a consumer that will call methods on {@link LambdaManagedInstancesCapacityProviderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaManagedInstancesCapacityProviderConfig(LambdaManagedInstancesCapacityProviderConfig)
         */
        default Builder lambdaManagedInstancesCapacityProviderConfig(
                Consumer<LambdaManagedInstancesCapacityProviderConfig.Builder> lambdaManagedInstancesCapacityProviderConfig) {
            return lambdaManagedInstancesCapacityProviderConfig(LambdaManagedInstancesCapacityProviderConfig.builder()
                    .applyMutation(lambdaManagedInstancesCapacityProviderConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaManagedInstancesCapacityProviderConfig lambdaManagedInstancesCapacityProviderConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityProviderConfig model) {
            lambdaManagedInstancesCapacityProviderConfig(model.lambdaManagedInstancesCapacityProviderConfig);
        }

        public final LambdaManagedInstancesCapacityProviderConfig.Builder getLambdaManagedInstancesCapacityProviderConfig() {
            return lambdaManagedInstancesCapacityProviderConfig != null ? lambdaManagedInstancesCapacityProviderConfig
                    .toBuilder() : null;
        }

        public final void setLambdaManagedInstancesCapacityProviderConfig(
                LambdaManagedInstancesCapacityProviderConfig.BuilderImpl lambdaManagedInstancesCapacityProviderConfig) {
            this.lambdaManagedInstancesCapacityProviderConfig = lambdaManagedInstancesCapacityProviderConfig != null ? lambdaManagedInstancesCapacityProviderConfig
                    .build() : null;
        }

        @Override
        public final Builder lambdaManagedInstancesCapacityProviderConfig(
                LambdaManagedInstancesCapacityProviderConfig lambdaManagedInstancesCapacityProviderConfig) {
            this.lambdaManagedInstancesCapacityProviderConfig = lambdaManagedInstancesCapacityProviderConfig;
            return this;
        }

        @Override
        public CapacityProviderConfig build() {
            return new CapacityProviderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
