/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for a durable execution context.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContextOptions implements SdkPojo, Serializable, ToCopyableBuilder<ContextOptions.Builder, ContextOptions> {
    private static final SdkField<Boolean> REPLAY_CHILDREN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReplayChildren").getter(getter(ContextOptions::replayChildren)).setter(setter(Builder::replayChildren))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayChildren").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_CHILDREN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean replayChildren;

    private ContextOptions(BuilderImpl builder) {
        this.replayChildren = builder.replayChildren;
    }

    /**
     * <p>
     * Whether the state data of children of the completed context should be included in the invoke payload and
     * <code>GetDurableExecutionState</code> response.
     * </p>
     * 
     * @return Whether the state data of children of the completed context should be included in the invoke payload and
     *         <code>GetDurableExecutionState</code> response.
     */
    public final Boolean replayChildren() {
        return replayChildren;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replayChildren());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextOptions)) {
            return false;
        }
        ContextOptions other = (ContextOptions) obj;
        return Objects.equals(replayChildren(), other.replayChildren());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContextOptions").add("ReplayChildren", replayChildren()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplayChildren":
            return Optional.ofNullable(clazz.cast(replayChildren()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReplayChildren", REPLAY_CHILDREN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContextOptions, T> g) {
        return obj -> g.apply((ContextOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContextOptions> {
        /**
         * <p>
         * Whether the state data of children of the completed context should be included in the invoke payload and
         * <code>GetDurableExecutionState</code> response.
         * </p>
         * 
         * @param replayChildren
         *        Whether the state data of children of the completed context should be included in the invoke payload
         *        and <code>GetDurableExecutionState</code> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replayChildren(Boolean replayChildren);
    }

    static final class BuilderImpl implements Builder {
        private Boolean replayChildren;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextOptions model) {
            replayChildren(model.replayChildren);
        }

        public final Boolean getReplayChildren() {
            return replayChildren;
        }

        public final void setReplayChildren(Boolean replayChildren) {
            this.replayChildren = replayChildren;
        }

        @Override
        public final Builder replayChildren(Boolean replayChildren) {
            this.replayChildren = replayChildren;
            return this;
        }

        @Override
        public ContextOptions build() {
            return new ContextOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
