/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.CapacityProviderPermissionsConfig;
import software.amazon.awssdk.services.lambda.model.CapacityProviderScalingConfig;
import software.amazon.awssdk.services.lambda.model.CapacityProviderVpcConfig;
import software.amazon.awssdk.services.lambda.model.InstanceRequirements;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCapacityProviderRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, CreateCapacityProviderRequest> {
    private static final SdkField<String> CAPACITY_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityProviderName").getter(CreateCapacityProviderRequest.getter(CreateCapacityProviderRequest::capacityProviderName)).setter(CreateCapacityProviderRequest.setter(Builder::capacityProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderName").build()}).build();
    private static final SdkField<CapacityProviderVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateCapacityProviderRequest.getter(CreateCapacityProviderRequest::vpcConfig)).setter(CreateCapacityProviderRequest.setter(Builder::vpcConfig)).constructor(CapacityProviderVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<CapacityProviderPermissionsConfig> PERMISSIONS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PermissionsConfig").getter(CreateCapacityProviderRequest.getter(CreateCapacityProviderRequest::permissionsConfig)).setter(CreateCapacityProviderRequest.setter(Builder::permissionsConfig)).constructor(CapacityProviderPermissionsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsConfig").build()}).build();
    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(CreateCapacityProviderRequest.getter(CreateCapacityProviderRequest::instanceRequirements)).setter(CreateCapacityProviderRequest.setter(Builder::instanceRequirements)).constructor(InstanceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").build()}).build();
    private static final SdkField<CapacityProviderScalingConfig> CAPACITY_PROVIDER_SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityProviderScalingConfig").getter(CreateCapacityProviderRequest.getter(CreateCapacityProviderRequest::capacityProviderScalingConfig)).setter(CreateCapacityProviderRequest.setter(Builder::capacityProviderScalingConfig)).constructor(CapacityProviderScalingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderScalingConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyArn").getter(CreateCapacityProviderRequest.getter(CreateCapacityProviderRequest::kmsKeyArn)).setter(CreateCapacityProviderRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateCapacityProviderRequest.getter(CreateCapacityProviderRequest::tags)).setter(CreateCapacityProviderRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_NAME_FIELD, VPC_CONFIG_FIELD, PERMISSIONS_CONFIG_FIELD, INSTANCE_REQUIREMENTS_FIELD, CAPACITY_PROVIDER_SCALING_CONFIG_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCapacityProviderRequest.memberNameToFieldInitializer();
    private final String capacityProviderName;
    private final CapacityProviderVpcConfig vpcConfig;
    private final CapacityProviderPermissionsConfig permissionsConfig;
    private final InstanceRequirements instanceRequirements;
    private final CapacityProviderScalingConfig capacityProviderScalingConfig;
    private final String kmsKeyArn;
    private final Map<String, String> tags;

    private CreateCapacityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.capacityProviderName = builder.capacityProviderName;
        this.vpcConfig = builder.vpcConfig;
        this.permissionsConfig = builder.permissionsConfig;
        this.instanceRequirements = builder.instanceRequirements;
        this.capacityProviderScalingConfig = builder.capacityProviderScalingConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    public final String capacityProviderName() {
        return this.capacityProviderName;
    }

    public final CapacityProviderVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final CapacityProviderPermissionsConfig permissionsConfig() {
        return this.permissionsConfig;
    }

    public final InstanceRequirements instanceRequirements() {
        return this.instanceRequirements;
    }

    public final CapacityProviderScalingConfig capacityProviderScalingConfig() {
        return this.capacityProviderScalingConfig;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderScalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityProviderRequest)) {
            return false;
        }
        CreateCapacityProviderRequest other = (CreateCapacityProviderRequest)((Object)obj);
        return Objects.equals(this.capacityProviderName(), other.capacityProviderName()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.permissionsConfig(), other.permissionsConfig()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements()) && Objects.equals(this.capacityProviderScalingConfig(), other.capacityProviderScalingConfig()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCapacityProviderRequest").add("CapacityProviderName", (Object)this.capacityProviderName()).add("VpcConfig", (Object)this.vpcConfig()).add("PermissionsConfig", (Object)this.permissionsConfig()).add("InstanceRequirements", (Object)this.instanceRequirements()).add("CapacityProviderScalingConfig", (Object)this.capacityProviderScalingConfig()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityProviderName": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderName()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "PermissionsConfig": {
                return Optional.ofNullable(clazz.cast(this.permissionsConfig()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
            case "CapacityProviderScalingConfig": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderScalingConfig()));
            }
            case "KmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityProviderName", CAPACITY_PROVIDER_NAME_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("PermissionsConfig", PERMISSIONS_CONFIG_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("CapacityProviderScalingConfig", CAPACITY_PROVIDER_SCALING_CONFIG_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCapacityProviderRequest, T> g) {
        return obj -> g.apply((CreateCapacityProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String capacityProviderName;
        private CapacityProviderVpcConfig vpcConfig;
        private CapacityProviderPermissionsConfig permissionsConfig;
        private InstanceRequirements instanceRequirements;
        private CapacityProviderScalingConfig capacityProviderScalingConfig;
        private String kmsKeyArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCapacityProviderRequest model) {
            super(model);
            this.capacityProviderName(model.capacityProviderName);
            this.vpcConfig(model.vpcConfig);
            this.permissionsConfig(model.permissionsConfig);
            this.instanceRequirements(model.instanceRequirements);
            this.capacityProviderScalingConfig(model.capacityProviderScalingConfig);
            this.kmsKeyArn(model.kmsKeyArn);
            this.tags(model.tags);
        }

        public final String getCapacityProviderName() {
            return this.capacityProviderName;
        }

        public final void setCapacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
        }

        @Override
        public final Builder capacityProviderName(String capacityProviderName) {
            this.capacityProviderName = capacityProviderName;
            return this;
        }

        public final CapacityProviderVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(CapacityProviderVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(CapacityProviderVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final CapacityProviderPermissionsConfig.Builder getPermissionsConfig() {
            return this.permissionsConfig != null ? this.permissionsConfig.toBuilder() : null;
        }

        public final void setPermissionsConfig(CapacityProviderPermissionsConfig.BuilderImpl permissionsConfig) {
            this.permissionsConfig = permissionsConfig != null ? permissionsConfig.build() : null;
        }

        @Override
        public final Builder permissionsConfig(CapacityProviderPermissionsConfig permissionsConfig) {
            this.permissionsConfig = permissionsConfig;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final CapacityProviderScalingConfig.Builder getCapacityProviderScalingConfig() {
            return this.capacityProviderScalingConfig != null ? this.capacityProviderScalingConfig.toBuilder() : null;
        }

        public final void setCapacityProviderScalingConfig(CapacityProviderScalingConfig.BuilderImpl capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig != null ? capacityProviderScalingConfig.build() : null;
        }

        @Override
        public final Builder capacityProviderScalingConfig(CapacityProviderScalingConfig capacityProviderScalingConfig) {
            this.capacityProviderScalingConfig = capacityProviderScalingConfig;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCapacityProviderRequest build() {
            return new CreateCapacityProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCapacityProviderRequest> {
        public Builder capacityProviderName(String var1);

        public Builder vpcConfig(CapacityProviderVpcConfig var1);

        default public Builder vpcConfig(Consumer<CapacityProviderVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((CapacityProviderVpcConfig)((CapacityProviderVpcConfig.Builder)CapacityProviderVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder permissionsConfig(CapacityProviderPermissionsConfig var1);

        default public Builder permissionsConfig(Consumer<CapacityProviderPermissionsConfig.Builder> permissionsConfig) {
            return this.permissionsConfig((CapacityProviderPermissionsConfig)((CapacityProviderPermissionsConfig.Builder)CapacityProviderPermissionsConfig.builder().applyMutation(permissionsConfig)).build());
        }

        public Builder instanceRequirements(InstanceRequirements var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirements)((InstanceRequirements.Builder)InstanceRequirements.builder().applyMutation(instanceRequirements)).build());
        }

        public Builder capacityProviderScalingConfig(CapacityProviderScalingConfig var1);

        default public Builder capacityProviderScalingConfig(Consumer<CapacityProviderScalingConfig.Builder> capacityProviderScalingConfig) {
            return this.capacityProviderScalingConfig((CapacityProviderScalingConfig)((CapacityProviderScalingConfig.Builder)CapacityProviderScalingConfig.builder().applyMutation(capacityProviderScalingConfig)).build());
        }

        public Builder kmsKeyArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

