/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum EventType {
    EXECUTION_STARTED("ExecutionStarted"),

    EXECUTION_SUCCEEDED("ExecutionSucceeded"),

    EXECUTION_FAILED("ExecutionFailed"),

    EXECUTION_TIMED_OUT("ExecutionTimedOut"),

    EXECUTION_STOPPED("ExecutionStopped"),

    CONTEXT_STARTED("ContextStarted"),

    CONTEXT_SUCCEEDED("ContextSucceeded"),

    CONTEXT_FAILED("ContextFailed"),

    WAIT_STARTED("WaitStarted"),

    WAIT_SUCCEEDED("WaitSucceeded"),

    WAIT_CANCELLED("WaitCancelled"),

    STEP_STARTED("StepStarted"),

    STEP_SUCCEEDED("StepSucceeded"),

    STEP_FAILED("StepFailed"),

    CHAINED_INVOKE_STARTED("ChainedInvokeStarted"),

    CHAINED_INVOKE_SUCCEEDED("ChainedInvokeSucceeded"),

    CHAINED_INVOKE_FAILED("ChainedInvokeFailed"),

    CHAINED_INVOKE_TIMED_OUT("ChainedInvokeTimedOut"),

    CHAINED_INVOKE_STOPPED("ChainedInvokeStopped"),

    CALLBACK_STARTED("CallbackStarted"),

    CALLBACK_SUCCEEDED("CallbackSucceeded"),

    CALLBACK_FAILED("CallbackFailed"),

    CALLBACK_TIMED_OUT("CallbackTimedOut"),

    INVOCATION_COMPLETED("InvocationCompleted"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventType> VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return EventType corresponding to the value
     */
    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link EventType}s
     */
    public static Set<EventType> knownValues() {
        Set<EventType> knownValues = EnumSet.allOf(EventType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
