/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDurableExecutionsByFunctionRequest extends LambdaRequest implements
        ToCopyableBuilder<ListDurableExecutionsByFunctionRequest.Builder, ListDurableExecutionsByFunctionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(ListDurableExecutionsByFunctionRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(ListDurableExecutionsByFunctionRequest::qualifier))
            .setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final SdkField<String> DURABLE_EXECUTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DurableExecutionName").getter(getter(ListDurableExecutionsByFunctionRequest::durableExecutionName))
            .setter(setter(Builder::durableExecutionName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DurableExecutionName").build())
            .build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Statuses")
            .getter(getter(ListDurableExecutionsByFunctionRequest::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> STARTED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAfter").getter(getter(ListDurableExecutionsByFunctionRequest::startedAfter))
            .setter(setter(Builder::startedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartedAfter").build()).build();

    private static final SdkField<Instant> STARTED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedBefore").getter(getter(ListDurableExecutionsByFunctionRequest::startedBefore))
            .setter(setter(Builder::startedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartedBefore").build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReverseOrder").getter(getter(ListDurableExecutionsByFunctionRequest::reverseOrder))
            .setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ReverseOrder").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListDurableExecutionsByFunctionRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems").getter(getter(ListDurableExecutionsByFunctionRequest::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            QUALIFIER_FIELD, DURABLE_EXECUTION_NAME_FIELD, STATUSES_FIELD, STARTED_AFTER_FIELD, STARTED_BEFORE_FIELD,
            REVERSE_ORDER_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String functionName;

    private final String qualifier;

    private final String durableExecutionName;

    private final List<String> statuses;

    private final Instant startedAfter;

    private final Instant startedBefore;

    private final Boolean reverseOrder;

    private final String marker;

    private final Integer maxItems;

    private ListDurableExecutionsByFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.durableExecutionName = builder.durableExecutionName;
        this.statuses = builder.statuses;
        this.startedAfter = builder.startedAfter;
        this.startedBefore = builder.startedBefore;
        this.reverseOrder = builder.reverseOrder;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The name or ARN of the Lambda function. You can specify a function name, a partial ARN, or a full ARN.
     * </p>
     * 
     * @return The name or ARN of the Lambda function. You can specify a function name, a partial ARN, or a full ARN.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The function version or alias. If not specified, lists executions for the $LATEST version.
     * </p>
     * 
     * @return The function version or alias. If not specified, lists executions for the $LATEST version.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * Filter executions by name. Only executions with names that contain this string are returned.
     * </p>
     * 
     * @return Filter executions by name. Only executions with names that contain this string are returned.
     */
    public final String durableExecutionName() {
        return durableExecutionName;
    }

    /**
     * <p>
     * Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
     */
    public final List<ExecutionStatus> statuses() {
        return ExecutionStatusListCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    /**
     * <p>
     * Filter executions that started after this timestamp (ISO 8601 format).
     * </p>
     * 
     * @return Filter executions that started after this timestamp (ISO 8601 format).
     */
    public final Instant startedAfter() {
        return startedAfter;
    }

    /**
     * <p>
     * Filter executions that started before this timestamp (ISO 8601 format).
     * </p>
     * 
     * @return Filter executions that started before this timestamp (ISO 8601 format).
     */
    public final Instant startedBefore() {
        return startedBefore;
    }

    /**
     * <p>
     * Set to true to return results in reverse chronological order (newest first). Default is false.
     * </p>
     * 
     * @return Set to true to return results in reverse chronological order (newest first). Default is false.
     */
    public final Boolean reverseOrder() {
        return reverseOrder;
    }

    /**
     * <p>
     * Pagination token from a previous request to continue retrieving results.
     * </p>
     * 
     * @return Pagination token from a previous request to continue retrieving results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Maximum number of executions to return (1-1000). Default is 100.
     * </p>
     * 
     * @return Maximum number of executions to return (1-1000). Default is 100.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(durableExecutionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(startedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDurableExecutionsByFunctionRequest)) {
            return false;
        }
        ListDurableExecutionsByFunctionRequest other = (ListDurableExecutionsByFunctionRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(durableExecutionName(), other.durableExecutionName()) && hasStatuses() == other.hasStatuses()
                && Objects.equals(statusesAsStrings(), other.statusesAsStrings())
                && Objects.equals(startedAfter(), other.startedAfter()) && Objects.equals(startedBefore(), other.startedBefore())
                && Objects.equals(reverseOrder(), other.reverseOrder()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDurableExecutionsByFunctionRequest").add("FunctionName", functionName())
                .add("Qualifier", qualifier()).add("DurableExecutionName", durableExecutionName())
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).add("StartedAfter", startedAfter())
                .add("StartedBefore", startedBefore()).add("ReverseOrder", reverseOrder()).add("Marker", marker())
                .add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "DurableExecutionName":
            return Optional.ofNullable(clazz.cast(durableExecutionName()));
        case "Statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        case "StartedAfter":
            return Optional.ofNullable(clazz.cast(startedAfter()));
        case "StartedBefore":
            return Optional.ofNullable(clazz.cast(startedBefore()));
        case "ReverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("Qualifier", QUALIFIER_FIELD);
        map.put("DurableExecutionName", DURABLE_EXECUTION_NAME_FIELD);
        map.put("Statuses", STATUSES_FIELD);
        map.put("StartedAfter", STARTED_AFTER_FIELD);
        map.put("StartedBefore", STARTED_BEFORE_FIELD);
        map.put("ReverseOrder", REVERSE_ORDER_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDurableExecutionsByFunctionRequest, T> g) {
        return obj -> g.apply((ListDurableExecutionsByFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LambdaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDurableExecutionsByFunctionRequest> {
        /**
         * <p>
         * The name or ARN of the Lambda function. You can specify a function name, a partial ARN, or a full ARN.
         * </p>
         * 
         * @param functionName
         *        The name or ARN of the Lambda function. You can specify a function name, a partial ARN, or a full ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The function version or alias. If not specified, lists executions for the $LATEST version.
         * </p>
         * 
         * @param qualifier
         *        The function version or alias. If not specified, lists executions for the $LATEST version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * Filter executions by name. Only executions with names that contain this string are returned.
         * </p>
         * 
         * @param durableExecutionName
         *        Filter executions by name. Only executions with names that contain this string are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durableExecutionName(String durableExecutionName);

        /**
         * <p>
         * Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
         * </p>
         * 
         * @param statuses
         *        Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
         * </p>
         * 
         * @param statuses
         *        Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
         * </p>
         * 
         * @param statuses
         *        Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<ExecutionStatus> statuses);

        /**
         * <p>
         * Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
         * </p>
         * 
         * @param statuses
         *        Filter executions by status. Valid values: RUNNING, SUCCEEDED, FAILED, TIMED_OUT, STOPPED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(ExecutionStatus... statuses);

        /**
         * <p>
         * Filter executions that started after this timestamp (ISO 8601 format).
         * </p>
         * 
         * @param startedAfter
         *        Filter executions that started after this timestamp (ISO 8601 format).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAfter(Instant startedAfter);

        /**
         * <p>
         * Filter executions that started before this timestamp (ISO 8601 format).
         * </p>
         * 
         * @param startedBefore
         *        Filter executions that started before this timestamp (ISO 8601 format).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedBefore(Instant startedBefore);

        /**
         * <p>
         * Set to true to return results in reverse chronological order (newest first). Default is false.
         * </p>
         * 
         * @param reverseOrder
         *        Set to true to return results in reverse chronological order (newest first). Default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        /**
         * <p>
         * Pagination token from a previous request to continue retrieving results.
         * </p>
         * 
         * @param marker
         *        Pagination token from a previous request to continue retrieving results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Maximum number of executions to return (1-1000). Default is 100.
         * </p>
         * 
         * @param maxItems
         *        Maximum number of executions to return (1-1000). Default is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String qualifier;

        private String durableExecutionName;

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private Instant startedAfter;

        private Instant startedBefore;

        private Boolean reverseOrder;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDurableExecutionsByFunctionRequest model) {
            super(model);
            functionName(model.functionName);
            qualifier(model.qualifier);
            durableExecutionName(model.durableExecutionName);
            statusesWithStrings(model.statuses);
            startedAfter(model.startedAfter);
            startedBefore(model.startedBefore);
            reverseOrder(model.reverseOrder);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getDurableExecutionName() {
            return durableExecutionName;
        }

        public final void setDurableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
        }

        @Override
        public final Builder durableExecutionName(String durableExecutionName) {
            this.durableExecutionName = durableExecutionName;
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = ExecutionStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = ExecutionStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<ExecutionStatus> statuses) {
            this.statuses = ExecutionStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(ExecutionStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        public final Instant getStartedAfter() {
            return startedAfter;
        }

        public final void setStartedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
        }

        @Override
        public final Builder startedAfter(Instant startedAfter) {
            this.startedAfter = startedAfter;
            return this;
        }

        public final Instant getStartedBefore() {
            return startedBefore;
        }

        public final void setStartedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
        }

        @Override
        public final Builder startedBefore(Instant startedBefore) {
            this.startedBefore = startedBefore;
            return this;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDurableExecutionsByFunctionRequest build() {
            return new ListDurableExecutionsByFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
