/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.Event;
import software.amazon.awssdk.services.lambda.model.GetDurableExecutionHistoryRequest;
import software.amazon.awssdk.services.lambda.model.GetDurableExecutionHistoryResponse;

public class GetDurableExecutionHistoryIterable
implements SdkIterable<GetDurableExecutionHistoryResponse> {
    private final LambdaClient client;
    private final GetDurableExecutionHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDurableExecutionHistoryIterable(LambdaClient client, GetDurableExecutionHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetDurableExecutionHistoryResponseFetcher();
    }

    public Iterator<GetDurableExecutionHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Event> events() {
        Function<GetDurableExecutionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetDurableExecutionHistoryResponseFetcher
    implements SyncPageFetcher<GetDurableExecutionHistoryResponse> {
        private GetDurableExecutionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetDurableExecutionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public GetDurableExecutionHistoryResponse nextPage(GetDurableExecutionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetDurableExecutionHistoryIterable.this.client.getDurableExecutionHistory(GetDurableExecutionHistoryIterable.this.firstRequest);
            }
            return GetDurableExecutionHistoryIterable.this.client.getDurableExecutionHistory((GetDurableExecutionHistoryRequest)((Object)GetDurableExecutionHistoryIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

