/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.CapacityProvider;
import software.amazon.awssdk.services.lambda.model.ListCapacityProvidersRequest;
import software.amazon.awssdk.services.lambda.model.ListCapacityProvidersResponse;

public class ListCapacityProvidersPublisher
implements SdkPublisher<ListCapacityProvidersResponse> {
    private final LambdaAsyncClient client;
    private final ListCapacityProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCapacityProvidersPublisher(LambdaAsyncClient client, ListCapacityProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCapacityProvidersPublisher(LambdaAsyncClient client, ListCapacityProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCapacityProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCapacityProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityProvider> capacityProviders() {
        return this.flatMapIterable(response -> response.capacityProviders());
    }

    private class ListCapacityProvidersResponseFetcher
    implements AsyncPageFetcher<ListCapacityProvidersResponse> {
        private ListCapacityProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListCapacityProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListCapacityProvidersResponse> nextPage(ListCapacityProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListCapacityProvidersPublisher.this.client.listCapacityProviders(ListCapacityProvidersPublisher.this.firstRequest);
            }
            return ListCapacityProvidersPublisher.this.client.listCapacityProviders((ListCapacityProvidersRequest)((Object)ListCapacityProvidersPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

