/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.LayersListItem;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;

public class ListLayersPublisher
implements SdkPublisher<ListLayersResponse> {
    private final LambdaAsyncClient client;
    private final ListLayersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLayersPublisher(LambdaAsyncClient client, ListLayersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLayersPublisher(LambdaAsyncClient client, ListLayersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLayersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLayersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LayersListItem> layers() {
        return this.flatMapIterable(response -> response.layers());
    }

    private class ListLayersResponseFetcher
    implements AsyncPageFetcher<ListLayersResponse> {
        private ListLayersResponseFetcher() {
        }

        public boolean hasNextPage(ListLayersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListLayersResponse> nextPage(ListLayersResponse previousPage) {
            if (previousPage == null) {
                return ListLayersPublisher.this.client.listLayers(ListLayersPublisher.this.firstRequest);
            }
            return ListLayersPublisher.this.client.listLayers((ListLayersRequest)((Object)ListLayersPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

