/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a step that failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepFailedDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<StepFailedDetails.Builder, StepFailedDetails> {
    private static final SdkField<EventError> ERROR_FIELD = SdkField.<EventError> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(StepFailedDetails::error)).setter(setter(Builder::error))
            .constructor(EventError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<RetryDetails> RETRY_DETAILS_FIELD = SdkField.<RetryDetails> builder(MarshallingType.SDK_POJO)
            .memberName("RetryDetails").getter(getter(StepFailedDetails::retryDetails)).setter(setter(Builder::retryDetails))
            .constructor(RetryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD,
            RETRY_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EventError error;

    private final RetryDetails retryDetails;

    private StepFailedDetails(BuilderImpl builder) {
        this.error = builder.error;
        this.retryDetails = builder.retryDetails;
    }

    /**
     * <p>
     * Details about the step failure.
     * </p>
     * 
     * @return Details about the step failure.
     */
    public final EventError error() {
        return error;
    }

    /**
     * <p>
     * Information about retry attempts for this step operation.
     * </p>
     * 
     * @return Information about retry attempts for this step operation.
     */
    public final RetryDetails retryDetails() {
        return retryDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(retryDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepFailedDetails)) {
            return false;
        }
        StepFailedDetails other = (StepFailedDetails) obj;
        return Objects.equals(error(), other.error()) && Objects.equals(retryDetails(), other.retryDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepFailedDetails").add("Error", error()).add("RetryDetails", retryDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "RetryDetails":
            return Optional.ofNullable(clazz.cast(retryDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Error", ERROR_FIELD);
        map.put("RetryDetails", RETRY_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepFailedDetails, T> g) {
        return obj -> g.apply((StepFailedDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepFailedDetails> {
        /**
         * <p>
         * Details about the step failure.
         * </p>
         * 
         * @param error
         *        Details about the step failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(EventError error);

        /**
         * <p>
         * Details about the step failure.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventError.Builder} avoiding the need to
         * create one manually via {@link EventError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventError.Builder#build()} is called immediately and its result
         * is passed to {@link #error(EventError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link EventError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(EventError)
         */
        default Builder error(Consumer<EventError.Builder> error) {
            return error(EventError.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * Information about retry attempts for this step operation.
         * </p>
         * 
         * @param retryDetails
         *        Information about retry attempts for this step operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryDetails(RetryDetails retryDetails);

        /**
         * <p>
         * Information about retry attempts for this step operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetryDetails.Builder} avoiding the need
         * to create one manually via {@link RetryDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetryDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #retryDetails(RetryDetails)}.
         * 
         * @param retryDetails
         *        a consumer that will call methods on {@link RetryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryDetails(RetryDetails)
         */
        default Builder retryDetails(Consumer<RetryDetails.Builder> retryDetails) {
            return retryDetails(RetryDetails.builder().applyMutation(retryDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EventError error;

        private RetryDetails retryDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StepFailedDetails model) {
            error(model.error);
            retryDetails(model.retryDetails);
        }

        public final EventError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(EventError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(EventError error) {
            this.error = error;
            return this;
        }

        public final RetryDetails.Builder getRetryDetails() {
            return retryDetails != null ? retryDetails.toBuilder() : null;
        }

        public final void setRetryDetails(RetryDetails.BuilderImpl retryDetails) {
            this.retryDetails = retryDetails != null ? retryDetails.build() : null;
        }

        @Override
        public final Builder retryDetails(RetryDetails retryDetails) {
            this.retryDetails = retryDetails;
            return this;
        }

        @Override
        public StepFailedDetails build() {
            return new StepFailedDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
