/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.AdditionalVersionWeightsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AliasRoutingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AliasRoutingConfiguration> {
    private static final SdkField<Map<String, Double>> ADDITIONAL_VERSION_WEIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AliasRoutingConfiguration.getter(AliasRoutingConfiguration::additionalVersionWeights)).setter(AliasRoutingConfiguration.setter(Builder::additionalVersionWeights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalVersionWeights").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_VERSION_WEIGHTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, Double> additionalVersionWeights;

    private AliasRoutingConfiguration(BuilderImpl builder) {
        this.additionalVersionWeights = builder.additionalVersionWeights;
    }

    public Map<String, Double> additionalVersionWeights() {
        return this.additionalVersionWeights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalVersionWeights());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AliasRoutingConfiguration)) {
            return false;
        }
        AliasRoutingConfiguration other = (AliasRoutingConfiguration)obj;
        return Objects.equals(this.additionalVersionWeights(), other.additionalVersionWeights());
    }

    public String toString() {
        return ToString.builder((String)"AliasRoutingConfiguration").add("AdditionalVersionWeights", this.additionalVersionWeights()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalVersionWeights": {
                return Optional.ofNullable(clazz.cast(this.additionalVersionWeights()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AliasRoutingConfiguration, T> g) {
        return obj -> g.apply((AliasRoutingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Double> additionalVersionWeights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AliasRoutingConfiguration model) {
            this.additionalVersionWeights(model.additionalVersionWeights);
        }

        public final Map<String, Double> getAdditionalVersionWeights() {
            return this.additionalVersionWeights;
        }

        @Override
        public final Builder additionalVersionWeights(Map<String, Double> additionalVersionWeights) {
            this.additionalVersionWeights = AdditionalVersionWeightsCopier.copy(additionalVersionWeights);
            return this;
        }

        public final void setAdditionalVersionWeights(Map<String, Double> additionalVersionWeights) {
            this.additionalVersionWeights = AdditionalVersionWeightsCopier.copy(additionalVersionWeights);
        }

        public AliasRoutingConfiguration build() {
            return new AliasRoutingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AliasRoutingConfiguration> {
        public Builder additionalVersionWeights(Map<String, Double> var1);
    }
}

