/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.FunctionListCopier;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFunctionsResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListFunctionsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListFunctionsResponse.getter(ListFunctionsResponse::nextMarker)).setter(ListFunctionsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<List<FunctionConfiguration>> FUNCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListFunctionsResponse.getter(ListFunctionsResponse::functions)).setter(ListFunctionsResponse.setter(Builder::functions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Functions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, FUNCTIONS_FIELD));
    private final String nextMarker;
    private final List<FunctionConfiguration> functions;

    private ListFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.functions = builder.functions;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<FunctionConfiguration> functions() {
        return this.functions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.functions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsResponse)) {
            return false;
        }
        ListFunctionsResponse other = (ListFunctionsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.functions(), other.functions());
    }

    public String toString() {
        return ToString.builder((String)"ListFunctionsResponse").add("NextMarker", (Object)this.nextMarker()).add("Functions", this.functions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "Functions": {
                return Optional.ofNullable(clazz.cast(this.functions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionsResponse, T> g) {
        return obj -> g.apply((ListFunctionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<FunctionConfiguration> functions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.functions(model.functions);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<FunctionConfiguration.Builder> getFunctions() {
            return this.functions != null ? (Collection)this.functions.stream().map(FunctionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder functions(Collection<FunctionConfiguration> functions) {
            this.functions = FunctionListCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(FunctionConfiguration ... functions) {
            this.functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Consumer<FunctionConfiguration.Builder> ... functions) {
            this.functions(Stream.of(functions).map(c -> (FunctionConfiguration)((FunctionConfiguration.Builder)FunctionConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFunctions(Collection<FunctionConfiguration.BuilderImpl> functions) {
            this.functions = FunctionListCopier.copyFromBuilder(functions);
        }

        @Override
        public ListFunctionsResponse build() {
            return new ListFunctionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFunctionsResponse> {
        public Builder nextMarker(String var1);

        public Builder functions(Collection<FunctionConfiguration> var1);

        public Builder functions(FunctionConfiguration ... var1);

        public Builder functions(Consumer<FunctionConfiguration.Builder> ... var1);
    }
}

