/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLayerVersionsRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, ListLayerVersionsRequest> {
    private static final SdkField<String> COMPATIBLE_RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListLayerVersionsRequest.getter(ListLayerVersionsRequest::compatibleRuntimeAsString)).setter(ListLayerVersionsRequest.setter(Builder::compatibleRuntime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CompatibleRuntime").build()}).build();
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListLayerVersionsRequest.getter(ListLayerVersionsRequest::layerName)).setter(ListLayerVersionsRequest.setter(Builder::layerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListLayerVersionsRequest.getter(ListLayerVersionsRequest::marker)).setter(ListLayerVersionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListLayerVersionsRequest.getter(ListLayerVersionsRequest::maxItems)).setter(ListLayerVersionsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_RUNTIME_FIELD, LAYER_NAME_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private final String compatibleRuntime;
    private final String layerName;
    private final String marker;
    private final Integer maxItems;

    private ListLayerVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.compatibleRuntime = builder.compatibleRuntime;
        this.layerName = builder.layerName;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public Runtime compatibleRuntime() {
        return Runtime.fromValue(this.compatibleRuntime);
    }

    public String compatibleRuntimeAsString() {
        return this.compatibleRuntime;
    }

    public String layerName() {
        return this.layerName;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibleRuntimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayerVersionsRequest)) {
            return false;
        }
        ListLayerVersionsRequest other = (ListLayerVersionsRequest)((Object)obj);
        return Objects.equals(this.compatibleRuntimeAsString(), other.compatibleRuntimeAsString()) && Objects.equals(this.layerName(), other.layerName()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListLayerVersionsRequest").add("CompatibleRuntime", (Object)this.compatibleRuntimeAsString()).add("LayerName", (Object)this.layerName()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompatibleRuntime": {
                return Optional.ofNullable(clazz.cast(this.compatibleRuntimeAsString()));
            }
            case "LayerName": {
                return Optional.ofNullable(clazz.cast(this.layerName()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLayerVersionsRequest, T> g) {
        return obj -> g.apply((ListLayerVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String compatibleRuntime;
        private String layerName;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLayerVersionsRequest model) {
            super(model);
            this.compatibleRuntime(model.compatibleRuntime);
            this.layerName(model.layerName);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getCompatibleRuntimeAsString() {
            return this.compatibleRuntime;
        }

        @Override
        public final Builder compatibleRuntime(String compatibleRuntime) {
            this.compatibleRuntime = compatibleRuntime;
            return this;
        }

        @Override
        public final Builder compatibleRuntime(Runtime compatibleRuntime) {
            this.compatibleRuntime(compatibleRuntime.toString());
            return this;
        }

        public final void setCompatibleRuntime(String compatibleRuntime) {
            this.compatibleRuntime = compatibleRuntime;
        }

        public final String getLayerName() {
            return this.layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLayerVersionsRequest build() {
            return new ListLayerVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLayerVersionsRequest> {
        public Builder compatibleRuntime(String var1);

        public Builder compatibleRuntime(Runtime var1);

        public Builder layerName(String var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

