/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LayerVersionContentOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LayerVersionContentOutput> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LayerVersionContentOutput.getter(LayerVersionContentOutput::location)).setter(LayerVersionContentOutput.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LayerVersionContentOutput.getter(LayerVersionContentOutput::codeSha256)).setter(LayerVersionContentOutput.setter(Builder::codeSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSha256").build()}).build();
    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(LayerVersionContentOutput.getter(LayerVersionContentOutput::codeSize)).setter(LayerVersionContentOutput.setter(Builder::codeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD, CODE_SHA256_FIELD, CODE_SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String location;
    private final String codeSha256;
    private final Long codeSize;

    private LayerVersionContentOutput(BuilderImpl builder) {
        this.location = builder.location;
        this.codeSha256 = builder.codeSha256;
        this.codeSize = builder.codeSize;
    }

    public String location() {
        return this.location;
    }

    public String codeSha256() {
        return this.codeSha256;
    }

    public Long codeSize() {
        return this.codeSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerVersionContentOutput)) {
            return false;
        }
        LayerVersionContentOutput other = (LayerVersionContentOutput)obj;
        return Objects.equals(this.location(), other.location()) && Objects.equals(this.codeSha256(), other.codeSha256()) && Objects.equals(this.codeSize(), other.codeSize());
    }

    public String toString() {
        return ToString.builder((String)"LayerVersionContentOutput").add("Location", (Object)this.location()).add("CodeSha256", (Object)this.codeSha256()).add("CodeSize", (Object)this.codeSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "CodeSha256": {
                return Optional.ofNullable(clazz.cast(this.codeSha256()));
            }
            case "CodeSize": {
                return Optional.ofNullable(clazz.cast(this.codeSize()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LayerVersionContentOutput, T> g) {
        return obj -> g.apply((LayerVersionContentOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String location;
        private String codeSha256;
        private Long codeSize;

        private BuilderImpl() {
        }

        private BuilderImpl(LayerVersionContentOutput model) {
            this.location(model.location);
            this.codeSha256(model.codeSha256);
            this.codeSize(model.codeSize);
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getCodeSha256() {
            return this.codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        public final Long getCodeSize() {
            return this.codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        public LayerVersionContentOutput build() {
            return new LayerVersionContentOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LayerVersionContentOutput> {
        public Builder location(String var1);

        public Builder codeSha256(String var1);

        public Builder codeSize(Long var1);
    }
}

