/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A mapping between an AWS resource and an AWS Lambda function. See <a>CreateEventSourceMapping</a> for details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventSourceMappingResponse extends LambdaResponse implements
        ToCopyableBuilder<CreateEventSourceMappingResponse.Builder, CreateEventSourceMappingResponse> {
    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingResponse::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UUID").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateEventSourceMappingResponse::batchSize)).setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingResponse::eventSourceArn)).setter(setter(Builder::eventSourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()).build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingResponse::functionArn)).setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateEventSourceMappingResponse::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> LAST_PROCESSING_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingResponse::lastProcessingResult)).setter(setter(Builder::lastProcessingResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastProcessingResult").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingResponse::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateEventSourceMappingResponse::stateTransitionReason))
            .setter(setter(Builder::stateTransitionReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD, BATCH_SIZE_FIELD,
            EVENT_SOURCE_ARN_FIELD, FUNCTION_ARN_FIELD, LAST_MODIFIED_FIELD, LAST_PROCESSING_RESULT_FIELD, STATE_FIELD,
            STATE_TRANSITION_REASON_FIELD));

    private final String uuid;

    private final Integer batchSize;

    private final String eventSourceArn;

    private final String functionArn;

    private final Instant lastModified;

    private final String lastProcessingResult;

    private final String state;

    private final String stateTransitionReason;

    private CreateEventSourceMappingResponse(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.batchSize = builder.batchSize;
        this.eventSourceArn = builder.eventSourceArn;
        this.functionArn = builder.functionArn;
        this.lastModified = builder.lastModified;
        this.lastProcessingResult = builder.lastProcessingResult;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
    }

    /**
     * <p>
     * The identifier of the event source mapping.
     * </p>
     * 
     * @return The identifier of the event source mapping.
     */
    public String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The maximum number of items to retrieve in a single batch.
     * </p>
     * 
     * @return The maximum number of items to retrieve in a single batch.
     */
    public Integer batchSize() {
        return batchSize;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the event source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the event source.
     */
    public String eventSourceArn() {
        return eventSourceArn;
    }

    /**
     * <p>
     * The ARN of the Lambda function.
     * </p>
     * 
     * @return The ARN of the Lambda function.
     */
    public String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The date that the event source mapping was last updated.
     * </p>
     * 
     * @return The date that the event source mapping was last updated.
     */
    public Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The result of the last AWS Lambda invocation of your Lambda function.
     * </p>
     * 
     * @return The result of the last AWS Lambda invocation of your Lambda function.
     */
    public String lastProcessingResult() {
        return lastProcessingResult;
    }

    /**
     * <p>
     * The state of the event source mapping. It can be one of the following: <code>Creating</code>,
     * <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>, <code>Updating</code>
     * , or <code>Deleting</code>.
     * </p>
     * 
     * @return The state of the event source mapping. It can be one of the following: <code>Creating</code>,
     *         <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
     *         <code>Updating</code>, or <code>Deleting</code>.
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The cause of the last state change, either <code>User initiated</code> or <code>Lambda initiated</code>.
     * </p>
     * 
     * @return The cause of the last state change, either <code>User initiated</code> or <code>Lambda initiated</code>.
     */
    public String stateTransitionReason() {
        return stateTransitionReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(lastProcessingResult());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(stateTransitionReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventSourceMappingResponse)) {
            return false;
        }
        CreateEventSourceMappingResponse other = (CreateEventSourceMappingResponse) obj;
        return Objects.equals(uuid(), other.uuid()) && Objects.equals(batchSize(), other.batchSize())
                && Objects.equals(eventSourceArn(), other.eventSourceArn()) && Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(lastProcessingResult(), other.lastProcessingResult()) && Objects.equals(state(), other.state())
                && Objects.equals(stateTransitionReason(), other.stateTransitionReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateEventSourceMappingResponse").add("UUID", uuid()).add("BatchSize", batchSize())
                .add("EventSourceArn", eventSourceArn()).add("FunctionArn", functionArn()).add("LastModified", lastModified())
                .add("LastProcessingResult", lastProcessingResult()).add("State", state())
                .add("StateTransitionReason", stateTransitionReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "EventSourceArn":
            return Optional.ofNullable(clazz.cast(eventSourceArn()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "LastProcessingResult":
            return Optional.ofNullable(clazz.cast(lastProcessingResult()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "StateTransitionReason":
            return Optional.ofNullable(clazz.cast(stateTransitionReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventSourceMappingResponse, T> g) {
        return obj -> g.apply((CreateEventSourceMappingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventSourceMappingResponse> {
        /**
         * <p>
         * The identifier of the event source mapping.
         * </p>
         * 
         * @param uuid
         *        The identifier of the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The maximum number of items to retrieve in a single batch.
         * </p>
         * 
         * @param batchSize
         *        The maximum number of items to retrieve in a single batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the event source.
         * </p>
         * 
         * @param eventSourceArn
         *        The Amazon Resource Name (ARN) of the event source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceArn(String eventSourceArn);

        /**
         * <p>
         * The ARN of the Lambda function.
         * </p>
         * 
         * @param functionArn
         *        The ARN of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The date that the event source mapping was last updated.
         * </p>
         * 
         * @param lastModified
         *        The date that the event source mapping was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The result of the last AWS Lambda invocation of your Lambda function.
         * </p>
         * 
         * @param lastProcessingResult
         *        The result of the last AWS Lambda invocation of your Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastProcessingResult(String lastProcessingResult);

        /**
         * <p>
         * The state of the event source mapping. It can be one of the following: <code>Creating</code>,
         * <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
         * <code>Updating</code>, or <code>Deleting</code>.
         * </p>
         * 
         * @param state
         *        The state of the event source mapping. It can be one of the following: <code>Creating</code>,
         *        <code>Enabling</code>, <code>Enabled</code>, <code>Disabling</code>, <code>Disabled</code>,
         *        <code>Updating</code>, or <code>Deleting</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The cause of the last state change, either <code>User initiated</code> or <code>Lambda initiated</code>.
         * </p>
         * 
         * @param stateTransitionReason
         *        The cause of the last state change, either <code>User initiated</code> or
         *        <code>Lambda initiated</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitionReason(String stateTransitionReason);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String uuid;

        private Integer batchSize;

        private String eventSourceArn;

        private String functionArn;

        private Instant lastModified;

        private String lastProcessingResult;

        private String state;

        private String stateTransitionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventSourceMappingResponse model) {
            super(model);
            uuid(model.uuid);
            batchSize(model.batchSize);
            eventSourceArn(model.eventSourceArn);
            functionArn(model.functionArn);
            lastModified(model.lastModified);
            lastProcessingResult(model.lastProcessingResult);
            state(model.state);
            stateTransitionReason(model.stateTransitionReason);
        }

        public final String getUuid() {
            return uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public final String getEventSourceArn() {
            return eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final String getLastProcessingResult() {
            return lastProcessingResult;
        }

        @Override
        public final Builder lastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
            return this;
        }

        public final void setLastProcessingResult(String lastProcessingResult) {
            this.lastProcessingResult = lastProcessingResult;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateTransitionReason() {
            return stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public CreateEventSourceMappingResponse build() {
            return new CreateEventSourceMappingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
