/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFunctionRequest extends LambdaRequest implements
        ToCopyableBuilder<CreateFunctionRequest.Builder, CreateFunctionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFunctionRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFunctionRequest::runtimeAsString)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFunctionRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> HANDLER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFunctionRequest::handler)).setter(setter(Builder::handler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()).build();

    private static final SdkField<FunctionCode> CODE_FIELD = SdkField.<FunctionCode> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFunctionRequest::code)).setter(setter(Builder::code)).constructor(FunctionCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFunctionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateFunctionRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(CreateFunctionRequest::memorySize)).setter(setter(Builder::memorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()).build();

    private static final SdkField<Boolean> PUBLISH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateFunctionRequest::publish)).setter(setter(Builder::publish))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publish").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFunctionRequest::vpcConfig)).setter(setter(Builder::vpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateFunctionRequest::deadLetterConfig))
            .setter(setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.<Environment> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateFunctionRequest::environment)).setter(setter(Builder::environment))
            .constructor(Environment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFunctionRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()).build();

    private static final SdkField<TracingConfig> TRACING_CONFIG_FIELD = SdkField
            .<TracingConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateFunctionRequest::tracingConfig))
            .setter(setter(Builder::tracingConfig)).constructor(TracingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateFunctionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> LAYERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateFunctionRequest::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            RUNTIME_FIELD, ROLE_FIELD, HANDLER_FIELD, CODE_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD, MEMORY_SIZE_FIELD,
            PUBLISH_FIELD, VPC_CONFIG_FIELD, DEAD_LETTER_CONFIG_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD,
            TRACING_CONFIG_FIELD, TAGS_FIELD, LAYERS_FIELD));

    private final String functionName;

    private final String runtime;

    private final String role;

    private final String handler;

    private final FunctionCode code;

    private final String description;

    private final Integer timeout;

    private final Integer memorySize;

    private final Boolean publish;

    private final VpcConfig vpcConfig;

    private final DeadLetterConfig deadLetterConfig;

    private final Environment environment;

    private final String kmsKeyArn;

    private final TracingConfig tracingConfig;

    private final Map<String, String> tags;

    private final List<String> layers;

    private CreateFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.runtime = builder.runtime;
        this.role = builder.role;
        this.handler = builder.handler;
        this.code = builder.code;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.publish = builder.publish;
        this.vpcConfig = builder.vpcConfig;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.tags = builder.tags;
        this.layers = builder.layers;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The identifier of the function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The identifier of the function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
     * @see Runtime
     */
    public Runtime runtime() {
        return Runtime.fromValue(runtime);
    }

    /**
     * <p>
     * The identifier of the function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The identifier of the function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
     * @see Runtime
     */
    public String runtimeAsString() {
        return runtime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function's execution role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function's execution role.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * The name of the method within your code that Lambda calls to execute your function. The format includes the file
     * name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
     * </p>
     * 
     * @return The name of the method within your code that Lambda calls to execute your function. The format includes
     *         the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
     */
    public String handler() {
        return handler;
    }

    /**
     * <p>
     * The code for the function.
     * </p>
     * 
     * @return The code for the function.
     */
    public FunctionCode code() {
        return code;
    }

    /**
     * <p>
     * A description of the function.
     * </p>
     * 
     * @return A description of the function.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum
     * allowed value is 900 seconds.
     * </p>
     * 
     * @return The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds. The
     *         maximum allowed value is 900 seconds.
     */
    public Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The amount of memory that your function has access to. Increasing the function's memory also increases its CPU
     * allocation. The default value is 128 MB. The value must be a multiple of 64 MB.
     * </p>
     * 
     * @return The amount of memory that your function has access to. Increasing the function's memory also increases
     *         its CPU allocation. The default value is 128 MB. The value must be a multiple of 64 MB.
     */
    public Integer memorySize() {
        return memorySize;
    }

    /**
     * <p>
     * Set to true to publish the first version of the function during creation.
     * </p>
     * 
     * @return Set to true to publish the first version of the function during creation.
     */
    public Boolean publish() {
        return publish;
    }

    /**
     * <p>
     * For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC.
     * When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/vpc.html">VPC Settings</a>.
     * </p>
     * 
     * @return For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the
     *         VPC. When you connect a function to a VPC, it can only access resources and the internet through that
     *         VPC. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/vpc.html">VPC
     *         Settings</a>.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when
     * they fail processing. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/dlq.html">Dead Letter Queues</a>.
     * </p>
     * 
     * @return A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous
     *         events when they fail processing. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/dlq.html">Dead Letter Queues</a>.
     */
    public DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    /**
     * <p>
     * Environment variables that are accessible from function code during execution.
     * </p>
     * 
     * @return Environment variables that are accessible from function code during execution.
     */
    public Environment environment() {
        return environment;
    }

    /**
     * <p>
     * The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt your function's environment
     * variables. If it's not provided, AWS Lambda uses a default service key.
     * </p>
     * 
     * @return The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt your function's
     *         environment variables. If it's not provided, AWS Lambda uses a default service key.
     */
    public String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with AWS X-Ray.
     * </p>
     * 
     * @return Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with AWS
     *         X-Ray.
     */
    public TracingConfig tracingConfig() {
        return tracingConfig;
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the
     *         function.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to
     * add to the function's execution environment. Specify each layer by its ARN, including the version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
     *         layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
     *         version.
     */
    public List<String> layers() {
        return layers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(handler());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(publish());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(layers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionRequest)) {
            return false;
        }
        CreateFunctionRequest other = (CreateFunctionRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(runtimeAsString(), other.runtimeAsString())
                && Objects.equals(role(), other.role()) && Objects.equals(handler(), other.handler())
                && Objects.equals(code(), other.code()) && Objects.equals(description(), other.description())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(memorySize(), other.memorySize())
                && Objects.equals(publish(), other.publish()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(deadLetterConfig(), other.deadLetterConfig())
                && Objects.equals(environment(), other.environment()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(tracingConfig(), other.tracingConfig()) && Objects.equals(tags(), other.tags())
                && Objects.equals(layers(), other.layers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFunctionRequest").add("FunctionName", functionName()).add("Runtime", runtimeAsString())
                .add("Role", role()).add("Handler", handler()).add("Code", code()).add("Description", description())
                .add("Timeout", timeout()).add("MemorySize", memorySize()).add("Publish", publish())
                .add("VpcConfig", vpcConfig()).add("DeadLetterConfig", deadLetterConfig()).add("Environment", environment())
                .add("KMSKeyArn", kmsKeyArn()).add("TracingConfig", tracingConfig()).add("Tags", tags()).add("Layers", layers())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Handler":
            return Optional.ofNullable(clazz.cast(handler()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "MemorySize":
            return Optional.ofNullable(clazz.cast(memorySize()));
        case "Publish":
            return Optional.ofNullable(clazz.cast(publish()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "KMSKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "TracingConfig":
            return Optional.ofNullable(clazz.cast(tracingConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Layers":
            return Optional.ofNullable(clazz.cast(layers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFunctionRequest, T> g) {
        return obj -> g.apply((CreateFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFunctionRequest> {
        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The identifier of the function's <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
         * </p>
         * 
         * @param runtime
         *        The identifier of the function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The identifier of the function's <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
         * </p>
         * 
         * @param runtime
         *        The identifier of the function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(Runtime runtime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function's execution role.
         * </p>
         * 
         * @param role
         *        The Amazon Resource Name (ARN) of the function's execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The name of the method within your code that Lambda calls to execute your function. The format includes the
         * file name. It can also include namespaces and other qualifiers, depending on the runtime. For more
         * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming
         * Model</a>.
         * </p>
         * 
         * @param handler
         *        The name of the method within your code that Lambda calls to execute your function. The format
         *        includes the file name. It can also include namespaces and other qualifiers, depending on the runtime.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handler(String handler);

        /**
         * <p>
         * The code for the function.
         * </p>
         * 
         * @param code
         *        The code for the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(FunctionCode code);

        /**
         * <p>
         * The code for the function.
         * </p>
         * This is a convenience that creates an instance of the {@link FunctionCode.Builder} avoiding the need to
         * create one manually via {@link FunctionCode#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionCode.Builder#build()} is called immediately and its
         * result is passed to {@link #code(FunctionCode)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link FunctionCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(FunctionCode)
         */
        default Builder code(Consumer<FunctionCode.Builder> code) {
            return code(FunctionCode.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * A description of the function.
         * </p>
         * 
         * @param description
         *        A description of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds. The
         * maximum allowed value is 900 seconds.
         * </p>
         * 
         * @param timeout
         *        The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds.
         *        The maximum allowed value is 900 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The amount of memory that your function has access to. Increasing the function's memory also increases its
         * CPU allocation. The default value is 128 MB. The value must be a multiple of 64 MB.
         * </p>
         * 
         * @param memorySize
         *        The amount of memory that your function has access to. Increasing the function's memory also increases
         *        its CPU allocation. The default value is 128 MB. The value must be a multiple of 64 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySize(Integer memorySize);

        /**
         * <p>
         * Set to true to publish the first version of the function during creation.
         * </p>
         * 
         * @param publish
         *        Set to true to publish the first version of the function during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publish(Boolean publish);

        /**
         * <p>
         * For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC.
         * When you connect a function to a VPC, it can only access resources and the internet through that VPC. For
         * more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/vpc.html">VPC Settings</a>.
         * </p>
         * 
         * @param vpcConfig
         *        For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in
         *        the VPC. When you connect a function to a VPC, it can only access resources and the internet through
         *        that VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/vpc.html">VPC Settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC.
         * When you connect a function to a VPC, it can only access resources and the internet through that VPC. For
         * more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/vpc.html">VPC Settings</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
         * when they fail processing. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/dlq.html">Dead Letter Queues</a>.
         * </p>
         * 
         * @param deadLetterConfig
         *        A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous
         *        events when they fail processing. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/dlq.html">Dead Letter Queues</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * <p>
         * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
         * when they fail processing. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/dlq.html">Dead Letter Queues</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the need to
         * create one manually via {@link DeadLetterConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        /**
         * <p>
         * Environment variables that are accessible from function code during execution.
         * </p>
         * 
         * @param environment
         *        Environment variables that are accessible from function code during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Environment environment);

        /**
         * <p>
         * Environment variables that are accessible from function code during execution.
         * </p>
         * This is a convenience that creates an instance of the {@link Environment.Builder} avoiding the need to create
         * one manually via {@link Environment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Environment.Builder#build()} is called immediately and its result
         * is passed to {@link #environment(Environment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link Environment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(Environment)
         */
        default Builder environment(Consumer<Environment.Builder> environment) {
            return environment(Environment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt your function's environment
         * variables. If it's not provided, AWS Lambda uses a default service key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt your function's
         *        environment variables. If it's not provided, AWS Lambda uses a default service key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with AWS
         * X-Ray.
         * </p>
         * 
         * @param tracingConfig
         *        Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with
         *        AWS X-Ray.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingConfig(TracingConfig tracingConfig);

        /**
         * <p>
         * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with AWS
         * X-Ray.
         * </p>
         * This is a convenience that creates an instance of the {@link TracingConfig.Builder} avoiding the need to
         * create one manually via {@link TracingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TracingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #tracingConfig(TracingConfig)}.
         * 
         * @param tracingConfig
         *        a consumer that will call methods on {@link TracingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracingConfig(TracingConfig)
         */
        default Builder tracingConfig(Consumer<TracingConfig.Builder> tracingConfig) {
            return tracingConfig(TracingConfig.builder().applyMutation(tracingConfig).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the
         * function.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the
         *        function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         * layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
         * version.
         * </p>
         * 
         * @param layers
         *        A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         *        layers</a> to add to the function's execution environment. Specify each layer by its ARN, including
         *        the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<String> layers);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         * layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
         * version.
         * </p>
         * 
         * @param layers
         *        A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         *        layers</a> to add to the function's execution environment. Specify each layer by its ARN, including
         *        the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(String... layers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String runtime;

        private String role;

        private String handler;

        private FunctionCode code;

        private String description;

        private Integer timeout;

        private Integer memorySize;

        private Boolean publish;

        private VpcConfig vpcConfig;

        private DeadLetterConfig deadLetterConfig;

        private Environment environment;

        private String kmsKeyArn;

        private TracingConfig tracingConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> layers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionRequest model) {
            super(model);
            functionName(model.functionName);
            runtime(model.runtime);
            role(model.role);
            handler(model.handler);
            code(model.code);
            description(model.description);
            timeout(model.timeout);
            memorySize(model.memorySize);
            publish(model.publish);
            vpcConfig(model.vpcConfig);
            deadLetterConfig(model.deadLetterConfig);
            environment(model.environment);
            kmsKeyArn(model.kmsKeyArn);
            tracingConfig(model.tracingConfig);
            tags(model.tags);
            layers(model.layers);
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getRuntimeAsString() {
            return runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final FunctionCode.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        @Override
        public final Builder code(FunctionCode code) {
            this.code = code;
            return this;
        }

        public final void setCode(FunctionCode.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final Boolean getPublish() {
            return publish;
        }

        @Override
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final Environment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfig.Builder getTracingConfig() {
            return tracingConfig != null ? tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<String> getLayers() {
            return layers;
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFunctionRequest build() {
            return new CreateFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
