/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLayerVersionsRequest extends LambdaRequest implements
        ToCopyableBuilder<ListLayerVersionsRequest.Builder, ListLayerVersionsRequest> {
    private static final SdkField<String> COMPATIBLE_RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLayerVersionsRequest::compatibleRuntimeAsString)).setter(setter(Builder::compatibleRuntime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CompatibleRuntime").build())
            .build();

    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLayerVersionsRequest::layerName)).setter(setter(Builder::layerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListLayerVersionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListLayerVersionsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_RUNTIME_FIELD,
            LAYER_NAME_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String compatibleRuntime;

    private final String layerName;

    private final String marker;

    private final Integer maxItems;

    private ListLayerVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.compatibleRuntime = builder.compatibleRuntime;
        this.layerName = builder.layerName;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * A runtime identifier. For example, <code>go1.x</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compatibleRuntime}
     * will return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compatibleRuntimeAsString}.
     * </p>
     * 
     * @return A runtime identifier. For example, <code>go1.x</code>.
     * @see Runtime
     */
    public Runtime compatibleRuntime() {
        return Runtime.fromValue(compatibleRuntime);
    }

    /**
     * <p>
     * A runtime identifier. For example, <code>go1.x</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #compatibleRuntime}
     * will return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compatibleRuntimeAsString}.
     * </p>
     * 
     * @return A runtime identifier. For example, <code>go1.x</code>.
     * @see Runtime
     */
    public String compatibleRuntimeAsString() {
        return compatibleRuntime;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the layer.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the layer.
     */
    public String layerName() {
        return layerName;
    }

    /**
     * <p>
     * A pagination token returned by a previous call.
     * </p>
     * 
     * @return A pagination token returned by a previous call.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of versions to return.
     * </p>
     * 
     * @return The maximum number of versions to return.
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(compatibleRuntimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(layerName());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLayerVersionsRequest)) {
            return false;
        }
        ListLayerVersionsRequest other = (ListLayerVersionsRequest) obj;
        return Objects.equals(compatibleRuntimeAsString(), other.compatibleRuntimeAsString())
                && Objects.equals(layerName(), other.layerName()) && Objects.equals(marker(), other.marker())
                && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListLayerVersionsRequest").add("CompatibleRuntime", compatibleRuntimeAsString())
                .add("LayerName", layerName()).add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompatibleRuntime":
            return Optional.ofNullable(clazz.cast(compatibleRuntimeAsString()));
        case "LayerName":
            return Optional.ofNullable(clazz.cast(layerName()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLayerVersionsRequest, T> g) {
        return obj -> g.apply((ListLayerVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLayerVersionsRequest> {
        /**
         * <p>
         * A runtime identifier. For example, <code>go1.x</code>.
         * </p>
         * 
         * @param compatibleRuntime
         *        A runtime identifier. For example, <code>go1.x</code>.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder compatibleRuntime(String compatibleRuntime);

        /**
         * <p>
         * A runtime identifier. For example, <code>go1.x</code>.
         * </p>
         * 
         * @param compatibleRuntime
         *        A runtime identifier. For example, <code>go1.x</code>.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder compatibleRuntime(Runtime compatibleRuntime);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the layer.
         * </p>
         * 
         * @param layerName
         *        The name or Amazon Resource Name (ARN) of the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerName(String layerName);

        /**
         * <p>
         * A pagination token returned by a previous call.
         * </p>
         * 
         * @param marker
         *        A pagination token returned by a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of versions to return.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of versions to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String compatibleRuntime;

        private String layerName;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLayerVersionsRequest model) {
            super(model);
            compatibleRuntime(model.compatibleRuntime);
            layerName(model.layerName);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getCompatibleRuntimeAsString() {
            return compatibleRuntime;
        }

        @Override
        public final Builder compatibleRuntime(String compatibleRuntime) {
            this.compatibleRuntime = compatibleRuntime;
            return this;
        }

        @Override
        public final Builder compatibleRuntime(Runtime compatibleRuntime) {
            this.compatibleRuntime(compatibleRuntime.toString());
            return this;
        }

        public final void setCompatibleRuntime(String compatibleRuntime) {
            this.compatibleRuntime = compatibleRuntime;
        }

        public final String getLayerName() {
            return layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLayerVersionsRequest build() {
            return new ListLayerVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
