/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEventSourceMappingRequest extends LambdaRequest implements
        ToCopyableBuilder<UpdateEventSourceMappingRequest.Builder, UpdateEventSourceMappingRequest> {
    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEventSourceMappingRequest::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UUID").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEventSourceMappingRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateEventSourceMappingRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEventSourceMappingRequest::batchSize)).setter(setter(Builder::batchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()).build();

    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateEventSourceMappingRequest::maximumBatchingWindowInSeconds))
            .setter(setter(Builder::maximumBatchingWindowInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UUID_FIELD,
            FUNCTION_NAME_FIELD, ENABLED_FIELD, BATCH_SIZE_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD));

    private final String uuid;

    private final String functionName;

    private final Boolean enabled;

    private final Integer batchSize;

    private final Integer maximumBatchingWindowInSeconds;

    private UpdateEventSourceMappingRequest(BuilderImpl builder) {
        super(builder);
        this.uuid = builder.uuid;
        this.functionName = builder.functionName;
        this.enabled = builder.enabled;
        this.batchSize = builder.batchSize;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
    }

    /**
     * <p>
     * The identifier of the event source mapping.
     * </p>
     * 
     * @return The identifier of the event source mapping.
     */
    public String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it's limited
     *         to 64 characters in length.
     */
    public String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Disables the event source mapping to pause polling and invocation.
     * </p>
     * 
     * @return Disables the event source mapping to pause polling and invocation.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The maximum number of items to retrieve in a single batch.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon Kinesis</b> - Default 100. Max 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Amazon Simple Queue Service</b> - Default 10. Max 10.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The maximum number of items to retrieve in a single batch.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Amazon Kinesis</b> - Default 100. Max 10,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Amazon Simple Queue Service</b> - Default 10. Max 10.
     *         </p>
     *         </li>
     */
    public Integer batchSize() {
        return batchSize;
    }

    /**
     * Returns the value of the MaximumBatchingWindowInSeconds property for this object.
     * 
     * @return The value of the MaximumBatchingWindowInSeconds property for this object.
     */
    public Integer maximumBatchingWindowInSeconds() {
        return maximumBatchingWindowInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(maximumBatchingWindowInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventSourceMappingRequest)) {
            return false;
        }
        UpdateEventSourceMappingRequest other = (UpdateEventSourceMappingRequest) obj;
        return Objects.equals(uuid(), other.uuid()) && Objects.equals(functionName(), other.functionName())
                && Objects.equals(enabled(), other.enabled()) && Objects.equals(batchSize(), other.batchSize())
                && Objects.equals(maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEventSourceMappingRequest").add("UUID", uuid()).add("FunctionName", functionName())
                .add("Enabled", enabled()).add("BatchSize", batchSize())
                .add("MaximumBatchingWindowInSeconds", maximumBatchingWindowInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UUID":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "BatchSize":
            return Optional.ofNullable(clazz.cast(batchSize()));
        case "MaximumBatchingWindowInSeconds":
            return Optional.ofNullable(clazz.cast(maximumBatchingWindowInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventSourceMappingRequest, T> g) {
        return obj -> g.apply((UpdateEventSourceMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEventSourceMappingRequest> {
        /**
         * <p>
         * The identifier of the event source mapping.
         * </p>
         * 
         * @param uuid
         *        The identifier of the event source mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Version or Alias ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64
         * characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Version or Alias ARN</b> -
         *        <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it's
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Disables the event source mapping to pause polling and invocation.
         * </p>
         * 
         * @param enabled
         *        Disables the event source mapping to pause polling and invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The maximum number of items to retrieve in a single batch.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon Kinesis</b> - Default 100. Max 10,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Amazon Simple Queue Service</b> - Default 10. Max 10.
         * </p>
         * </li>
         * </ul>
         * 
         * @param batchSize
         *        The maximum number of items to retrieve in a single batch.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Amazon Kinesis</b> - Default 100. Max 10,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon DynamoDB Streams</b> - Default 100. Max 1,000.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Amazon Simple Queue Service</b> - Default 10. Max 10.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);

        /**
         * Sets the value of the MaximumBatchingWindowInSeconds property for this object.
         *
         * @param maximumBatchingWindowInSeconds
         *        The new value for the MaximumBatchingWindowInSeconds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String uuid;

        private String functionName;

        private Boolean enabled;

        private Integer batchSize;

        private Integer maximumBatchingWindowInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventSourceMappingRequest model) {
            super(model);
            uuid(model.uuid);
            functionName(model.functionName);
            enabled(model.enabled);
            batchSize(model.batchSize);
            maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
        }

        public final String getUuid() {
            return uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventSourceMappingRequest build() {
            return new UpdateEventSourceMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
