/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.lambda.snapstart;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.generic.Type;
import software.amazon.lambda.snapstart.LambdaHandlerFieldsDatabase;
import software.amazon.lambda.snapstart.LambdaHandlerParentsDatabase;

public class ByteCodeIntrospector {
    private static final String LAMBDA_HANDLER_SIGNATURE = "(Ljava/util/Map;Lcom/amazonaws/services/lambda/runtime/Context;)";
    private static final String LAMBDA_STREAMING_HANDLER_SIGNATURE = "(Ljava/io/InputStream;Ljava/io/OutputStream;Lcom/amazonaws/services/lambda/runtime/Context;)";
    private static final Set<String> LAMBDA_HANDLER_INTERFACES = new HashSet<String>(){
        {
            this.add("com.amazonaws.services.lambda.runtime.RequestHandler");
            this.add("com.amazonaws.services.lambda.runtime.RequestStreamHandler");
        }
    };
    private static final String FUNCTIONAL_INTERFACE = "java.util.function.Function";
    private static final String CRAC_RESOURCE_INTERFACE = "org.crac.Resource";
    private static final String RANDOM_SIGNATURE = "Ljava/util/Random;";
    private static final String INSTANT_SIGNATURE = "Ljava/time/Instant;";
    private static final Map<String, Set<String>> TIMESTAMP_METHODS = new HashMap<String, Set<String>>(){
        {
            this.put("java.lang.System", ByteCodeIntrospector.setOf(new String[]{"currentTimeMillis", "nanoTime"}));
        }
    };
    private LambdaHandlerParentsDatabase lambdaHandlerParentsDatabase;
    private LambdaHandlerFieldsDatabase database;

    private static Set<String> setOf(String ... strings) {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, strings);
        return set;
    }

    boolean isLambdaHandler(XClass xClass) {
        return this.implementsLambdaInterface(xClass) || this.implementsFunctionalInterface(xClass) || this.hasLambdaHandlerMethod(xClass) || this.hasHandlerInClassName(xClass) && this.hasHandleRequestMethod(xClass);
    }

    private boolean hasHandlerInClassName(XClass xClass) {
        return xClass.toString().contains("Handler");
    }

    private boolean hasHandleRequestMethod(XClass xClass) {
        List methods = xClass.getXMethods();
        for (XMethod method : methods) {
            if (!method.getName().equals("handleRequest")) continue;
            return true;
        }
        return false;
    }

    boolean hasLambdaHandlerMethod(XClass xClass) {
        List methods = xClass.getXMethods();
        for (XMethod method : methods) {
            if (method.getSignature() == null) continue;
            if (method.getSignature().startsWith(LAMBDA_HANDLER_SIGNATURE)) {
                return true;
            }
            if (!method.getSignature().startsWith(LAMBDA_STREAMING_HANDLER_SIGNATURE)) continue;
            return true;
        }
        return false;
    }

    boolean implementsLambdaInterface(XClass xClass) {
        for (ClassDescriptor classDescriptor : xClass.getInterfaceDescriptorList()) {
            try {
                if (!classDescriptor.getXClass().isInterface() || !LAMBDA_HANDLER_INTERFACES.contains(classDescriptor.getDottedClassName())) continue;
                return true;
            }
            catch (CheckedAnalysisException checkedAnalysisException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean isLambdaHandlerParentClass(XClass xClass) {
        this.lambdaHandlerParentsDatabase = (LambdaHandlerParentsDatabase)Global.getAnalysisCache().getDatabase(LambdaHandlerParentsDatabase.class);
        return this.lambdaHandlerParentsDatabase.getParentClasses().contains(xClass.toString());
    }

    boolean implementsFunctionalInterface(XClass xClass) {
        for (ClassDescriptor classDescriptor : xClass.getInterfaceDescriptorList()) {
            try {
                if (!classDescriptor.getXClass().isInterface() || !FUNCTIONAL_INTERFACE.equals(classDescriptor.getDottedClassName())) continue;
                return true;
            }
            catch (CheckedAnalysisException checkedAnalysisException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean isLambdaHandlerField(XClass xClass) {
        this.database = (LambdaHandlerFieldsDatabase)((Object)Global.getAnalysisCache().getDatabase(LambdaHandlerFieldsDatabase.class));
        for (FieldDescriptor fieldDescriptor : this.database.getKeys()) {
            String fieldType = Type.getReturnType((String)fieldDescriptor.getSignature()).toString().replace(".", "/");
            if (!fieldType.equals(xClass.toString())) continue;
            return true;
        }
        return false;
    }

    boolean isCracResource(XClass xClass) {
        for (ClassDescriptor classDescriptor : xClass.getInterfaceDescriptorList()) {
            try {
                if (!classDescriptor.getXClass().isInterface() || !CRAC_RESOURCE_INTERFACE.equals(classDescriptor.getDottedClassName())) continue;
                return true;
            }
            catch (CheckedAnalysisException checkedAnalysisException) {
                // empty catch block
            }
        }
        return false;
    }

    boolean isRandomType(OpcodeStack stack) {
        return RANDOM_SIGNATURE.equals(stack.getStackItem(0).getSignature());
    }

    boolean isTimestamp(OpcodeStack stack) {
        Set<String> methodNames;
        if (INSTANT_SIGNATURE.equals(stack.getStackItem(0).getSignature())) {
            return true;
        }
        XMethod xMethod = stack.getStackItem(0).getReturnValueOf();
        if (xMethod != null && (methodNames = TIMESTAMP_METHODS.get(xMethod.getClassName())) != null) {
            return methodNames.contains(xMethod.getName());
        }
        return false;
    }
}

