/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"title", "url", "linkType"})
public class Link {
    public static final String JSON_PROPERTY_TITLE = "title";
    @Nonnull
    private String title;
    public static final String JSON_PROPERTY_URL = "url";
    @Nonnull
    private URI url;
    public static final String JSON_PROPERTY_LINK_TYPE = "linkType";
    @Nonnull
    private String linkType;

    public Link title(@Nonnull String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTitle(@Nonnull String title) {
        this.title = title;
    }

    public Link url(@Nonnull URI url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(@Nonnull URI url) {
        this.url = url;
    }

    public Link linkType(@Nonnull String linkType) {
        this.linkType = linkType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="linkType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLinkType() {
        return this.linkType;
    }

    @JsonProperty(value="linkType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLinkType(@Nonnull String linkType) {
        this.linkType = linkType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.title, link.title) && Objects.equals(this.url, link.url) && Objects.equals(this.linkType, link.linkType);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.url, this.linkType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Link {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    linkType: ").append(this.toIndentedString(this.linkType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTitle() != null) {
            try {
                joiner.add(String.format("%stitle%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTitle()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getUrl() != null) {
            try {
                joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLinkType() != null) {
            try {
                joiner.add(String.format("%slinkType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLinkType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

