/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import software.xdev.sessionize.model.CategoryAll;
import software.xdev.sessionize.model.Question;
import software.xdev.sessionize.model.Room;
import software.xdev.sessionize.model.SessionAll;
import software.xdev.sessionize.model.SpeakerAll;

@JsonPropertyOrder(value={"sessions", "speakers", "questions", "categories", "rooms"})
public class AllResult {
    public static final String JSON_PROPERTY_SESSIONS = "sessions";
    @Nonnull
    private List<SessionAll> sessions = new ArrayList<SessionAll>();
    public static final String JSON_PROPERTY_SPEAKERS = "speakers";
    @Nonnull
    private List<SpeakerAll> speakers = new ArrayList<SpeakerAll>();
    public static final String JSON_PROPERTY_QUESTIONS = "questions";
    @Nonnull
    private List<Question> questions = new ArrayList<Question>();
    public static final String JSON_PROPERTY_CATEGORIES = "categories";
    @Nonnull
    private List<CategoryAll> categories = new ArrayList<CategoryAll>();
    public static final String JSON_PROPERTY_ROOMS = "rooms";
    @Nonnull
    private List<Room> rooms = new ArrayList<Room>();

    public AllResult sessions(@Nonnull List<SessionAll> sessions) {
        this.sessions = sessions;
        return this;
    }

    public AllResult addSessionsItem(SessionAll sessionsItem) {
        if (this.sessions == null) {
            this.sessions = new ArrayList<SessionAll>();
        }
        this.sessions.add(sessionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="sessions", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SessionAll> getSessions() {
        return this.sessions;
    }

    @JsonProperty(value="sessions", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSessions(@Nonnull List<SessionAll> sessions) {
        this.sessions = sessions;
    }

    public AllResult speakers(@Nonnull List<SpeakerAll> speakers) {
        this.speakers = speakers;
        return this;
    }

    public AllResult addSpeakersItem(SpeakerAll speakersItem) {
        if (this.speakers == null) {
            this.speakers = new ArrayList<SpeakerAll>();
        }
        this.speakers.add(speakersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="speakers", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SpeakerAll> getSpeakers() {
        return this.speakers;
    }

    @JsonProperty(value="speakers", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSpeakers(@Nonnull List<SpeakerAll> speakers) {
        this.speakers = speakers;
    }

    public AllResult questions(@Nonnull List<Question> questions) {
        this.questions = questions;
        return this;
    }

    public AllResult addQuestionsItem(Question questionsItem) {
        if (this.questions == null) {
            this.questions = new ArrayList<Question>();
        }
        this.questions.add(questionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="questions", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Question> getQuestions() {
        return this.questions;
    }

    @JsonProperty(value="questions", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuestions(@Nonnull List<Question> questions) {
        this.questions = questions;
    }

    public AllResult categories(@Nonnull List<CategoryAll> categories) {
        this.categories = categories;
        return this;
    }

    public AllResult addCategoriesItem(CategoryAll categoriesItem) {
        if (this.categories == null) {
            this.categories = new ArrayList<CategoryAll>();
        }
        this.categories.add(categoriesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="categories", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<CategoryAll> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="categories", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategories(@Nonnull List<CategoryAll> categories) {
        this.categories = categories;
    }

    public AllResult rooms(@Nonnull List<Room> rooms) {
        this.rooms = rooms;
        return this;
    }

    public AllResult addRoomsItem(Room roomsItem) {
        if (this.rooms == null) {
            this.rooms = new ArrayList<Room>();
        }
        this.rooms.add(roomsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="rooms", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Room> getRooms() {
        return this.rooms;
    }

    @JsonProperty(value="rooms", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRooms(@Nonnull List<Room> rooms) {
        this.rooms = rooms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllResult allResult = (AllResult)o;
        return Objects.equals(this.sessions, allResult.sessions) && Objects.equals(this.speakers, allResult.speakers) && Objects.equals(this.questions, allResult.questions) && Objects.equals(this.categories, allResult.categories) && Objects.equals(this.rooms, allResult.rooms);
    }

    public int hashCode() {
        return Objects.hash(this.sessions, this.speakers, this.questions, this.categories, this.rooms);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AllResult {\n");
        sb.append("    sessions: ").append(this.toIndentedString(this.sessions)).append("\n");
        sb.append("    speakers: ").append(this.toIndentedString(this.speakers)).append("\n");
        sb.append("    questions: ").append(this.toIndentedString(this.questions)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("    rooms: ").append(this.toIndentedString(this.rooms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSessions() != null) {
            for (i = 0; i < this.getSessions().size(); ++i) {
                if (this.getSessions().get(i) == null) continue;
                joiner.add(this.getSessions().get(i).toUrlQueryString(String.format(Locale.ROOT, "%ssessions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getSpeakers() != null) {
            for (i = 0; i < this.getSpeakers().size(); ++i) {
                if (this.getSpeakers().get(i) == null) continue;
                joiner.add(this.getSpeakers().get(i).toUrlQueryString(String.format(Locale.ROOT, "%sspeakers%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getQuestions() != null) {
            for (i = 0; i < this.getQuestions().size(); ++i) {
                if (this.getQuestions().get(i) == null) continue;
                joiner.add(this.getQuestions().get(i).toUrlQueryString(String.format(Locale.ROOT, "%squestions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getCategories() != null) {
            for (i = 0; i < this.getCategories().size(); ++i) {
                if (this.getCategories().get(i) == null) continue;
                joiner.add(this.getCategories().get(i).toUrlQueryString(String.format(Locale.ROOT, "%scategories%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getRooms() != null) {
            for (i = 0; i < this.getRooms().size(); ++i) {
                if (this.getRooms().get(i) == null) continue;
                joiner.add(this.getRooms().get(i).toUrlQueryString(String.format(Locale.ROOT, "%srooms%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

