/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sessionize.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullable;
import software.xdev.sessionize.model.CategorySession;
import software.xdev.sessionize.model.QuestionAnswerFull;
import software.xdev.sessionize.model.SpeakerMinimal;
import software.xdev.sessionize.model.Status;

@JsonPropertyOrder(value={"id", "title", "description", "startsAt", "endsAt", "isServiceSession", "isPlenumSession", "categoryItems", "roomId", "liveUrl", "recordingUrl", "status", "room", "speakers", "questionAnswers", "categories"})
public class Session {
    public static final String JSON_PROPERTY_ID = "id";
    @Nonnull
    private String id;
    public static final String JSON_PROPERTY_TITLE = "title";
    @Nonnull
    private String title;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private JsonNullable<String> description = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STARTS_AT = "startsAt";
    @Nullable
    private OffsetDateTime startsAt;
    public static final String JSON_PROPERTY_ENDS_AT = "endsAt";
    @Nullable
    private OffsetDateTime endsAt;
    public static final String JSON_PROPERTY_IS_SERVICE_SESSION = "isServiceSession";
    @Nonnull
    private Boolean isServiceSession;
    public static final String JSON_PROPERTY_IS_PLENUM_SESSION = "isPlenumSession";
    @Nonnull
    private Boolean isPlenumSession;
    public static final String JSON_PROPERTY_CATEGORY_ITEMS = "categoryItems";
    @Nonnull
    private List<Integer> categoryItems = new ArrayList<Integer>();
    public static final String JSON_PROPERTY_ROOM_ID = "roomId";
    @Nullable
    private Integer roomId;
    public static final String JSON_PROPERTY_LIVE_URL = "liveUrl";
    @Nullable
    private JsonNullable<URI> liveUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RECORDING_URL = "recordingUrl";
    @Nullable
    private JsonNullable<URI> recordingUrl = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATUS = "status";
    @Nonnull
    private Status status;
    public static final String JSON_PROPERTY_ROOM = "room";
    @Nullable
    private JsonNullable<String> room = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SPEAKERS = "speakers";
    @Nonnull
    private List<SpeakerMinimal> speakers = new ArrayList<SpeakerMinimal>();
    public static final String JSON_PROPERTY_QUESTION_ANSWERS = "questionAnswers";
    @Nonnull
    private List<QuestionAnswerFull> questionAnswers = new ArrayList<QuestionAnswerFull>();
    public static final String JSON_PROPERTY_CATEGORIES = "categories";
    @Nonnull
    private List<CategorySession> categories = new ArrayList<CategorySession>();

    public Session id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @JsonProperty(value="id", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Session title(@Nonnull String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    @JsonProperty(value="title", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTitle(@Nonnull String title) {
        this.title = title;
    }

    public Session description(@Nullable String description) {
        this.description = JsonNullable.of((Object)description);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDescription() {
        return (String)this.description.orElse(null);
    }

    @JsonProperty(value="description", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDescription_JsonNullable() {
        return this.description;
    }

    @JsonProperty(value="description", required=false)
    public void setDescription_JsonNullable(JsonNullable<String> description) {
        this.description = description;
    }

    public void setDescription(@Nullable String description) {
        this.description = JsonNullable.of((Object)description);
    }

    public Session startsAt(@Nullable OffsetDateTime startsAt) {
        this.startsAt = startsAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="startsAt", required=false)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getStartsAt() {
        return this.startsAt;
    }

    @JsonProperty(value="startsAt", required=false)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStartsAt(@Nullable OffsetDateTime startsAt) {
        this.startsAt = startsAt;
    }

    public Session endsAt(@Nullable OffsetDateTime endsAt) {
        this.endsAt = endsAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="endsAt", required=false)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getEndsAt() {
        return this.endsAt;
    }

    @JsonProperty(value="endsAt", required=false)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndsAt(@Nullable OffsetDateTime endsAt) {
        this.endsAt = endsAt;
    }

    public Session isServiceSession(@Nonnull Boolean isServiceSession) {
        this.isServiceSession = isServiceSession;
        return this;
    }

    @Nonnull
    @JsonProperty(value="isServiceSession", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsServiceSession() {
        return this.isServiceSession;
    }

    @JsonProperty(value="isServiceSession", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsServiceSession(@Nonnull Boolean isServiceSession) {
        this.isServiceSession = isServiceSession;
    }

    public Session isPlenumSession(@Nonnull Boolean isPlenumSession) {
        this.isPlenumSession = isPlenumSession;
        return this;
    }

    @Nonnull
    @JsonProperty(value="isPlenumSession", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsPlenumSession() {
        return this.isPlenumSession;
    }

    @JsonProperty(value="isPlenumSession", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsPlenumSession(@Nonnull Boolean isPlenumSession) {
        this.isPlenumSession = isPlenumSession;
    }

    public Session categoryItems(@Nonnull List<Integer> categoryItems) {
        this.categoryItems = categoryItems;
        return this;
    }

    public Session addCategoryItemsItem(Integer categoryItemsItem) {
        if (this.categoryItems == null) {
            this.categoryItems = new ArrayList<Integer>();
        }
        this.categoryItems.add(categoryItemsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="categoryItems", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Integer> getCategoryItems() {
        return this.categoryItems;
    }

    @JsonProperty(value="categoryItems", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategoryItems(@Nonnull List<Integer> categoryItems) {
        this.categoryItems = categoryItems;
    }

    public Session roomId(@Nullable Integer roomId) {
        this.roomId = roomId;
        return this;
    }

    @Nullable
    @JsonProperty(value="roomId", required=false)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRoomId() {
        return this.roomId;
    }

    @JsonProperty(value="roomId", required=false)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoomId(@Nullable Integer roomId) {
        this.roomId = roomId;
    }

    public Session liveUrl(@Nullable URI liveUrl) {
        this.liveUrl = JsonNullable.of((Object)liveUrl);
        return this;
    }

    @Nullable
    @JsonIgnore
    public URI getLiveUrl() {
        return (URI)this.liveUrl.orElse(null);
    }

    @JsonProperty(value="liveUrl", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getLiveUrl_JsonNullable() {
        return this.liveUrl;
    }

    @JsonProperty(value="liveUrl", required=false)
    public void setLiveUrl_JsonNullable(JsonNullable<URI> liveUrl) {
        this.liveUrl = liveUrl;
    }

    public void setLiveUrl(@Nullable URI liveUrl) {
        this.liveUrl = JsonNullable.of((Object)liveUrl);
    }

    public Session recordingUrl(@Nullable URI recordingUrl) {
        this.recordingUrl = JsonNullable.of((Object)recordingUrl);
        return this;
    }

    @Nullable
    @JsonIgnore
    public URI getRecordingUrl() {
        return (URI)this.recordingUrl.orElse(null);
    }

    @JsonProperty(value="recordingUrl", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<URI> getRecordingUrl_JsonNullable() {
        return this.recordingUrl;
    }

    @JsonProperty(value="recordingUrl", required=false)
    public void setRecordingUrl_JsonNullable(JsonNullable<URI> recordingUrl) {
        this.recordingUrl = recordingUrl;
    }

    public void setRecordingUrl(@Nullable URI recordingUrl) {
        this.recordingUrl = JsonNullable.of((Object)recordingUrl);
    }

    public Session status(@Nonnull Status status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @JsonProperty(value="status", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Status getStatus() {
        return this.status;
    }

    @JsonProperty(value="status", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(@Nonnull Status status) {
        this.status = status;
    }

    public Session room(@Nullable String room) {
        this.room = JsonNullable.of((Object)room);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getRoom() {
        return (String)this.room.orElse(null);
    }

    @JsonProperty(value="room", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getRoom_JsonNullable() {
        return this.room;
    }

    @JsonProperty(value="room", required=false)
    public void setRoom_JsonNullable(JsonNullable<String> room) {
        this.room = room;
    }

    public void setRoom(@Nullable String room) {
        this.room = JsonNullable.of((Object)room);
    }

    public Session speakers(@Nonnull List<SpeakerMinimal> speakers) {
        this.speakers = speakers;
        return this;
    }

    public Session addSpeakersItem(SpeakerMinimal speakersItem) {
        if (this.speakers == null) {
            this.speakers = new ArrayList<SpeakerMinimal>();
        }
        this.speakers.add(speakersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="speakers", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<SpeakerMinimal> getSpeakers() {
        return this.speakers;
    }

    @JsonProperty(value="speakers", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSpeakers(@Nonnull List<SpeakerMinimal> speakers) {
        this.speakers = speakers;
    }

    public Session questionAnswers(@Nonnull List<QuestionAnswerFull> questionAnswers) {
        this.questionAnswers = questionAnswers;
        return this;
    }

    public Session addQuestionAnswersItem(QuestionAnswerFull questionAnswersItem) {
        if (this.questionAnswers == null) {
            this.questionAnswers = new ArrayList<QuestionAnswerFull>();
        }
        this.questionAnswers.add(questionAnswersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="questionAnswers", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<QuestionAnswerFull> getQuestionAnswers() {
        return this.questionAnswers;
    }

    @JsonProperty(value="questionAnswers", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuestionAnswers(@Nonnull List<QuestionAnswerFull> questionAnswers) {
        this.questionAnswers = questionAnswers;
    }

    public Session categories(@Nonnull List<CategorySession> categories) {
        this.categories = categories;
        return this;
    }

    public Session addCategoriesItem(CategorySession categoriesItem) {
        if (this.categories == null) {
            this.categories = new ArrayList<CategorySession>();
        }
        this.categories.add(categoriesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="categories", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<CategorySession> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="categories", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCategories(@Nonnull List<CategorySession> categories) {
        this.categories = categories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Session session = (Session)o;
        return Objects.equals(this.id, session.id) && Objects.equals(this.title, session.title) && Session.equalsNullable(this.description, session.description) && Objects.equals(this.startsAt, session.startsAt) && Objects.equals(this.endsAt, session.endsAt) && Objects.equals(this.isServiceSession, session.isServiceSession) && Objects.equals(this.isPlenumSession, session.isPlenumSession) && Objects.equals(this.categoryItems, session.categoryItems) && Objects.equals(this.roomId, session.roomId) && Session.equalsNullable(this.liveUrl, session.liveUrl) && Session.equalsNullable(this.recordingUrl, session.recordingUrl) && Objects.equals((Object)this.status, (Object)session.status) && Session.equalsNullable(this.room, session.room) && Objects.equals(this.speakers, session.speakers) && Objects.equals(this.questionAnswers, session.questionAnswers) && Objects.equals(this.categories, session.categories);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, Session.hashCodeNullable(this.description), this.startsAt, this.endsAt, this.isServiceSession, this.isPlenumSession, this.categoryItems, this.roomId, Session.hashCodeNullable(this.liveUrl), Session.hashCodeNullable(this.recordingUrl), this.status, Session.hashCodeNullable(this.room), this.speakers, this.questionAnswers, this.categories});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Session {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startsAt: ").append(this.toIndentedString(this.startsAt)).append("\n");
        sb.append("    endsAt: ").append(this.toIndentedString(this.endsAt)).append("\n");
        sb.append("    isServiceSession: ").append(this.toIndentedString(this.isServiceSession)).append("\n");
        sb.append("    isPlenumSession: ").append(this.toIndentedString(this.isPlenumSession)).append("\n");
        sb.append("    categoryItems: ").append(this.toIndentedString(this.categoryItems)).append("\n");
        sb.append("    roomId: ").append(this.toIndentedString(this.roomId)).append("\n");
        sb.append("    liveUrl: ").append(this.toIndentedString(this.liveUrl)).append("\n");
        sb.append("    recordingUrl: ").append(this.toIndentedString(this.recordingUrl)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    room: ").append(this.toIndentedString(this.room)).append("\n");
        sb.append("    speakers: ").append(this.toIndentedString(this.speakers)).append("\n");
        sb.append("    questionAnswers: ").append(this.toIndentedString(this.questionAnswers)).append("\n");
        sb.append("    categories: ").append(this.toIndentedString(this.categories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTitle() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%stitle%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTitle()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStartsAt() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sstartsAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStartsAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEndsAt() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sendsAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getEndsAt()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIsServiceSession() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sisServiceSession%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsServiceSession()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getIsPlenumSession() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sisPlenumSession%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getIsPlenumSession()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCategoryItems() != null) {
            for (i = 0; i < this.getCategoryItems().size(); ++i) {
                try {
                    joiner.add(String.format(Locale.ROOT, "%scategoryItems%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCategoryItems().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getRoomId() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sroomId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRoomId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getLiveUrl() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sliveUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getLiveUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRecordingUrl() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%srecordingUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRecordingUrl()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getStatus() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getStatus()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRoom() != null) {
            try {
                joiner.add(String.format(Locale.ROOT, "%sroom%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRoom()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getSpeakers() != null) {
            for (i = 0; i < this.getSpeakers().size(); ++i) {
                if (this.getSpeakers().get(i) == null) continue;
                joiner.add(this.getSpeakers().get(i).toUrlQueryString(String.format(Locale.ROOT, "%sspeakers%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getQuestionAnswers() != null) {
            for (i = 0; i < this.getQuestionAnswers().size(); ++i) {
                if (this.getQuestionAnswers().get(i) == null) continue;
                joiner.add(this.getQuestionAnswers().get(i).toUrlQueryString(String.format(Locale.ROOT, "%squestionAnswers%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getCategories() != null) {
            for (i = 0; i < this.getCategories().size(); ++i) {
                if (this.getCategories().get(i) == null) continue;
                joiner.add(this.getCategories().get(i).toUrlQueryString(String.format(Locale.ROOT, "%scategories%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format(Locale.ROOT, "%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

