/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.service;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.xbill.DNS.Record;
import uk.num.numlib.dns.DNSServices;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;
import uk.num.numlib.exc.RrSetNoHeadersException;
import uk.num.numlib.util.BaseLookupGenerator;
import uk.num.numlib.util.DomainLookupGenerator;
import uk.num.numlib.util.EmailLookupGenerator;

public class IndependentRecordLookupService {
    public static final int MAX_SANE_NUMID_LENGTH = 255;
    private final DNSServices dnsServices;

    public LoadRecordResponse loadRecordFromIndependentZone(@NonNull String numIdName, @NonNull String path, int module, int timeoutMs) throws NumInvalidParameterException, NumInvalidDNSQueryException, RrSetIncompleteException, RrSetNoHeadersException, RrSetHeaderFormatException {
        if (numIdName == null) {
            throw new NullPointerException("numIdName is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        this.validateParameters(numIdName, path, module, timeoutMs);
        BaseLookupGenerator generator = numIdName.contains("@") ? new EmailLookupGenerator(numIdName + path) : new DomainLookupGenerator(numIdName + path);
        try {
            DNSServices.GetRecordResponse response = this.dnsServices.getRecordFromDnsNoCache(generator.getIndependentLocation(module), timeoutMs);
            Record[] records = response.getRecords();
            if (records != null && records.length > 0) {
                String record = this.dnsServices.rebuildTXTRecordContent(records);
                return new LoadRecordResponse(response.isSigned(), record);
            }
        }
        catch (NumNoRecordAvailableException e) {
            return null;
        }
        return null;
    }

    private void validateParameters(@NonNull String numIdName, @NonNull String path, int module, int timeoutMs) throws NumInvalidParameterException {
        if (numIdName == null) {
            throw new NullPointerException("numIdName is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        if (StringUtils.isBlank((CharSequence)numIdName) || numIdName.length() > 255) {
            throw new NumInvalidParameterException(String.format("numIdName is null, blank, or longer than 255 characters: '%s'", numIdName));
        }
        if (path.length() > 255) {
            throw new NumInvalidParameterException(String.format("path is longer than 255 characters: '%s'", path));
        }
        if (module < 0) {
            throw new NumInvalidParameterException("module number cannot be negative.");
        }
        if (timeoutMs <= 0) {
            throw new NumInvalidParameterException("timeoutMs cannot be negative or zero.");
        }
    }

    public IndependentRecordLookupService(DNSServices dnsServices) {
        this.dnsServices = dnsServices;
    }

    public static final class LoadRecordResponse {
        private final boolean isSigned;
        private final String record;

        public LoadRecordResponse(boolean isSigned, String record) {
            this.isSigned = isSigned;
            this.record = record;
        }

        public boolean isSigned() {
            return this.isSigned;
        }

        public String getRecord() {
            return this.record;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoadRecordResponse)) {
                return false;
            }
            LoadRecordResponse other = (LoadRecordResponse)o;
            if (this.isSigned() != other.isSigned()) {
                return false;
            }
            String this$record = this.getRecord();
            String other$record = other.getRecord();
            return !(this$record == null ? other$record != null : !this$record.equals(other$record));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSigned() ? 79 : 97);
            String $record = this.getRecord();
            result = result * 59 + ($record == null ? 43 : $record.hashCode());
            return result;
        }

        public String toString() {
            return "IndependentRecordLookupService.LoadRecordResponse(isSigned=" + this.isSigned() + ", record=" + this.getRecord() + ")";
        }
    }
}

