/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.dns;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TXTRecord;
import uk.num.numlib.dns.DNSServices;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;

public class DNSServicesDefaultImpl
implements DNSServices {
    private static final Logger log = LogManager.getLogger(DNSServicesDefaultImpl.class);
    public static final String MATCH_MULTIPART_RECORD_FRAGMENT = "(^\\d+\\|.*)|(\\d+\\/\\d+\\|@n=\\d+;.*)";
    private static final Predicate<Record> isCNAMEOrSPFRecord = r -> r.rdataToString().startsWith("v=spf") || r.rdataToString().startsWith("\"v=spf") || r.getType() == 5 || r.getType() == 99;

    @Override
    public String rebuildTXTRecordContent(Record[] records) throws RrSetHeaderFormatException, RrSetIncompleteException {
        assert (records != null && records.length > 0);
        StringBuilder buffer = new StringBuilder();
        HashMap<Integer, String> ordered = new HashMap<Integer, String>();
        int ignoredRecords = 0;
        int total = records.length;
        for (Record r : records) {
            TXTRecord record = (TXTRecord)r;
            List dataParts = record.getStrings();
            StringBuilder mergedDataParts = new StringBuilder();
            for (Object part : dataParts) {
                mergedDataParts.append(part.toString());
            }
            String data = mergedDataParts.toString();
            if (data.matches(MATCH_MULTIPART_RECORD_FRAGMENT)) {
                int pipeIndex = data.indexOf("|");
                String[] parts = new String[]{data.substring(0, pipeIndex), data.substring(pipeIndex + 1)};
                String substring = data.substring(parts[0].length() + 1);
                if (parts[0].contains("/")) {
                    ordered.put(0, substring);
                    String[] firstParts = parts[0].split("/");
                    if (firstParts.length == 2) {
                        try {
                            total = Integer.parseInt(firstParts[1]);
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new RrSetHeaderFormatException("Could not parse total parts ${firstParts[1]}");
                        }
                    }
                    throw new RrSetHeaderFormatException("First part should only contain 1 \"/\", format is incorrect!");
                }
                try {
                    int index = Integer.parseInt(parts[0]) - 1;
                    ordered.put(index, substring);
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new RrSetHeaderFormatException("Could not parse index ${parts[0]}");
                }
            }
            if (records.length == 1) {
                ordered.put(0, data);
                continue;
            }
            ++ignoredRecords;
        }
        if (total != records.length - ignoredRecords) {
            throw new RrSetIncompleteException("Parts and records length do not match, expected $total - $records");
        }
        for (int i = 0; i < ordered.size(); ++i) {
            buffer.append((String)ordered.get(i));
        }
        String result = buffer.toString();
        log.debug("Rebuilt DNS records: {}", (Object)result);
        return result;
    }

    @Override
    public DNSServices.GetRecordResponse getRecordFromDnsNoCache(String query, int timeoutMillis) throws NumInvalidDNSQueryException, NumNoRecordAvailableException {
        Record[] records;
        boolean signed;
        block5: {
            assert (timeoutMillis > 0);
            Resolver resolver = Lookup.getDefaultResolver();
            resolver.setTimeout(timeoutMillis / 1000, timeoutMillis % 1000);
            resolver.setIgnoreTruncation(false);
            try {
                Record queryTxtRecord = Record.newRecord((Name)new Name(query), (int)16, (int)1);
                Message queryMessage = Message.newQuery((Record)queryTxtRecord);
                log.debug("Sending DNS Query: {}", (Object)queryMessage);
                Message response = resolver.send(queryMessage);
                log.debug("Received DNS Response: {}", (Object)response);
                signed = response.isSigned();
                if (response.getRcode() == 0) {
                    records = response.getSectionArray(1);
                    if (Arrays.stream(records).anyMatch(isCNAMEOrSPFRecord)) {
                        throw new NumNoRecordAvailableException("Received CNAME or SPF record instead of TXT record.");
                    }
                    break block5;
                }
                return null;
            }
            catch (IOException e) {
                log.error("Error querying for NUM record.", (Throwable)e);
                throw new NumInvalidDNSQueryException("Invalid DNS query: " + query);
            }
        }
        return new DNSServices.GetRecordResponse(signed, records);
    }
}

