package uk.num.numlib.api;

/**
 * A definition of a user variable that needs a value obtained from the user.
 *
 * @author tonywalmsley
 */
public class RequiredUserVariable {
    /**
     * The prompt string describing what is needed from the user.
     */
    private String prompt;
    /**
     * The name of the variable
     */
    private String key;
    /**
     * The value obtained from the user.
     */
    private String value;

    /**
     * Accessor
     *
     * @return The prompt string.
     */
    public String getPrompt() {
        return prompt;
    }

    /**
     * Accessor
     *
     * @param prompt The prompt string.
     */
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    /**
     * Accessor
     *
     * @return The variable name string.
     */
    public String getKey() {
        return key;
    }

    /**
     * Accessor
     *
     * @param key The variable name string.
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * Accessor
     *
     * @return The value string.
     */
    public String getValue() {
        return value;
    }

    /**
     * Accessor
     *
     * @param value The variable value string.
     */
    public void setValue(String value) {
        this.value = value;
    }
}
