/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.internal.module;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import uk.num.numlib.api.RequiredUserVariable;

/**
 * A class to represent the Module Configuration data obtained from DNS.
 *
 * @author tonywalmsley
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Module {
    /**
     * The module name
     */
    private String name;
    /**
     * Default Encryption Algorithm: The algorithm used to encrypt and decrypt NUM records if no other algorithm is specified.
     */
    private String dea;
    /**
     * Required User Variables: Which variables (if any) must be collected by the client from the user, along with any prompts.
     */
    private RequiredUserVariable[] ruv;
    /**
     * Root Populated Record Query: Whether the client should run a pre-populated record query Content further up this document. for root records.
     */
    private boolean rprq;
    /**
     * Branch Populated Record Query: Whether the client should run a pre-populated record query Content further up this document. for branch records.
     */
    private boolean bprq;
    /**
     * Root Populator Service Query: Whether the client should run a populator query Content further up this document. for root records.
     */
    private boolean rpsq;
    /**
     * Branch Populator Service Query: Whether the client should run a populator query Content further up this document. for branch records.
     */
    private boolean bpsq;
    /**
     * DNS(SEC) Required: Whether records must be DNS(SEC) signed.
     */
    private boolean dsr;
    /**
     * Record Encryption Required: Whether records must be encrypted.
     */
    private boolean rer;

    /**
     * Default constructor
     */
    public Module() {
        ruv = new RequiredUserVariable[0];
    }

    /**
     * Accessor
     *
     * @return a RequiredUserVariable array.
     */
    public RequiredUserVariable[] getRuv() {
        return ruv;
    }

    /**
     * Accessor
     *
     * @param ruv the RequiredUserVariable array with populated values from the uer.
     */
    public void setRuv(final RequiredUserVariable[] ruv) {
        this.ruv = ruv;
    }

    /**
     * Accessor
     *
     * @return the module name.
     */
    public String getName() {
        return name;
    }

    /**
     * Accessor
     *
     * @param name the module name.
     */
    public void setName(final String name) {
        this.name = name;
    }

    /**
     * Accessor
     *
     * @return Default Encryption Algorithm
     */
    public String getDea() {
        return dea;
    }

    /**
     * Accessor
     *
     * @param dea Default Encryption Algorithm
     */
    public void setDea(final String dea) {
        this.dea = dea;
    }

    /**
     * Accessor
     *
     * @return true if the Root Populated Record Query should be attempted.
     */
    public boolean isRprq() {
        return rprq;
    }

    /**
     * Accessor
     *
     * @param rprq true if the Root Populated Record Query should be attempted.
     */
    public void setRprq(final boolean rprq) {
        this.rprq = rprq;
    }

    /**
     * Accessor
     *
     * @return true if the Branch Populated Record Query should be attempted.
     */
    public boolean isBprq() {
        return bprq;
    }

    /**
     * Accessor
     *
     * @param bprq true if the Branch Populated Record Query should be attempted.
     */
    public void setBprq(final boolean bprq) {
        this.bprq = bprq;
    }

    /**
     * Accessor
     *
     * @return true if the Root Populator Query should be attempted.
     */
    public boolean isRpsq() {
        return rpsq;
    }

    /**
     * Accessor
     *
     * @param rpsq true if the Root Populator Query should be attempted.
     */
    public void setRpsq(final boolean rpsq) {
        this.rpsq = rpsq;
    }

    /**
     * Accessor
     *
     * @return true if the Branch Populator Query should be attempted.
     */
    public boolean isBpsq() {
        return bpsq;
    }

    /**
     * Accessor
     *
     * @param bpsq true if the Branch Populator Query should be attempted.
     */
    public void setBpsq(final boolean bpsq) {
        this.bpsq = bpsq;
    }

    /**
     * Accessor
     *
     * @return true if DNSSEC is required.
     */
    public boolean isDsr() {
        return dsr;
    }

    /**
     * Accessor
     *
     * @param dsr true if DNSSEC is required.
     */
    public void setDsr(final boolean dsr) {
        this.dsr = dsr;
    }

    /**
     * Accessor
     *
     * @return true if record encryption is required.
     */
    public boolean isRer() {
        return rer;
    }

    /**
     * Accessor
     *
     * @param rer true if record encryption is required.
     */
    public void setRer(final boolean rer) {
        this.rer = rer;
    }
}
